/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPed;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.CancAntecTitulos;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercio;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.DuplicataTransporte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.FaturaTitulos;
import com.touchcomp.basementor.model.vo.GeracaoFaturamento;
import com.touchcomp.basementor.model.vo.GeracaoTituloPedido;
import com.touchcomp.basementor.model.vo.GrupoCompensacaoTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TipoOperacaoGeracaoFaturamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.VODevolucaoComprasVendas;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.titulos.AuxAdiantamentoViagem;
import mentorcore.utilities.impl.titulos.AuxApuracaoLocacaoContrato;
import mentorcore.utilities.impl.titulos.AuxContratoLocacao;
import mentorcore.utilities.impl.titulos.AuxCte;
import mentorcore.utilities.impl.titulos.AuxDuplicataTransporte;
import mentorcore.utilities.impl.titulos.AuxGeraTituloChequeTerceiros;
import mentorcore.utilities.impl.titulos.AuxGeracaoFaturamento;
import mentorcore.utilities.impl.titulos.AuxNotaContratoLocacao;
import mentorcore.utilities.impl.titulos.AuxNotaFiscalPropria;
import mentorcore.utilities.impl.titulos.AuxNotaFiscalTerceiros;
import mentorcore.utilities.impl.titulos.AuxPedido;
import mentorcore.utilities.impl.titulos.AuxPedidoComercio;
import mentorcore.utilities.impl.titulos.AuxRPS;
import mentorcore.utilities.impl.titulos.AuxRenegociacaoTitulos;
import mentorcore.utilities.impl.titulos.AuxRetornoCnabTituloAntecipado;
import mentorcore.utilities.impl.titulos.AuxTitulos;
import mentorcore.utilities.impl.titulos.AuxTitulosCancAntecTitulos;
import mentorcore.utilities.impl.titulos.AuxTitulosDevolucaoPedComercio;
import mentorcore.utilities.impl.titulos.AuxTitulosDevolucaoVendas;
import mentorcore.utilities.impl.titulos.AuxTitulosDistribuicaoSobraCooperado;
import mentorcore.utilities.impl.titulos.AuxTitulosFatura;
import mentorcore.utilities.impl.titulos.AuxTitulosPreFaturamentoPed;
import mentorcore.utilities.impl.titulos.AuxValidarTitulos;

public class UtilityTitulos {
    public List criarTitulos(CancAntecTitulos vo, OpcoesFinanceiras opcoes) throws ExceptionGeracaoTitulos {
        return new AuxTitulosCancAntecTitulos().criarTitulos(vo, opcoes);
    }

    public void criarTitulosGeracaoTituloPedido(GeracaoTituloPedido geracaoTitulosPedido, OpcoesFinanceiras opcoes, OpcoesFaturamento opFat, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        new AuxPedido().criarTitulosGeracaoTituloPedido(geracaoTitulosPedido, opcoes, opFat, opCont);
    }

    public void criarTitulos(Pedido vo, OpcoesFinanceiras opcoes, OpcoesFaturamento opFat, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        new AuxPedido().criarTitulos(vo, opcoes, opFat, opCont);
    }

    public void redefinirDatasValoresTitulosDePedidos(Pedido vo, OpcoesFinanceiras opcoes, OpcoesFaturamento opFat, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData, ExceptionInvalidData {
        new AuxPedido().atualizarDatasEValoresPedidos(vo, opcoes, opFat, opCont);
    }

    public void redefinirDatasValoresTitulosDePedidosGeracaoTituloPedido(GeracaoTituloPedido vo, OpcoesFinanceiras opcoes, OpcoesFaturamento opFat, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData, ExceptionInvalidData {
        new AuxPedido().atualizarDatasEValoresPedidosGeracaoTituloPedido(vo, opcoes, opFat, opCont);
    }

    public List criarTitulos(FaturaTitulos vo, Double valorTotal, OpcoesFinanceiras opcoes) throws ExceptionGeracaoTitulos {
        return new AuxTitulosFatura().criaTitulos(vo, valorTotal, opcoes);
    }

    public void criarTitulos(NotaFiscalTerceiros vo, EmpresaContabilidade cont, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        new AuxNotaFiscalTerceiros().criarTitulos(vo, opcoes, cont, opcoesContabeis);
    }

    public List criarTitulos(ContratoLocacao vo, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxContratoLocacao().criarTitulos(vo, opcoes, opcoesCont);
    }

    public List criarTitulos(NotaContratoLocacao vo, OpcoesFinanceiras opcoes, OpcoesLocacao opcoesLocacao, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxNotaContratoLocacao().criarTitulos(vo, opcoes, opcoesLocacao, opcoesCont);
    }

    public List criarTitulos(Rps vo, OpcoesFinanceiras opcoes, Date dataVencimento, OpcoesLocacao opcoesLocacao) throws ExceptionGeracaoTitulos {
        return new AuxRPS().criarTitulos(vo, opcoes, dataVencimento, opcoesLocacao);
    }

    public void criarTitulos(NotaFiscalPropria vo, OpcoesFinanceiras opcoes, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        new AuxNotaFiscalPropria().criarTitulos(vo, opcoes, empresaContabilidade, opcoesContabeis);
    }

    public void atualizarTitulos(UnidadeFatCliente unid, Empresa empresa, InfPagamentoNfPropria inf, Date dataPrimeiroTit) throws ExceptionGeracaoTitulos {
        new AuxNotaFiscalPropria().atualizarDtTitulos(unid, empresa, inf, dataPrimeiroTit);
    }

    public void atualizarRecalcComissaoTitulosNFBasePedido(NotaFiscalPropria vo, List titulos, OpcoesFinanceiras opFin) throws ExceptionService {
        new AuxNotaFiscalPropria().verificarSetarRepTitulos(vo, opFin);
    }

    public List criarTitulos(Cte vo, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesCont, EmpresaContabilidade empresaContabilidade) throws ExceptionGeracaoTitulos, ExceptionService, ExceptionInvalidData {
        return new AuxCte().criarTitulos(vo, opcoes, opcoesCont, empresaContabilidade);
    }

    public Titulo criarTitulos(AdiantamentoViagem vo, Titulo t, OpcoesFinanceiras opcoes, OpcoesGerenciais opcoesGerenciais) throws ExceptionGeracaoTitulos {
        return new AuxAdiantamentoViagem().criarTitulos(vo, t, opcoes, opcoesGerenciais);
    }

    public Titulo criarTitulos(Double valorTotalFechamento, AdiantamentoViagem vo, Titulo t, OpcoesFinanceiras opcoes, OpcoesGerenciais opcoesGerenciais) throws ExceptionGeracaoTitulos {
        return new AuxAdiantamentoViagem().criarTitulos(valorTotalFechamento, vo, t, opcoes, opcoesGerenciais);
    }

    public Titulo criarTitulos(DuplicataTransporte vo, Date dataEmissao, Date dataVencimento, Date dataCompetencia, OpcoesFinanceiras opcoesFinanceiras, Double valor, Double descFinancTitulo, Empresa empresa, OpcoesContabeis opCont) throws Exception {
        return new AuxDuplicataTransporte().criarTitulos(vo, dataEmissao, dataVencimento, dataCompetencia, opcoesFinanceiras, valor, descFinancTitulo, empresa, opCont);
    }

    public List criarTitulos(TipoOperacaoGeracaoFaturamento ti, GeracaoFaturamento vo, FaturaCte f, Titulo t, OpcoesContabeis opcoes) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxGeracaoFaturamento().criarTitulos(ti, vo, f, t, opcoes);
    }

    public List criarTitulos(PedidoComercio vo, PlanoContaGerencial pcAcrescimo, PlanoContaGerencial pcDesconto, OpcoesFinanceiras op, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxPedidoComercio().criarTitulos(vo, pcAcrescimo, pcDesconto, op, opcoesCont);
    }

    public List criarTitulos(RenegociacaoTitulos vo, OpcoesFinanceiras opcoes, List<Titulo> titulos, EmpresaContabilidade empresaContabilidade, Pessoa pessoaNovoTitulo, PlanoConta planoContaNovoTitulo) throws ExceptionGeracaoTitulos {
        return new AuxRenegociacaoTitulos().criarTitulos(vo, opcoes, titulos, empresaContabilidade, pessoaNovoTitulo, planoContaNovoTitulo);
    }

    public List criarTitulosUnicaForma(PedidoComercio vo, PlanoContaGerencial pcAcrescimo, PlanoContaGerencial pcDesconto, OpcoesFinanceiras op, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxPedidoComercio().criarTitulosUnicaForma(vo, pcAcrescimo, pcDesconto, op, opcoesCont);
    }

    public Double getValorTotalTitulos(List<Titulo> titulos) {
        return new AuxTitulos().getValorTotalTitulos(titulos);
    }

    public String getNrTituloBaixadoFromBDError(String msg) {
        return new AuxTitulos().getNrTituloBaixadoFromBDError(msg);
    }

    public void validarValoresTitulo(NotaFiscalPropria nf, EmpresaContabilidade empresaContabilidade, OpcoesFaturamento opFat, OpcoesContabeis opcoesContabeis) throws ExceptionValidation {
        new AuxNotaFiscalPropria().validarValoresTitulos(nf, empresaContabilidade, opFat, opcoesContabeis);
    }

    public void validarValoresTitulo(Cte ct) throws ExceptionValidation {
        new AuxCte().validarValoresTitulos(ct);
    }

    public void validarValoresTitulo(NotaFiscalTerceiros nf, OpcoesCompraSuprimentos opcoesCompra, OpcoesContabeis opcoesContabeis) throws ExceptionValidation {
        new AuxNotaFiscalTerceiros().validarValoresTitulos(nf, opcoesCompra, opcoesContabeis);
    }

    public void validarValoresTitulo(Pedido ped) throws ExceptionValidation {
        new AuxPedido().validarValoresTitulos(ped);
    }

    public void atualizaBCComissaoRepresentante(NotaFiscalPropria vo, OpcoesFinanceiras opFin) throws ExceptionService {
        new AuxNotaFiscalPropria().verificarSetarRepTitulos(vo, opFin);
    }

    public void atualizaBCComissaoRepresentante(Pedido vo, OpcoesFinanceiras opFinanceiras) throws ExceptionService {
        new AuxPedido().calculaBCComissaoRepresentante(vo, opFinanceiras);
    }

    public List criarTitulos(PreFaturamentoPed vo, OpcoesFinanceiras opcoes, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxTitulosPreFaturamentoPed().criarTitulos(vo, opcoes, opCont);
    }

    public void updateLancGerencial(Titulo vo) {
        if (vo != null && vo.getLancCtbGerencial() != null) {
            for (LancamentoCtbGerencial lanc : vo.getLancCtbGerencial()) {
                lanc.setDataCadastro(vo.getDataCompetencia());
                lanc.setDataPrevista(vo.getDataVencimento());
            }
        }
    }

    public List criarTitulos(ApuracaoLocacaoContrato vo, OpcoesFinanceiras opcoes, OpcoesLocacao opcoesLocacao, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxApuracaoLocacaoContrato().criarTitulos(vo, opcoes, opcoesLocacao, opcoesContabeis);
    }

    public Titulo criarTitulos(RetornoRecebimentoCnab retornoRecebimentoCnab, EmpresaFinanceiro empresaFinanceiro, Titulo titulo, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesCont) throws ExceptionService, ExceptionInvalidData {
        return new AuxRetornoCnabTituloAntecipado().criarTitulos(retornoRecebimentoCnab, empresaFinanceiro, titulo, empresaContabilidade, opcoesCont);
    }

    public void removerTitulosValor0(List<Titulo> titulos) {
        for (int i = 0; i < titulos.size(); ++i) {
            Titulo titulo = titulos.get(i);
            if (!(titulo.getValor() <= 0.0)) continue;
            titulos.remove(i);
        }
    }

    public void criarTituloDevolucaoCheque(CompensacaoChequeTerceiros vo, PlanoContaGerencial pcGer, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesContabeis opContabeis) {
        new AuxGeraTituloChequeTerceiros().criarTituloDevolucaoCheque(vo, pcGer, emp, opFinanceiras, opContabeis);
    }

    public void criarTituloDevolucaoCheque(GrupoCompensacaoTerceiros vo, PlanoContaGerencial pcGer, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesContabeis opContabeis) {
        for (CompensacaoChequeTerceiros c : vo.getCompensacaoChequesTerceiros()) {
            this.criarTituloDevolucaoCheque(c, pcGer, emp, opFinanceiras, opContabeis);
        }
    }

    public void validarTitulos(CondicoesPagamento p, OpcoesFinanceiras opcaoFinanceira, List<Titulo> titulos) throws ExceptionService {
        new AuxValidarTitulos().validarTitulos(p, opcaoFinanceira, titulos);
    }

    public Titulo criarTituloDevolucaoVendas(VODevolucaoComprasVendas vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, Date dataVencimento, Short pagRec, MeioPagamento meioPagamento, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxTitulosDevolucaoVendas().criarTituloDevolvido(vo, opcaoFinanceira, dataVencimento, empresaContabilidade, pagRec, meioPagamento, opcoesCont);
    }

    public Titulo criarTituloCreditoAntecipadoDevolucaoVendas(VODevolucaoComprasVendas vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, Short pagRec, Pessoa pessoa, PlanoConta planoConta, PlanoConta planoContaAntecipacao) throws ExceptionGeracaoTitulos {
        return new AuxTitulosDevolucaoVendas().criarTituloCreditoAntecipadoDevolucaoVendas(vo, opcaoFinanceira, empresaContabilidade, pagRec, pessoa, planoConta, planoContaAntecipacao);
    }

    public Titulo criarTituloDevolucaoVendas(DevolucaoVendas vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, Date dataVencimento, Short pagRec, MeioPagamento meioPagamento, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxTitulosDevolucaoVendas().criarTituloDevolvido(vo, opcaoFinanceira, dataVencimento, empresaContabilidade, pagRec, meioPagamento, opcoesCont);
    }

    public Titulo criarTituloCreditoAntecipadoDevolucaoPedComercio(DevolucaoPedComercio vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, Short pagRec, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        return new AuxTitulosDevolucaoPedComercio().criarTituloCreditoAntecipadoDevolucaoPedComercio(vo, opcaoFinanceira, empresaContabilidade, pagRec, opcoesCont);
    }

    public void criarTitulos(DistribuicaoSobraCooperado vo, OpcoesFinanceiras opcaoFinanceira) throws ExceptionGeracaoTitulos {
        new AuxTitulosDistribuicaoSobraCooperado().criarTitulos(vo, opcaoFinanceira);
    }

    public Object origemDocumentoTitulo(Titulo vo, int ColumnIndex) {
        if (vo.getInfPagamentoNfTerceiros() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getIdentificador();
                }
                case 1: {
                    return vo.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEmissao();
                }
                case 2: {
                    return vo.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota();
                }
                case 3: {
                    return vo.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getSerie();
                }
                case 4: {
                    return vo.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEntrada();
                }
                case 5: {
                    return "Nota Fiscal de Terceiros";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getFaturaCte() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getFaturaCte().getIdentificador();
                }
                case 1: {
                    return vo.getFaturaCte().getDataVencimento();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Fatura Transporte";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getOrdemCompra() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getOrdemCompra().getIdentificador();
                }
                case 1: {
                    return vo.getOrdemCompra().getDataEmissao();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getOrdemCompra().getDataPrevChegada();
                }
                case 5: {
                    return "Ordem de Compra";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getInfPagamentoPedido() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getInfPagamentoPedido().getPedido().getIdentificador();
                }
                case 1: {
                    return vo.getInfPagamentoPedido().getPedido().getDataEmissao();
                }
                case 2: {
                    if (vo.getInfPagamentoPedido().getPedido().getCodigoPedido() != null) {
                        return vo.getInfPagamentoPedido().getPedido().getCodigoPedido();
                    }
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getInfPagamentoPedido().getPedido().getDataPrevisaoFat();
                }
                case 5: {
                    return "Pedido";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getAdiantamentoViagem() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getAdiantamentoViagem().getIdentificador();
                }
                case 1: {
                    return vo.getAdiantamentoViagem().getDataEmissao();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getAdiantamentoViagem().getDataFechamento();
                }
                case 5: {
                    return "Adiantamento Viagem";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getInfPagamentoNfPropria() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getInfPagamentoNfPropria().getNotaFiscalPropria().getIdentificador();
                }
                case 1: {
                    return vo.getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEmissaoNota();
                }
                case 2: {
                    return vo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota();
                }
                case 3: {
                    return vo.getInfPagamentoNfPropria().getNotaFiscalPropria().getSerie();
                }
                case 4: {
                    return vo.getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEntradaSaida();
                }
                case 5: {
                    return "Nota Fiscal Pr\u00f3pria";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getFechamentoFolha() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getFechamentoFolha().getIdentificador();
                }
                case 1: {
                    return vo.getFechamentoFolha().getDataCadastro();
                }
                case 2: {
                    return vo.getFechamentoFolha().getIdentificador().intValue();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getFechamentoFolha().getDataCadastro();
                }
                case 5: {
                    return "Fechamento Periodo Folha";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getNotaContratoLocacao() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getNotaContratoLocacao().getIdentificador();
                }
                case 1: {
                    return vo.getNotaContratoLocacao().getDataEmissao();
                }
                case 2: {
                    return vo.getNotaContratoLocacao().getNumero().intValue();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getNotaContratoLocacao().getDataEmissao();
                }
                case 5: {
                    return "Nota Contrato Loca\u00e7\u00e3o";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getPedidoComercio() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getPedidoComercio().getIdentificador();
                }
                case 1: {
                    return vo.getPedidoComercio().getDataEmissao();
                }
                case 2: {
                    return vo.getPedidoComercio().getIdentificador().intValue();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getPedidoComercio().getDataEmissao();
                }
                case 5: {
                    return "Pedido comercio";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getTitulosFolha() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getTitulosFolha().getIdentificador();
                }
                case 1: {
                    return vo.getTitulosFolha().getDataCadastro();
                }
                case 2: {
                    return vo.getTitulosFolha().getIdentificador().intValue();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getTitulosFolha().getDataCadastro();
                }
                case 5: {
                    return "Gera\u00e7\u00e3o de Titulos por Folha de Pagamento";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getApuracaoLocacaoContrato() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getApuracaoLocacaoContrato().getApuracaoLocacao().getIdentificador();
                }
                case 1: {
                    return vo.getApuracaoLocacaoContrato().getApuracaoLocacao().getDataApuracao();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getApuracaoLocacaoContrato().getApuracaoLocacao().getDataApuracao();
                }
                case 5: {
                    return "Apuracao Locacao";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getRps() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getRps().getIdentificador();
                }
                case 1: {
                    return vo.getRps().getDataEmissao();
                }
                case 2: {
                    if (ToolMethods.isNotNull((Object)vo.getRps().getNumero()).booleanValue()) {
                        return vo.getRps().getNumero().intValue();
                    }
                    return 0L;
                }
                case 3: {
                    return vo.getRps().getSerie();
                }
                case 4: {
                    return vo.getRps().getDataExecucaoServico();
                }
                case 5: {
                    return "RPS";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getRenegociacaoTitulos() != null) {
            switch (ColumnIndex) {
                case 0: {
                    if (vo.getRenegociacaoTitulos().getIdentificador() != null) {
                        return vo.getRenegociacaoTitulos().getIdentificador();
                    }
                    return 0L;
                }
                case 1: {
                    return vo.getRenegociacaoTitulos().getDataEmissao();
                }
                case 2: {
                    if (vo.getRenegociacaoTitulos().getIdentificador() != null) {
                        return vo.getRenegociacaoTitulos().getIdentificador().intValue();
                    }
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getRenegociacaoTitulos().getDataEmissao();
                }
                case 5: {
                    return "Renegocia\u00e7\u00e3o de Titulos";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getCompensacaoChequeTerceiros() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getCompensacaoChequeTerceiros().getGrupoCompensacao().getIdentificador();
                }
                case 1: {
                    return vo.getCompensacaoChequeTerceiros().getDataCompensacao();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getCompensacaoChequeTerceiros().getDataCompensacao();
                }
                case 5: {
                    return "Compensacao cheque terceiros - Devolucao";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getCte() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getCte().getIdentificador();
                }
                case 1: {
                    return vo.getCte().getDataEmissao();
                }
                case 2: {
                    return vo.getCte().getNumero().intValue();
                }
                case 3: {
                    return vo.getCte().getSerie();
                }
                case 4: {
                    return vo.getCte().getDataEmissao();
                }
                case 5: {
                    return "CTe";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getDevolucaoVendas() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getDevolucaoVendas().getIdentificador();
                }
                case 1: {
                    return vo.getDevolucaoVendas().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Devolucao Vendas/Compras";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getRetornoCnabCobranca() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getRetornoCnabCobranca().getIdentificador();
                }
                case 1: {
                    return vo.getRetornoCnabCobranca().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Retorno CNAB";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getDevolucaoPedComercio() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getDevolucaoPedComercio().getIdentificador();
                }
                case 1: {
                    return vo.getDevolucaoPedComercio().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Devolucao Pedido Comercio";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getItemDistribuicaoSobraCooperado() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getItemDistribuicaoSobraCooperado().getDistribuicaoSobraCooperado().getIdentificador();
                }
                case 1: {
                    return vo.getItemDistribuicaoSobraCooperado().getDistribuicaoSobraCooperado().getDataFinal();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Distribuicao Sobra Cooperado";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getGeracaoTitulos() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getGeracaoTitulos().getIdentificador();
                }
                case 1: {
                    return vo.getGeracaoTitulos().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Gera\u00e7\u00e3o de T\u00edtulos";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getLancamentoCooperado() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getLancamentoCooperado().getIdentificador();
                }
                case 1: {
                    return vo.getLancamentoCooperado().getDataMovimento();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return "Lan\u00e7amento Cooperado";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getNfcePagamento() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getNfcePagamento().getNfce().getIdentificador();
                }
                case 1: {
                    return vo.getNfcePagamento().getNfce().getDataEmissao();
                }
                case 2: {
                    return vo.getNfcePagamento().getNfce().getNumero();
                }
                case 3: {
                    return vo.getNfcePagamento().getNfce().getSerie();
                }
                case 4: {
                    return vo.getNfcePagamento().getNfce().getDataPrevSaida();
                }
                case 5: {
                    return "NFCe";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getApuracaoTitulosCartaoDebCred() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getApuracaoTitulosCartaoDebCred().getIdentificador();
                }
                case 1: {
                    return vo.getApuracaoTitulosCartaoDebCred().getDataApuracao();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getApuracaoTitulosCartaoDebCred().getDataApuracao();
                }
                case 5: {
                    return "Apuracao Titulos Cartao Debito/Credito";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getLoteLancamentoCooperado() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getLoteLancamentoCooperado().getIdentificador();
                }
                case 1: {
                    return vo.getLoteLancamentoCooperado().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getLoteLancamentoCooperado().getDataCadastro();
                }
                case 5: {
                    return "Lote Lancamento Evt. Cooperado";
                }
            }
            return vo.getObservacao();
        }
        if (vo.getGeracaoOutrosTitulosFolha() != null) {
            switch (ColumnIndex) {
                case 0: {
                    return vo.getGeracaoOutrosTitulosFolha().getGeracaoOutrosTitulosFolha().getIdentificador();
                }
                case 1: {
                    return vo.getGeracaoOutrosTitulosFolha().getGeracaoOutrosTitulosFolha().getDataCadastro();
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vo.getGeracaoOutrosTitulosFolha().getGeracaoOutrosTitulosFolha().getDataCadastro();
                }
                case 5: {
                    return "Geracao Outros Titulos Folha";
                }
            }
            return vo.getObservacao();
        }
        return null;
    }

    public static String completarHistoricoPadrao(Titulo vo, String historicoFinal) {
        String st = historicoFinal;
        List token = ToolString.getReplaceTokens((String)st);
        HashMap<String, String> m = new HashMap<String, String>();
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            m.put(sk.getChave(), UtilityTitulos.getFixedValue(sk.getChave(), vo).toString());
        }
        st = ToolString.build((String)st, m);
        return st;
    }

    private static Object getFixedValue(String valor, Titulo t) {
        if (valor == null) {
            return "";
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"numeroTitulo")) {
            return t.getIdentificador().toString();
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"nrTitulo")) {
            return t.getIdentificador().toString();
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"nomePessoaTitulo")) {
            return t.getPessoa().getNome();
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"cfpPessoaTitulo")) {
            return t.getPessoa().getComplemento().getCnpj();
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"dtVencTitulo")) {
            return DateUtil.dateToStr(t.getDataVencimento());
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"nomePessoa")) {
            return t.getPessoa().getNome();
        }
        if (t != null && ToolMethods.isEquals((Object)valor, (Object)"dataVencimentoTitulo")) {
            DateUtil.dateToStr(t.getDataVencimento());
        } else {
            if (t != null && ToolMethods.isEquals((Object)valor, (Object)"tipodocFinanceiro")) {
                return t.getTipoDoc().getNome();
            }
            if (t != null && ToolMethods.isEquals((Object)valor, (Object)"observacao")) {
                return t.getObservacao();
            }
        }
        return "";
    }

    public Double getTotalImpostosRetidosNFTerceiros(NotaFiscalTerceiros vo) {
        Double tot = 0.0;
        for (ItemNotaTerceiros in : vo.getItemNotaTerceiros()) {
            if (ToolMethods.isEquals((Object)in.getIssRetido(), (Object)1)) {
                tot = tot + in.getItemNotaLivroFiscal().getVrIss();
            }
            tot = tot + in.getItemNotaLivroFiscal().getVrInss();
            tot = tot + in.getItemNotaLivroFiscal().getVrIrrf();
            tot = tot + in.getItemNotaLivroFiscal().getVrLei10833();
            tot = tot + in.getItemNotaLivroFiscal().getVrFunrural();
            tot = tot + in.getItemNotaLivroFiscal().getVrOutros();
            tot = tot + in.getItemNotaLivroFiscal().getVrPisSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrCofinsSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrContSoc();
            tot = tot + in.getItemNotaLivroFiscal().getValorSestSenat();
            tot = tot + in.getItemNotaLivroFiscal().getValorRat();
            tot = tot + in.getItemNotaLivroFiscal().getValorSenar();
            tot = tot + in.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal();
        }
        return tot;
    }

    public Double getTotalImpostosRetidosNFTerceirosReinf(NotaFiscalTerceiros vo) {
        Double tot = 0.0;
        for (ItemNotaTerceiros in : vo.getItemNotaTerceiros()) {
            if (ToolMethods.isEquals((Object)in.getIssRetido(), (Object)1)) {
                tot = tot + in.getItemNotaLivroFiscal().getVrIss();
            }
            tot = tot + in.getItemNotaLivroFiscal().getVrLei10833();
            tot = tot + in.getItemNotaLivroFiscal().getVrPisSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrCofinsSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrContSoc();
        }
        return tot;
    }

    public Double getTotalImpostosRetidosNFPropria(NotaFiscalPropria vo) {
        Double tot = 0.0;
        for (ItemNotaFiscalPropria in : vo.getItensNotaPropria()) {
            if (ToolMethods.isEquals((Object)in.getIssRetido(), (Object)1)) {
                tot = tot + in.getItemNotaLivroFiscal().getVrIss();
            }
            tot = tot + in.getItemNotaLivroFiscal().getVrInss();
            tot = tot + in.getItemNotaLivroFiscal().getVrIrrf();
            tot = tot + in.getItemNotaLivroFiscal().getVrLei10833();
            tot = tot + in.getItemNotaLivroFiscal().getVrFunrural();
            tot = tot + in.getItemNotaLivroFiscal().getVrOutros();
            tot = tot + in.getItemNotaLivroFiscal().getVrPisSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrCofinsSt();
            tot = tot + in.getItemNotaLivroFiscal().getVrContSoc();
            tot = tot + in.getItemNotaLivroFiscal().getValorSestSenat();
            tot = tot + in.getItemNotaLivroFiscal().getValorRat();
            tot = tot + in.getItemNotaLivroFiscal().getValorSenar();
            tot = tot + in.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal();
        }
        return tot;
    }
}

