/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.xmlstore;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperNotaPropria;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.xml.SCompXmlDocumentosNFeNFCeImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.util.CoreReportUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.jasperreports.auxiliar.FormImpressaoExporterPDF;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JasperPrint;

public class UtilXMLStore {
    private static TLogger logger = TLogger.get(UtilXMLStore.class);

    public static XMLNfePropria findCreateXMLNfePropria(NotaFiscalPropria notaFiscalPropria) throws Exception {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        XMLNfePropria x = service.getXMlNfePropria(notaFiscalPropria.getIdentificador());
        if (x == null) {
            x = new XMLNfePropria();
            x.setIdNotaPropria(notaFiscalPropria.getIdentificador());
        }
        return x;
    }

    public static void saveOrUpdateXMLNotaPropria(XMLNfePropria x) throws Exception {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        service.saveOrUpdate((Object)x);
    }

    public static File getNFeXMLFile(NotaFiscalPropria nf) throws Exception {
        return ((SCompXmlDocumentosNFeNFCeImpl)Context.get(SCompXmlDocumentosNFeNFCeImpl.class)).exportToFile(nf, System.getProperty("java.io.tmpdir"));
    }

    public static File gerarDANFE(NotaFiscalPropria nf) throws ExceptionService {
        try {
            JasperPrint jp = UtilXMLStore.getJasperPrintNotaPropria(nf);
            DataOutputBI out = new DataOutputBI(jp);
            File file = new FormImpressaoExporterPDF().buildOutputReport(out);
            File renamed = new File(file.getParent() + File.separator + "NFe-" + nf.getChaveNFE() + ".pdf");
            file.renameTo(renamed);
            return renamed;
        }
        catch (ExceptionExportRelatorio | ExceptionService ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao exportar os DANFE's." + ex.getMessage());
        }
    }

    private static JasperPrint getJasperPrintNotaPropria(NotaFiscalPropria nf) throws ExceptionService {
        String fileName = "";
        if (((HelperNotaPropria)Context.get(HelperNotaPropria.class)).isStatusAutorizada(nf)) {
            fileName = nf.getFormatoImpressao() == 1 ? "OUTROS_NFE_RETRATO_A4_XML.jasper" : "OUTROS_NFE_PAISAGEM_A4_XML.jasper";
        } else if (EnumConstNFeStatus.isStatusCancelada((Integer)nf.getStatus().intValue())) {
            if (nf.getFormatoImpressao() == 1) {
                fileName = "OUTROS_NFE_CANCELADO_RETRATO_A4_XML.jasper";
            } else {
                throw new ExceptionService("N\u00e3o h\u00e1 impress\u00e3o dispon\u00edvel para DANFE cancelados em formato paisagem!");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chaveAuxCont", nf.getChaveNFEAuxCont());
        params.put("SUBREPORT_DIR_OUTR", CoreReportUtil.getSubReportDirOutros());
        params.put("LOGO_RELATORIO", UtilXMLStore.getLogoEmpresa(nf));
        if (nf.getDpecNFe() != null) {
            params.put("PROTOCOLO_DPEC", nf.getDpecNFe().getNrProtocolo());
            params.put("DATA_PROTOCOLO_DPEC", nf.getDpecNFe().getDataHoraProt());
            params.put("DPEC_EPEC", 0);
        }
        if (nf.getEvtentoEpec() != null) {
            params.put("PROTOCOLO_DPEC", nf.getEvtentoEpec().getNrProtocolo());
            params.put("DATA_PROTOCOLO_DPEC", nf.getEvtentoEpec().getDataHoraProt());
            params.put("DPEC_EPEC", 1);
        }
        try {
            String nota = ((SCompXmlDocumentosNFeNFCeImpl)Context.get(SCompXmlDocumentosNFeNFCeImpl.class)).exportToString(nf);
            CoreRequestContext cq = new CoreRequestContext();
            cq.setAttribute("path", CoreReportUtil.getPathOutros() + fileName);
            cq.setAttribute("parametros", params);
            cq.setAttribute("inputStream", new ByteArrayInputStream(nota.getBytes()));
            cq.setAttribute("tagInicio", "/nfeProc/NFe/infNFe");
            return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(cq, "getJasperPrintXMLSource");
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao exportar os DANFE's." + ex.getMessage());
        }
    }

    public static File gerarXML(NotaFiscalPropria nf) throws ExceptionService {
        try {
            return UtilXMLStore.getNFeXMLFile(nf);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar o xml.");
        }
    }

    public static File getNFeXMLEventoNFeFile(EventoNFe e) throws ExceptionFileManipulation {
        return CoreUtilityFactory.getUtilityNFe().recordToFileEventoNFe(e, System.getProperty("java.io.tmpdir"));
    }

    private static byte[] getBytesImage(Empresa empresa) {
        byte[] img = null;
        if (empresa.getEmpresaDados().getLogoRelatorios() != null) {
            img = empresa.getEmpresaDados().getLogoRelatorios();
        }
        return img;
    }

    private static Object getLogoEmpresa(NotaFiscalPropria nf) {
        if (UtilXMLStore.getBytesImage(nf.getEmpresa()) != null) {
            return JRImageRenderer.getInstance((byte[])UtilXMLStore.getBytesImage(nf.getEmpresa()));
        }
        return null;
    }
}

