/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane;

import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.SaneIOMetadata;
import uk.co.mmscomputing.device.sane.gui.SanePanel;
import uk.co.mmscomputing.device.sane.jsane;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;

public class SaneScanner
extends Scanner {
    public SaneScanner() {
        this.metadata = new SaneIOMetadata();
    }

    public boolean isAPIInstalled() {
        return jsane.isInstalled();
    }

    public void select() throws ScannerIOException {
        jsane.select(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDeviceNames() {
        String[] stringArray = new String[]{};
        try {
            jsane.init();
            try {
                stringArray = jsane.getDeviceManager().getDevices();
            }
            finally {
                jsane.exit();
            }
        }
        catch (Exception exception) {
            this.metadata.setException(exception);
            this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
        }
        return stringArray;
    }

    SaneDevice getSelectedDevice() throws ScannerIOException {
        return jsane.getDeviceManager().getDevice();
    }

    public String getSelectedDeviceName() throws ScannerIOException {
        return this.getSelectedDevice().getName();
    }

    public void select(String string) throws ScannerIOException {
        jsane.select(this, string);
    }

    public void acquire() throws ScannerIOException {
        jsane.acquire(this);
    }

    public void setCancel(boolean bl) throws ScannerIOException {
        jsane.setCancel(this, bl);
    }

    void negotiateOptions(SaneDevice saneDevice) {
        ((SaneIOMetadata)this.metadata).setDevice(saneDevice);
        this.fireListenerUpdate(ScannerIOMetadata.NEGOTIATE);
        saneDevice.setCancel(this.metadata.getCancel());
    }

    public void setImage(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.metadata.setImage(bufferedImage);
            this.fireListenerUpdate(ScannerIOMetadata.ACQUIRED);
        }
    }

    void setState(SaneDevice saneDevice) {
        this.metadata.setState(saneDevice.getState());
        ((SaneIOMetadata)this.metadata).setDevice(saneDevice);
        this.fireListenerUpdate(ScannerIOMetadata.STATECHANGE);
    }

    void signalException(Exception exception) {
        this.metadata.setException(exception);
        this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }

    public JComponent getScanGUI() {
        return new SanePanel(this, 4);
    }

    public JComponent getScanGUI(int n) {
        return new SanePanel(this, n);
    }

    public static Scanner getDevice() {
        SaneScanner saneScanner = new SaneScanner();
        return saneScanner;
    }
}

