/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane;

import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import uk.co.mmscomputing.device.sane.OptionDescriptor;
import uk.co.mmscomputing.device.sane.Parameters;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.SaneDeviceManager;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.SaneScanner;
import uk.co.mmscomputing.util.JarLib;
import uk.co.mmscomputing.util.UtilResources;

public class jsane {
    private static SaneDeviceManager manager;
    private static WeakReference scanner;
    private static boolean isinstalled;
    private static UtilResources resources;
    static /* synthetic */ Class class$uk$co$mmscomputing$device$sane$jsane;

    public static native void init() throws SaneIOException;

    public static native void exit();

    public static native String[] getDevices(boolean var0) throws SaneIOException;

    public static native int open(String var0) throws SaneIOException;

    public static native void close(int var0);

    public static native OptionDescriptor getOptionDescriptor(int var0, int var1);

    public static native void getControlOption(int var0, int var1, byte[] var2) throws SaneIOException;

    public static native int setControlOption(int var0, int var1, byte[] var2) throws SaneIOException;

    public static native void setAutoControlOption(int var0, int var1) throws SaneIOException;

    public static native void getParameters(int var0, Parameters var1) throws SaneIOException;

    public static native void start(int var0) throws SaneIOException;

    public static native int read(int var0, byte[] var1, int var2, int var3) throws SaneIOException;

    public static native void cancel(int var0);

    public static native void setIOMode(int var0, boolean var1) throws SaneIOException;

    public static native int getSelectFD(int var0) throws SaneIOException;

    public static native String strStatus(int var0);

    public static boolean isInstalled() {
        return isinstalled;
    }

    public static native int getVersion();

    public static native int getWordControlOption(int var0, int var1) throws SaneIOException;

    public static native int setWordControlOption(int var0, int var1, int var2) throws SaneIOException;

    protected static native void getWordArrayControlOption(int var0, int var1, int[] var2) throws SaneIOException;

    protected static native int setWordArrayControlOption(int var0, int var1, int[] var2) throws SaneIOException;

    protected static native String getStringControlOption(int var0, int var1, int var2) throws SaneIOException;

    protected static native int setStringControlOption(int var0, int var1, int var2, String var3) throws SaneIOException;

    public static int getNumberOfOptions(int n) throws SaneIOException {
        return jsane.getWordControlOption(n, 0);
    }

    public static void setScanner(SaneScanner saneScanner) {
        scanner = new WeakReference<SaneScanner>(saneScanner);
    }

    private static SaneScanner getScanner() {
        return (SaneScanner)scanner.get();
    }

    static SaneDeviceManager getDeviceManager() {
        return manager;
    }

    static void checkInstalled() throws SaneIOException {
        if (!isinstalled) {
            throw new SaneIOException(class$uk$co$mmscomputing$device$sane$jsane == null ? (class$uk$co$mmscomputing$device$sane$jsane = jsane.class$("uk.co.mmscomputing.device.sane.jsane")) : class$uk$co$mmscomputing$device$sane$jsane, "checkInstalled", "jsane.err.isnotinstalled");
        }
    }

    public static void select(SaneScanner saneScanner) throws SaneIOException {
        jsane.checkInstalled();
        manager.getDevice().checkBusy();
        jsane.setScanner(saneScanner);
        manager.selectDevice();
    }

    public static void select(SaneScanner saneScanner, String string) throws SaneIOException {
        jsane.checkInstalled();
        manager.getDevice().checkBusy();
        jsane.setScanner(saneScanner);
        manager.selectDevice(string);
    }

    public static void acquire(SaneScanner saneScanner) throws SaneIOException {
        jsane.checkInstalled();
        manager.getDevice().checkBusy();
        jsane.setScanner(saneScanner);
        final SaneDevice saneDevice = manager.getDevice();
        new Thread(){

            public void run() {
                saneDevice.acquire();
            }
        }.start();
    }

    public static void setCancel(SaneScanner saneScanner, boolean bl) throws SaneIOException {
        SaneDevice saneDevice = manager.getDevice();
        if (saneDevice == null) {
            return;
        }
        jsane.checkInstalled();
        jsane.setScanner(saneScanner);
        saneDevice.setCancel(bl);
    }

    static void negotiateOptions(SaneDevice saneDevice) {
        SaneScanner saneScanner = jsane.getScanner();
        if (saneScanner != null) {
            saneScanner.negotiateOptions(saneDevice);
        }
    }

    static void signalImage(BufferedImage bufferedImage) {
        SaneScanner saneScanner;
        if (bufferedImage != null && (saneScanner = jsane.getScanner()) != null) {
            saneScanner.setImage(bufferedImage);
        }
    }

    static void signalStateChange(SaneDevice saneDevice) {
        SaneScanner saneScanner = jsane.getScanner();
        if (saneScanner != null) {
            saneScanner.setState(saneDevice);
        }
    }

    static void signalException(Exception exception) {
        SaneScanner saneScanner = jsane.getScanner();
        if (saneScanner != null) {
            saneScanner.signalException(exception);
        }
    }

    public static String getResource(String string) {
        return resources.getString(string);
    }

    public static String getResource(String string, String string2) {
        return resources.getString(string, string2);
    }

    public static String getResource(String string, String[] stringArray) {
        return resources.getString(string, stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resources = new UtilResources(class$uk$co$mmscomputing$device$sane$jsane == null ? (class$uk$co$mmscomputing$device$sane$jsane = jsane.class$("uk.co.mmscomputing.device.sane.jsane")) : class$uk$co$mmscomputing$device$sane$jsane);
        isinstalled = JarLib.load(class$uk$co$mmscomputing$device$sane$jsane == null ? (class$uk$co$mmscomputing$device$sane$jsane = jsane.class$("uk.co.mmscomputing.device.sane.jsane")) : class$uk$co$mmscomputing$device$sane$jsane, "jsane");
        if (isinstalled) {
            manager = new SaneDeviceManager();
        }
    }
}

