/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.option;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.option.DescriptorPanel;
import uk.co.mmscomputing.device.sane.option.IntList;

public class IntListPanel
extends DescriptorPanel {
    JComboBox[] combos = null;

    public IntListPanel(IntList intList) {
        super(intList);
        int n;
        String[] stringArray = new String[intList.list.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = Integer.toString(intList.list[n]);
        }
        n = intList.size >> 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, 1));
        this.combos = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            jPanel.add(this.createPanel(i, stringArray));
        }
        this.addValuePanel(new JScrollPane(jPanel));
    }

    private JPanel createPanel(int n, String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setMinimumSize(new Dimension(200, 100));
        jComboBox.setMaximumRowCount(5);
        jComboBox.addActionListener(this);
        this.checkCapabilities(jComboBox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(jComboBox);
        jComboBox.setSelectedItem(this.od.getStringValue(n));
        this.combos[n] = jComboBox;
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        for (int i = 0; i < this.combos.length; ++i) {
            if (this.combos[i] != jComboBox) continue;
            String string = jComboBox.getSelectedItem().toString();
            try {
                string = this.od.setStringValue(i, string);
                jComboBox.setSelectedItem(string);
                continue;
            }
            catch (SaneIOException saneIOException) {
                saneIOException.printStackTrace();
            }
        }
    }
}

