/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.util.Hashtable;
import javax.swing.text.Segment;
import novaworx.syntax.KeywordMap;
import novaworx.syntax.ParserRule;
import novaworx.syntax.ParserRuleFactory;
import novaworx.syntax.Syntax;

public class ParserRuleSet {
    private static final int RULE_BUCKET_COUNT = 32;
    private String msName;
    private Syntax moSyntax;
    private Hashtable mhProperties;
    private KeywordMap moKeywords;
    private ParserRule[] maRuleMapFirst;
    private ParserRule[] maRuleMapLast;
    private ParserRule moEscapeRule;
    private Segment moEscapePattern;
    private int miTerminateChar = -1;
    private boolean mbIgnoreCase;
    private boolean mbHighlightDigits;
    private byte myDefaultToken;

    public ParserRuleSet(String asName, Syntax aoSyntax) {
        this.msName = asName;
        this.moSyntax = aoSyntax;
        this.maRuleMapFirst = new ParserRule[32];
        this.maRuleMapLast = new ParserRule[32];
    }

    public Syntax getSyntax() {
        return this.moSyntax;
    }

    public Hashtable getProperties() {
        return this.mhProperties;
    }

    public void setProperties(Hashtable ahProperties) {
        this.mhProperties = ahProperties;
    }

    public void addRule(ParserRule aoRule) {
        int iKey = Character.toUpperCase(aoRule.maSearchChars[0]) % 32;
        ParserRule oLastRule = this.maRuleMapLast[iKey];
        if (oLastRule == null) {
            this.maRuleMapFirst[iKey] = this.maRuleMapLast[iKey] = aoRule;
        } else {
            oLastRule.moNext = aoRule;
            this.maRuleMapLast[iKey] = aoRule;
        }
    }

    public ParserRule getRules(char acChar) {
        int iKey = Character.toUpperCase(acChar) % 32;
        return this.maRuleMapFirst[iKey];
    }

    public int getTerminateChar() {
        return this.miTerminateChar;
    }

    public void setTerminateChar(int aiChar) {
        this.miTerminateChar = aiChar >= 0 ? aiChar : -1;
    }

    public boolean getIgnoreCase() {
        return this.mbIgnoreCase;
    }

    public void setIgnoreCase(boolean abIgnoreCase) {
        this.mbIgnoreCase = abIgnoreCase;
    }

    public KeywordMap getKeywords() {
        return this.moKeywords;
    }

    public void setKeywords(KeywordMap aoKeywords) {
        this.moKeywords = aoKeywords;
    }

    public boolean getHighlightDigits() {
        return this.mbHighlightDigits;
    }

    public void setHighlightDigits(boolean abHighlightDigits) {
        this.mbHighlightDigits = abHighlightDigits;
    }

    public ParserRule getEscapeRule() {
        return this.moEscapeRule;
    }

    public Segment getEscapePattern() {
        if (this.moEscapePattern == null && this.moEscapeRule != null) {
            this.moEscapePattern = new Segment(this.moEscapeRule.maSearchChars, 0, this.moEscapeRule.maSequenceLengths[0]);
        }
        return this.moEscapePattern;
    }

    public void setEscape(String asEscape) {
        this.moEscapeRule = asEscape == null ? null : ParserRuleFactory.createEscapeRule(asEscape);
        this.moEscapePattern = null;
    }

    public byte getDefault() {
        return this.myDefaultToken;
    }

    public void setDefault(byte ayDefault) {
        this.myDefaultToken = ayDefault;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.moSyntax.getName() + "::" + this.msName + "]";
    }
}

