/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import novaworx.log.Log;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxCatalogHandler;
import novaworx.syntax.SyntaxHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SyntaxFactory {
    public static final String DEFAULT_SYNTAX_NAME = "default";
    private static URL moCatalog;
    private static Hashtable mhSyntaxes;
    private static SAXParser moParser;
    private static SyntaxCatalogHandler moCatalogHandler;
    private static SyntaxHandler moSyntaxHandler;
    private static final String DEFAULT_SYNTAX_DEFINITION = "<?xml version=\"1.0\"?><!DOCTYPE MODE SYSTEM \"syntax.dtd\"><MODE><RULES><TERMINATE AT_CHAR=\"0\"/></RULES></MODE>";

    private SyntaxFactory() {
    }

    public static void setSyntaxCatalog(URL aoCatatog) {
        moCatalog = aoCatatog;
    }

    public static void addSyntax(Syntax aoSyntax) {
        if (aoSyntax == null) {
            return;
        }
        String sName = aoSyntax.getName();
        mhSyntaxes.put(sName.intern(), aoSyntax);
        Log.write(2, "Syntax added: " + sName);
    }

    public static boolean loadSyntaxes() {
        Syntax oUnknownSyntax = new Syntax(DEFAULT_SYNTAX_NAME);
        SyntaxFactory.addSyntax(oUnknownSyntax);
        return SyntaxFactory.loadSyntaxCatalog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadSyntaxCatalog() {
        URL oCatalog = moCatalog;
        if (oCatalog == null) {
            return false;
        }
        InputSource oInputSource = null;
        try {
            oInputSource = new InputSource(oCatalog.openStream());
        }
        catch (IOException aoException) {
            oInputSource = null;
        }
        if (oInputSource == null) {
            return false;
        }
        oInputSource.setSystemId("catalog.dtd");
        Log.write(3, "Loading syntaxes from catalog: " + oCatalog);
        try {
            SAXParser aoException = moParser;
            synchronized (aoException) {
                moParser.parse(moCatalog.toString(), (DefaultHandler)moCatalogHandler);
            }
            return true;
        }
        catch (SAXParseException aoException) {
            Log.write(4, "Line: " + aoException.getLineNumber() + "  Column: " + aoException.getColumnNumber());
            Log.write(4, aoException);
            Log.write(4, aoException.getException());
        }
        catch (SAXException aoException) {
            Log.write(4, aoException);
        }
        catch (IOException aoException) {
            Log.write(4, aoException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGrammar(Syntax aoSyntax) {
        Object sGrammar;
        if (moParser == null) {
            return;
        }
        String sName = aoSyntax.getName();
        InputSource oInputSource = null;
        if (DEFAULT_SYNTAX_NAME.equals(sName)) {
            oInputSource = new InputSource(new StringReader(DEFAULT_SYNTAX_DEFINITION));
        } else {
            sGrammar = (String)aoSyntax.getProperty("grammar");
            String path = moCatalog.toString();
            try {
                URL oGrammarFile = new URL(path.substring(0, path.lastIndexOf(47) + 1) + (String)sGrammar);
                oInputSource = new InputSource(oGrammarFile.openStream());
            }
            catch (IOException aoException) {
                oInputSource = null;
            }
        }
        if (oInputSource == null) {
            return;
        }
        oInputSource.setSystemId("syntax.dtd");
        try {
            sGrammar = moParser;
            synchronized (sGrammar) {
                moSyntaxHandler.setSyntax(aoSyntax);
                moParser.parse(oInputSource, (DefaultHandler)moSyntaxHandler);
            }
        }
        catch (SAXParseException aoException) {
            Log.write(4, "Line: " + aoException.getLineNumber() + "  Column: " + aoException.getColumnNumber());
            Log.write(4, aoException);
            Log.write(4, aoException.getException());
        }
        catch (SAXException aoException) {
            Log.write(4, aoException);
        }
        catch (IOException aoException) {
            Log.write(4, aoException);
        }
        finally {
            moSyntaxHandler.setSyntax(null);
        }
        Log.write(3, "Grammar loaded: " + sName);
    }

    public static Syntax getSyntax(String asName) {
        if (asName == null) {
            asName = DEFAULT_SYNTAX_NAME;
        }
        return (Syntax)mhSyntaxes.get(asName);
    }

    public static String getSyntaxName(Syntax aoSyntax) {
        return aoSyntax.getName();
    }

    public static Syntax[] getSyntaxes() {
        Syntax[] aSyntaxes = new Syntax[mhSyntaxes.size()];
        Enumeration oValues = mhSyntaxes.elements();
        int iIndex = 0;
        while (oValues.hasMoreElements()) {
            Syntax oSyntax;
            aSyntaxes[iIndex] = oSyntax = (Syntax)oValues.nextElement();
            ++iIndex;
        }
        return aSyntaxes;
    }

    static {
        mhSyntaxes = new Hashtable();
        try {
            moParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception aoException) {
            Log.write(4, aoException);
        }
        moCatalogHandler = new SyntaxCatalogHandler();
        moSyntaxHandler = new SyntaxHandler();
    }
}

