/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.util.Hashtable;
import javax.swing.text.Segment;
import novaworx.log.Log;
import novaworx.syntax.KeywordMap;
import novaworx.syntax.ParserRule;
import novaworx.syntax.ParserRuleSet;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;
import novaworx.syntax.SyntaxLineContext;
import novaworx.syntax.SyntaxTokenList;

public class TokenMarker {
    public static final int MAJOR_ACTIONS = 255;
    public static final int WHITESPACE = 1;
    public static final int SPAN = 2;
    public static final int MARK_PREVIOUS = 4;
    public static final int MARK_FOLLOWING = 8;
    public static final int EOL_SPAN = 16;
    public static final int ACTION_HINTS = 65280;
    public static final int EXCLUDE_MATCH = 256;
    public static final int AT_LINE_START = 512;
    public static final int NO_LINE_BREAK = 1024;
    public static final int NO_WORD_BREAK = 2048;
    public static final int IS_ESCAPE = 4096;
    public static final int DELEGATE = 8192;
    private static final int SOFT_SPAN = 2056;
    private String msName;
    private String msRulePrefix;
    private Hashtable mhRuleSets = new Hashtable(64);
    private ParserRuleSet moMainRuleSet;
    private SyntaxLineContext moOriginalContext;
    private SyntaxLineContext moContext;
    private Segment moPattern = new Segment();
    private int miLastOffset;
    private int miLastKeyword;
    private int miLineLength;
    private int miPosition;
    private boolean mbEscaped;

    public void addRuleSet(String asName, ParserRuleSet aoRules) {
        if (aoRules == null) {
            return;
        }
        if (asName == null) {
            asName = "MAIN";
        }
        this.mhRuleSets.put(this.msRulePrefix.concat(asName), aoRules);
        if ("MAIN".equals(asName)) {
            this.moMainRuleSet = aoRules;
        }
    }

    public ParserRuleSet getMainRuleSet() {
        return this.moMainRuleSet;
    }

    public ParserRuleSet getRuleSet(String asName) {
        ParserRuleSet oRules = (ParserRuleSet)this.mhRuleSets.get(asName);
        if (oRules == null && !asName.startsWith(this.msRulePrefix)) {
            int iDelimiter = asName.indexOf("::");
            String sSyntaxName = asName.substring(0, iDelimiter);
            Syntax oSyntax = SyntaxFactory.getSyntax(sSyntaxName);
            if (oSyntax == null) {
                Log.write(4, "Unknown syntax: " + sSyntaxName);
                oRules = null;
            } else {
                TokenMarker oMarker = oSyntax.getTokenMarker();
                oRules = oMarker.getRuleSet(asName);
                this.mhRuleSets.put(asName, oRules);
            }
        }
        if (oRules == null) {
            Log.write(4, "Unresolved delegate target: " + asName);
        }
        return oRules;
    }

    public String getName() {
        return this.msName;
    }

    public void setName(String asName) {
        if (asName == null) {
            throw new NullPointerException();
        }
        this.msName = asName;
        this.msRulePrefix = asName.concat("::");
    }

    /*
     * Enabled aggressive block sorting
     */
    public SyntaxLineContext markTokens(Segment aoSegment, SyntaxLineContext aoContext) {
        this.moContext = aoContext;
        SyntaxTokenList aoTokenList = new SyntaxTokenList();
        this.miLastOffset = this.miLastKeyword = aoSegment.offset;
        this.miLineLength = aoSegment.count + aoSegment.offset;
        int iTerminateChar = this.moContext.moRules.getTerminateChar();
        int iSearchLimit = iTerminateChar >= 0 && iTerminateChar < aoSegment.count ? aoSegment.offset + iTerminateChar : this.miLineLength;
        this.mbEscaped = false;
        this.miPosition = aoSegment.offset;
        while (true) {
            block23: {
                ParserRule oRule;
                block26: {
                    block21: {
                        block25: {
                            block24: {
                                boolean bKeepGoing;
                                block22: {
                                    if (this.miPosition >= iSearchLimit) break block21;
                                    if (this.moContext.moParent == null) break block22;
                                    SyntaxLineContext oTempContext = this.moContext;
                                    this.moContext = this.moContext.moParent;
                                    this.moPattern.array = this.moContext.moInRule.maSearchChars;
                                    this.moPattern.count = this.moContext.moInRule.maSequenceLengths[1];
                                    this.moPattern.offset = this.moContext.moInRule.maSequenceLengths[0];
                                    bKeepGoing = this.handleRule(aoTokenList, aoSegment, this.moContext.moInRule);
                                    this.moContext = oTempContext;
                                    if (bKeepGoing) break block22;
                                    if (this.mbEscaped) {
                                        this.mbEscaped = false;
                                    } else {
                                        if (this.miPosition != this.miLastOffset) {
                                            if (this.moContext.moInRule == null) {
                                                this.markKeyword(aoTokenList, aoSegment, this.miLastKeyword, this.miPosition);
                                                aoTokenList.addToken(this.miPosition - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
                                            } else if ((this.moContext.moInRule.miAction & 0xC00) == 0) {
                                                aoTokenList.addToken(this.miPosition - this.miLastOffset, this.moContext.moInRule.myToken, this.moContext.moRules);
                                            } else {
                                                aoTokenList.addToken(this.miPosition - this.miLastOffset, (byte)16, this.moContext.moRules);
                                            }
                                        }
                                        this.moContext = (SyntaxLineContext)this.moContext.moParent.clone();
                                        if ((this.moContext.moInRule.miAction & 0x100) == 256) {
                                            aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                                        } else {
                                            aoTokenList.addToken(this.moPattern.count, this.moContext.moInRule.myToken, this.moContext.moRules);
                                        }
                                        this.moContext.moInRule = null;
                                        this.miLastKeyword = this.miLastOffset = this.miPosition + this.moPattern.count;
                                    }
                                    this.miPosition += this.moPattern.count - 1;
                                    break block23;
                                }
                                if ((oRule = this.moContext.moRules.getEscapeRule()) == null) break block24;
                                Segment oTempPattern = this.moPattern;
                                this.moPattern = this.moContext.moRules.getEscapePattern();
                                boolean bTempEscaped = this.mbEscaped;
                                bKeepGoing = this.handleRule(aoTokenList, aoSegment, oRule);
                                this.moPattern = oTempPattern;
                                if (bKeepGoing) break block24;
                                if (bTempEscaped) {
                                    this.mbEscaped = false;
                                }
                                break block23;
                            }
                            if ((oRule = this.moContext.moInRule) == null || (oRule.miAction & 2) != 2) break block25;
                            this.moPattern.array = oRule.maSearchChars;
                            this.moPattern.count = oRule.maSequenceLengths[1];
                            this.moPattern.offset = oRule.maSequenceLengths[0];
                            if (this.handleRule(aoTokenList, aoSegment, oRule) && (oRule.miAction & 0x808) != 0) break block25;
                            this.mbEscaped = false;
                            break block23;
                        }
                        oRule = this.moContext.moRules.getRules(aoSegment.array[this.miPosition]);
                        break block26;
                    }
                    if (this.moContext.moInRule == null) {
                        this.markKeyword(aoTokenList, aoSegment, this.miLastKeyword, this.miLineLength);
                    }
                    if (this.miLastOffset != this.miLineLength) {
                        if (this.moContext.moInRule == null) {
                            aoTokenList.addToken(this.miLineLength - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
                        } else if ((this.moContext.moInRule.miAction & 2) == 2 && (this.moContext.moInRule.miAction & 0xC00) != 0) {
                            aoTokenList.addToken(this.miLineLength - this.miLastOffset, (byte)16, this.moContext.moRules);
                            this.moContext.moInRule = null;
                        } else {
                            aoTokenList.addToken(this.miLineLength - this.miLastOffset, this.moContext.moInRule.myToken, this.moContext.moRules);
                            if ((this.moContext.moInRule.miAction & 8) == 8) {
                                this.moContext.moInRule = null;
                            }
                        }
                    }
                    aoTokenList.addToken(0, (byte)127, this.moContext.moRules);
                    this.moContext.moTokenList = aoTokenList;
                    return this.moContext;
                }
                while (oRule != null) {
                    this.moPattern.array = oRule.maSearchChars;
                    if (this.moContext.moInRule == oRule && (oRule.miAction & 2) == 2) {
                        this.moPattern.count = oRule.maSequenceLengths[1];
                        this.moPattern.offset = oRule.maSequenceLengths[0];
                    } else {
                        this.moPattern.count = oRule.maSequenceLengths[0];
                        this.moPattern.offset = 0;
                    }
                    if (!this.handleRule(aoTokenList, aoSegment, oRule)) break;
                    oRule = oRule.moNext;
                }
                this.mbEscaped = false;
            }
            ++this.miPosition;
        }
    }

    private boolean handleRule(SyntaxTokenList aoTokenList, Segment aoSegment, ParserRule aoCheckRule) {
        if (this.moPattern.count == 0) {
            return true;
        }
        if (this.miLineLength - this.miPosition < this.moPattern.count) {
            return true;
        }
        for (int iIndex = 0; iIndex < this.moPattern.count; ++iIndex) {
            char cA = this.moPattern.array[this.moPattern.offset + iIndex];
            char cB = aoSegment.array[this.miPosition + iIndex];
            if (cA == cB || this.moContext.moRules.getIgnoreCase() && (Character.toLowerCase(cA) == cB || cA == Character.toLowerCase(cB))) continue;
            return true;
        }
        if (this.mbEscaped) {
            this.miPosition += this.moPattern.count - 1;
            return false;
        }
        if ((aoCheckRule.miAction & 0x1000) == 4096) {
            this.mbEscaped = true;
            this.miPosition += this.moPattern.count - 1;
            return false;
        }
        if (this.moContext.moInRule != null && this.moContext.moInRule != aoCheckRule && (this.moContext.moInRule.miAction & 0x808) != 0) {
            if ((this.moContext.moInRule.miAction & 0x800) == 2048) {
                aoTokenList.addToken(this.miPosition - this.miLastOffset, (byte)16, this.moContext.moRules);
            } else {
                aoTokenList.addToken(this.miPosition - this.miLastOffset, this.moContext.moInRule.myToken, this.moContext.moRules);
            }
            this.miLastOffset = this.miLastKeyword = this.miPosition;
            this.moContext.moInRule = null;
        }
        if (this.moContext.moInRule == null) {
            if ((aoCheckRule.miAction & 0x200) == 512 && ((aoCheckRule.miAction & 4) != 0 ? this.miLastKeyword : this.miPosition) != aoSegment.offset) {
                return true;
            }
            this.markKeyword(aoTokenList, aoSegment, this.miLastKeyword, this.miPosition);
            if ((aoCheckRule.miAction & 4) != 4) {
                this.miLastKeyword = this.miPosition + this.moPattern.count;
                if ((aoCheckRule.miAction & 1) == 1) {
                    return false;
                }
                if (this.miLastOffset < this.miPosition) {
                    aoTokenList.addToken(this.miPosition - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
                }
            }
            switch (aoCheckRule.miAction & 0xFF) {
                case 0: {
                    aoTokenList.addToken(this.moPattern.count, aoCheckRule.myToken, this.moContext.moRules);
                    this.miLastOffset = this.miPosition + this.moPattern.count;
                    break;
                }
                case 2: {
                    this.moContext.moInRule = aoCheckRule;
                    if ((aoCheckRule.miAction & 0x2000) != 8192) {
                        if ((aoCheckRule.miAction & 0x100) == 256) {
                            aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                            this.miLastOffset = this.miPosition + this.moPattern.count;
                            break;
                        }
                        this.miLastOffset = this.miPosition;
                        break;
                    }
                    String sName = new String(aoCheckRule.maSearchChars, aoCheckRule.maSequenceLengths[0] + aoCheckRule.maSequenceLengths[1], aoCheckRule.maSequenceLengths[2]);
                    ParserRuleSet oDelegateSet = this.getRuleSet(sName);
                    if (oDelegateSet == null) break;
                    if ((aoCheckRule.miAction & 0x100) == 256) {
                        aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                    } else {
                        aoTokenList.addToken(this.moPattern.count, aoCheckRule.myToken, this.moContext.moRules);
                    }
                    this.miLastOffset = this.miPosition + this.moPattern.count;
                    this.moContext = new SyntaxLineContext(oDelegateSet, this.moContext);
                    break;
                }
                case 16: {
                    if ((aoCheckRule.miAction & 0x100) == 256) {
                        aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                        aoTokenList.addToken(this.miLineLength - (this.miPosition + this.moPattern.count), aoCheckRule.myToken, this.moContext.moRules);
                    } else {
                        aoTokenList.addToken(this.miLineLength - this.miPosition, aoCheckRule.myToken, this.moContext.moRules);
                    }
                    this.miLastOffset = this.miLineLength;
                    this.miLastKeyword = this.miLineLength;
                    this.miPosition = this.miLineLength;
                    return false;
                }
                case 4: {
                    if (this.miLastKeyword > this.miLastOffset) {
                        aoTokenList.addToken(this.miLastKeyword - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
                        this.miLastOffset = this.miLastKeyword;
                    }
                    if ((aoCheckRule.miAction & 0x100) == 256) {
                        aoTokenList.addToken(this.miPosition - this.miLastOffset, aoCheckRule.myToken, this.moContext.moRules);
                        aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                    } else {
                        aoTokenList.addToken(this.miPosition - this.miLastOffset + this.moPattern.count, aoCheckRule.myToken, this.moContext.moRules);
                    }
                    this.miLastOffset = this.miPosition + this.moPattern.count;
                    break;
                }
                case 8: {
                    this.moContext.moInRule = aoCheckRule;
                    if ((aoCheckRule.miAction & 0x100) == 256) {
                        aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                        this.miLastOffset = this.miPosition + this.moPattern.count;
                        break;
                    }
                    this.miLastOffset = this.miPosition;
                    break;
                }
                default: {
                    throw new InternalError("Unhandled major action");
                }
            }
            this.miLastKeyword = this.miLastOffset;
            this.miPosition += this.moPattern.count - 1;
            return false;
        }
        if ((aoCheckRule.miAction & 2) == 2) {
            if ((aoCheckRule.miAction & 0x2000) != 8192) {
                this.moContext.moInRule = null;
                if ((aoCheckRule.miAction & 0x100) == 256) {
                    aoTokenList.addToken(this.miPosition - this.miLastOffset, aoCheckRule.myToken, this.moContext.moRules);
                    aoTokenList.addToken(this.moPattern.count, this.moContext.moRules.getDefault(), this.moContext.moRules);
                } else {
                    aoTokenList.addToken(this.miPosition + this.moPattern.count - this.miLastOffset, aoCheckRule.myToken, this.moContext.moRules);
                }
                this.miLastKeyword = this.miLastOffset = this.miPosition + this.moPattern.count;
                this.miPosition += this.moPattern.count - 1;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void markKeyword(SyntaxTokenList aoTokenList, Segment aoSegment, int aiStart, int aiEnd) {
        byte yID;
        KeywordMap oKeywords = this.moContext.moRules.getKeywords();
        int iLength = aiEnd - aiStart;
        if (this.moContext.moRules.getHighlightDigits()) {
            char[] aCharacters = aoSegment.array;
            boolean bDigit = true;
            boolean bOctal = false;
            boolean bHex = false;
            boolean bSeenSomeDigits = false;
            block10: for (int iIndex = 0; iIndex < iLength; ++iIndex) {
                char cChar = aCharacters[aiStart + iIndex];
                switch (cChar) {
                    case '0': {
                        if (iIndex == 0) {
                            bOctal = true;
                        }
                        bSeenSomeDigits = true;
                        continue block10;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        bSeenSomeDigits = true;
                        continue block10;
                    }
                    case 'X': 
                    case 'x': {
                        if (!bOctal || iIndex != 1) break;
                        bHex = true;
                        continue block10;
                    }
                    case 'D': 
                    case 'F': 
                    case 'd': 
                    case 'f': {
                        if (!bHex && (iIndex != iLength - 1 || !bSeenSomeDigits)) break;
                        continue block10;
                    }
                    case 'L': 
                    case 'l': {
                        if (iIndex != iLength - 1 || !bSeenSomeDigits) break;
                        continue block10;
                    }
                    case 'E': 
                    case 'e': {
                        if (!bSeenSomeDigits) break;
                        continue block10;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'a': 
                    case 'b': 
                    case 'c': {
                        if (!bHex) break;
                        continue block10;
                    }
                    case '-': 
                    case '.': {
                        continue block10;
                    }
                }
                bDigit = false;
                break;
            }
            if (bDigit && bSeenSomeDigits) {
                if (aiStart != this.miLastOffset) {
                    aoTokenList.addToken(aiStart - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
                }
                aoTokenList.addToken(iLength, (byte)4, this.moContext.moRules);
                this.miLastKeyword = this.miLastOffset = aiEnd;
                return;
            }
        }
        if (oKeywords != null && (yID = oKeywords.lookup(aoSegment, aiStart, iLength)) != 0) {
            if (aiStart != this.miLastOffset) {
                aoTokenList.addToken(aiStart - this.miLastOffset, this.moContext.moRules.getDefault(), this.moContext.moRules);
            }
            aoTokenList.addToken(iLength, yID, this.moContext.moRules);
            this.miLastKeyword = this.miLastOffset = aiEnd;
        }
    }
}

