/*
 * Decompiled with CFR 0.152.
 */
package novaworx.textpane;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import novaworx.log.Log;
import novaworx.syntax.ParserRuleSet;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;
import novaworx.syntax.SyntaxLineContext;

public class SyntaxDocument
extends PlainDocument {
    public static final String SYNTAX = "SyntaxDocument.SYNTAX";
    private boolean mbReadOnly;
    private LineContextManager moContextManager = new LineContextManager();

    public SyntaxDocument() {
        this.setSyntax(SyntaxFactory.getSyntax("default"));
        this.setTabSize(2);
    }

    public void setReadOnly(boolean abReadOnly) {
        this.mbReadOnly = abReadOnly;
    }

    public boolean isReadOnly() {
        return this.mbReadOnly;
    }

    public void setSyntax(Syntax aoSyntax) {
        if (aoSyntax == null) {
            aoSyntax = SyntaxFactory.getSyntax("default");
        }
        this.putProperty(SYNTAX, aoSyntax);
        this.moContextManager.invalidateAll();
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.CHANGE));
    }

    public Syntax getSyntax() {
        return (Syntax)this.getProperty(SYNTAX);
    }

    public void setTabSize(int aiTabSize) {
        this.putProperty("tabSize", new Integer(aiTabSize));
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.CHANGE));
    }

    public int getTabSize() {
        return (Integer)this.getProperty("tabSize");
    }

    public int getLineCount() {
        return this.getDefaultRootElement().getElementCount();
    }

    public int getLineIndexForOffset(int aiOffset) {
        return this.getDefaultRootElement().getElementIndex(aiOffset);
    }

    public int getStartOffsetForLineIndex(int aiIndex) {
        if (aiIndex < 0 || aiIndex >= this.getDefaultRootElement().getElementCount()) {
            return -1;
        }
        Element oElement = this.getDefaultRootElement().getElement(aiIndex);
        return oElement == null ? -1 : oElement.getStartOffset();
    }

    public int getEndOffsetForLineIndex(int aiIndex) {
        if (aiIndex < 0 || aiIndex >= this.getDefaultRootElement().getElementCount()) {
            return -1;
        }
        Element oElement = this.getDefaultRootElement().getElement(aiIndex);
        return oElement == null ? -1 : oElement.getEndOffset();
    }

    public void getLineSegment(int aiLineIndex, Segment aoSegment) {
        try {
            Element oLineElement = this.getDefaultRootElement().getElement(aiLineIndex);
            if (oLineElement == null) {
                return;
            }
            int iStart = oLineElement.getStartOffset();
            int iEnd = oLineElement.getEndOffset();
            this.getText(iStart, iEnd - (iStart + 1), aoSegment);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public SyntaxLineContext getLineContext(int aiLineIndex) {
        if (aiLineIndex < 0 || aiLineIndex >= this.moContextManager.miLineCount) {
            throw new ArrayIndexOutOfBoundsException(aiLineIndex);
        }
        if (this.moContextManager.isValid(aiLineIndex)) {
            return this.moContextManager.getLineContext(aiLineIndex);
        }
        return this.markTokens(aiLineIndex);
    }

    private SyntaxLineContext markTokens(int aiLineIndex) {
        if (aiLineIndex < 0 || aiLineIndex >= this.moContextManager.miLineCount) {
            throw new ArrayIndexOutOfBoundsException(aiLineIndex);
        }
        int iStart = 0;
        for (int iIndex = aiLineIndex - 1; iIndex > 0; --iIndex) {
            if (!this.moContextManager.isValid(iIndex)) continue;
            iStart = iIndex + 1;
            break;
        }
        Segment oSegment = new Segment();
        SyntaxLineContext oLineBeforeContext = null;
        SyntaxLineContext oOldContext = null;
        SyntaxLineContext oContext = null;
        SyntaxLineContext oNewContext = null;
        for (int iIndex = iStart; iIndex <= aiLineIndex; ++iIndex) {
            oOldContext = this.moContextManager.getLineContext(iIndex);
            Syntax oSyntax = (Syntax)this.getProperty(SYNTAX);
            oContext = new SyntaxLineContext(oSyntax.getTokenMarker().getMainRuleSet());
            SyntaxLineContext syntaxLineContext = oLineBeforeContext = iIndex == 0 ? null : this.moContextManager.getLineContext(iIndex - 1);
            if (oLineBeforeContext != null) {
                oContext.moParent = oLineBeforeContext.moParent;
                oContext.moInRule = oLineBeforeContext.moInRule;
                oContext.moRules = oLineBeforeContext.moRules;
            }
            this.getLineSegment(iIndex, oSegment);
            oNewContext = oSyntax.getTokenMarker().markTokens(oSegment, oContext);
            this.moContextManager.setLineContext(iIndex, oNewContext);
            if (oOldContext.moInRule != oNewContext.moInRule) {
                oNewContext.mbNextLineUnpainted = true;
                oNewContext.mbNextLineRequested = true;
            } else if (oOldContext.moRules != oNewContext.moRules) {
                oNewContext.mbNextLineUnpainted = true;
                oNewContext.mbNextLineRequested = true;
            }
            if (iIndex < this.moContextManager.miLineCount - 1) continue;
            oNewContext.mbNextLineUnpainted = false;
            oNewContext.mbNextLineRequested = false;
        }
        if (aiLineIndex < this.moContextManager.miLineCount - 1) {
            this.moContextManager.invalidateNextLinesRequested(aiLineIndex);
        }
        return this.moContextManager.getLineContext(aiLineIndex);
    }

    public void beginCompoundEdit() {
    }

    public void endCompoundEdit() {
    }

    public void addUndoableEdit(UndoableEdit aoEdit) {
    }

    public boolean isLoading() {
        return false;
    }

    public void insertString(int aiOffset, String asString, AttributeSet aoAttributes) throws BadLocationException {
        if (this.mbReadOnly) {
            return;
        }
        super.insertString(aiOffset, asString, aoAttributes);
    }

    public void remove(int aiOffset, int aiLength) throws BadLocationException {
        if (this.mbReadOnly) {
            return;
        }
        super.remove(aiOffset, aiLength);
    }

    protected void fireInsertUpdate(DocumentEvent aoEvent) {
        Syntax oSyntax = (Syntax)this.getProperty(SYNTAX);
        if (oSyntax != null && oSyntax.getTokenMarker() != null) {
            DocumentEvent.ElementChange oElementChange = aoEvent.getChange(this.getDefaultRootElement());
            if (oElementChange != null) {
                int iIndex = oElementChange.getIndex();
                int iLength = oElementChange.getChildrenAdded().length - oElementChange.getChildrenRemoved().length;
                this.moContextManager.linesChanged(iIndex, this.moContextManager.miLineCount - iIndex);
                this.moContextManager.insertLines(oElementChange.getIndex() + 1, iLength);
                iIndex += iLength + 1;
            } else {
                int iIndex = this.getDefaultRootElement().getElementIndex(aoEvent.getOffset());
                this.moContextManager.linesChanged(iIndex, 1);
            }
        }
        super.fireInsertUpdate(aoEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent aoEvent) {
        if (this.mbReadOnly) {
            return;
        }
        Syntax oSyntax = (Syntax)this.getProperty(SYNTAX);
        if (oSyntax != null && oSyntax.getTokenMarker() != null) {
            DocumentEvent.ElementChange oElementChange = aoEvent.getChange(this.getDefaultRootElement());
            if (oElementChange != null) {
                int iIndex = oElementChange.getIndex();
                int iLength = oElementChange.getChildrenRemoved().length - oElementChange.getChildrenAdded().length;
                this.moContextManager.linesChanged(iIndex, this.moContextManager.miLineCount - iIndex);
                this.moContextManager.deleteLines(iIndex + 1, iLength);
            } else {
                int iIndex = this.getDefaultRootElement().getElementIndex(aoEvent.getOffset());
                this.moContextManager.linesChanged(iIndex, 1);
            }
        }
        super.fireRemoveUpdate(aoEvent);
    }

    private class LineContextManager {
        public int miLineCount = 1;
        private SyntaxLineContext[] maContexts;

        public LineContextManager() {
            this.ensureCapacity(0);
            this.maContexts[0] = new SyntaxLineContext();
        }

        public void setLineContext(int aiIndex, SyntaxLineContext aoContext) {
            this.maContexts[aiIndex] = aoContext;
        }

        public SyntaxLineContext getLineContext(int aiIndex) {
            return this.maContexts[aiIndex];
        }

        public boolean isValid(int aiIndex) {
            return this.maContexts[aiIndex].moTokenList != null;
        }

        public void invalidateAll() {
            int iLineCount = this.miLineCount;
            for (int iIndex = 0; iIndex < iLineCount; ++iIndex) {
                this.maContexts[iIndex].moTokenList = null;
            }
        }

        public void invalidate(int aiIndex) {
            this.maContexts[aiIndex].moTokenList = null;
        }

        public void invalidate(int aiStartIndex, int aiEndIndex) {
            for (int iIndex = aiStartIndex; iIndex < aiEndIndex; ++iIndex) {
                this.maContexts[iIndex].moTokenList = null;
            }
        }

        public void invalidateFrom(int aiIndex) {
            int iLineCount = this.miLineCount;
            for (int iIndex = aiIndex; iIndex < iLineCount; ++iIndex) {
                this.maContexts[iIndex].moTokenList = null;
            }
        }

        public void invalidateNextLinesRequested(int aiIndex) {
            int iIndex = aiIndex;
            while (this.maContexts[iIndex].mbNextLineRequested) {
                this.maContexts[iIndex + 1].moTokenList = null;
                ++iIndex;
            }
        }

        public void insertLines(int aiIndex, int aiLines) {
            if (aiLines <= 0) {
                return;
            }
            this.miLineCount += aiLines;
            this.ensureCapacity(this.miLineCount);
            int iLength = aiIndex + aiLines;
            System.arraycopy(this.maContexts, aiIndex, this.maContexts, iLength, this.maContexts.length - iLength);
            Syntax oSyntax = (Syntax)SyntaxDocument.this.getProperty(SyntaxDocument.SYNTAX);
            ParserRuleSet oMainSet = oSyntax.getTokenMarker().getMainRuleSet();
            for (int iIndex = aiIndex + aiLines - 1; iIndex >= aiIndex; --iIndex) {
                this.maContexts[iIndex] = new SyntaxLineContext(oMainSet);
            }
        }

        public void deleteLines(int aiIndex, int aiLines) {
            if (aiLines <= 0) {
                return;
            }
            int iLength = aiIndex + aiLines;
            this.miLineCount -= aiLines;
            System.arraycopy(this.maContexts, iLength, this.maContexts, aiIndex, this.maContexts.length - iLength);
        }

        public void linesChanged(int aiIndex, int aiLines) {
            this.invalidate(aiIndex, aiIndex + aiLines);
        }

        private void ensureCapacity(int aiIndex) {
            if (this.maContexts == null) {
                this.maContexts = new SyntaxLineContext[aiIndex + 1];
            } else if (this.maContexts.length <= aiIndex) {
                SyntaxLineContext[] aContexts = new SyntaxLineContext[(aiIndex + 1) * 2];
                System.arraycopy(this.maContexts, 0, aContexts, 0, this.maContexts.length);
                this.maContexts = aContexts;
            }
        }
    }
}

