/*
 * Decompiled with CFR 0.152.
 */
package novaworx.textpane;

import javax.swing.text.BadLocationException;
import novaworx.log.Log;
import novaworx.textpane.SyntaxDocument;

public class SyntaxDocumentLineSource {
    private SyntaxDocument moDocument;
    private int miStart;
    private int miLastLine;

    public SyntaxDocumentLineSource(SyntaxDocument aoDocument) {
        this.moDocument = aoDocument;
        this.reset();
    }

    public final Object getObject() {
        return this.moDocument;
    }

    public void reset() {
        this.miStart = 0;
        this.miLastLine = -1;
    }

    public final String getNextLine() {
        String sText = null;
        int iLineIndex = this.miLastLine + 1;
        this.miStart = this.moDocument.getStartOffsetForLineIndex(iLineIndex);
        try {
            sText = this.moDocument.getText(this.miStart, this.moDocument.getEndOffsetForLineIndex(iLineIndex) - this.miStart - 1);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
        ++this.miLastLine;
        return sText;
    }

    public int getStartOffset() {
        return this.miStart;
    }

    public int getLineCount() {
        return this.moDocument.getLineCount();
    }

    public final boolean isExhausted() {
        return this.miLastLine >= this.moDocument.getLineCount() - 1;
    }

    public final Object createPosition(int aiOffset) throws BadLocationException {
        return this.moDocument.createPosition(aiOffset);
    }
}

