/*
 * Decompiled with CFR 0.152.
 */
package novaworx.textpane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import novaworx.textpane.SyntaxTextPane;

public class SyntaxGutter
extends JComponent
implements SwingConstants {
    private SyntaxTextPane moTextPane;
    private int miGutterWidth;
    private int miMarkerAreaWidth;
    private int miDividerWidth;
    private int miInterval;
    private int miAlignment;
    private boolean mbShowBracketScope;
    private boolean mbShowCurrentLine;
    private boolean mbShowSelection;
    private boolean mbShowLineInterval;
    private Color moDividerForeground;
    private Color moDividerBackground;
    private Color moCurrentLineForeground;
    private Color moCurrentLineBackground;
    private Color moSelectionForeground;
    private Color moSelectionBackground;
    private Color moLineIntervalForeground;
    private Color moLineIntervalBackground;
    private Color moBracketScopeForeground;
    private Color moBracketScopeBackground;
    private FontMetrics moFontMetrics;
    private int miLineNumberWidth;
    private Font moLineIntervalFont;
    private FontMetrics moLineIntervalFontMetrics;
    private int miLineIntervalBaseline;
    private int miLineIntervalLineNumberWidth;

    public SyntaxGutter(SyntaxTextPane aoTextPane) {
        this.moTextPane = aoTextPane;
        this.miMarkerAreaWidth = 8;
        this.miAlignment = 4;
        Handler oHandler = new Handler();
        this.moTextPane.addComponentListener(oHandler);
        this.moTextPane.addCaretListener(oHandler);
        this.moTextPane.addMouseListener(oHandler);
        this.moTextPane.addMouseMotionListener(oHandler);
        this.setLineInterval(5);
        this.setDividerWidth(3);
        this.setForeground(new Color(128, 128, 128));
        this.setBackground(new Color(128, 128, 128, 0));
        this.setBracketScopeForeground(new Color(128, 128, 128));
        this.setCurrentLineForeground(Color.red);
        this.setCurrentLineBackground(new Color(255, 0, 0, 64));
        this.setLineIntervalForeground(Color.black);
        this.setLineIntervalBackground(new Color(128, 128, 128, 0));
        this.setDividerBackground(new Color(64, 64, 64, 64));
        this.setDividerBackground(new Color(64, 64, 64, 64));
        this.setSelectionForeground(new Color(255, 255, 0, 255));
        this.setSelectionBackground(new Color(144, 144, 255, 128));
        this.setFont(new Font("sansserif", 0, 12));
        this.setLineIntervalFont(new Font("sansserif", 1, 12));
        this.setShowBracketScope(true);
        this.setShowCurrentLine(true);
        this.setShowLineInterval(true);
        this.setShowSelection(true);
    }

    public void setShowBracketScope(boolean abFlag) {
        this.mbShowBracketScope = abFlag;
        this.repaint();
    }

    public boolean isShowBracketScope() {
        return this.mbShowBracketScope;
    }

    public void setBracketScopeForeground(Color aoColor) {
        this.moBracketScopeForeground = aoColor;
        this.repaint();
    }

    public Color getBracketScopeForeground() {
        return this.moBracketScopeForeground;
    }

    public void setBracketScopeBackground(Color aoColor) {
        this.moBracketScopeBackground = aoColor;
        this.repaint();
    }

    public Color getBracketScopeBackground() {
        return this.moBracketScopeBackground;
    }

    public void setShowCurrentLine(boolean abFlag) {
        this.mbShowCurrentLine = abFlag;
        this.repaint();
    }

    public boolean isShowCurrentLine() {
        return this.mbShowCurrentLine;
    }

    public void setCurrentLineForeground(Color aoColor) {
        this.moCurrentLineForeground = aoColor;
        this.repaint();
    }

    public Color getCurrentLineForeground() {
        return this.moCurrentLineForeground;
    }

    public void setCurrentLineBackground(Color aoColor) {
        this.moCurrentLineBackground = aoColor;
        this.repaint();
    }

    public Color getCurrentLineBackground() {
        return this.moCurrentLineBackground;
    }

    public void setShowSelection(boolean abHighlight) {
        this.mbShowSelection = abHighlight;
    }

    public boolean isShowSelection() {
        return this.mbShowSelection;
    }

    public void setSelectionForeground(Color aoColor) {
        this.moSelectionForeground = aoColor;
    }

    public Color getSelectionForeground() {
        return this.moSelectionForeground;
    }

    public void setSelectionBackground(Color aoColor) {
        this.moSelectionBackground = aoColor;
    }

    public Color getSelectionBackground() {
        return this.moSelectionBackground;
    }

    public void setLineInterval(int aiInterval) {
        this.miInterval = aiInterval;
    }

    public int getLineInterval() {
        return this.miInterval;
    }

    public void setShowLineInterval(boolean abFlag) {
        this.mbShowLineInterval = abFlag;
        this.repaint();
    }

    public boolean isShowLineInterval() {
        return this.mbShowLineInterval;
    }

    public void setLineIntervalForeground(Color aoColor) {
        this.moLineIntervalForeground = aoColor;
        this.repaint();
    }

    public Color getLineIntervalForeground() {
        return this.moLineIntervalForeground;
    }

    public void setLineIntervalBackground(Color aoColor) {
        this.moLineIntervalBackground = aoColor;
        this.repaint();
    }

    public Color getLineIntervalBackground() {
        return this.moLineIntervalBackground;
    }

    public void setLineNumberAlignment(int aiAlignment) {
        this.miAlignment = aiAlignment;
        this.repaint();
    }

    public int getLineNumberAlignment() {
        return this.miAlignment;
    }

    public void setDividerWidth(int aiWidth) {
        this.miDividerWidth = aiWidth;
        this.revalidate();
    }

    public int getDividerWidth() {
        return this.miDividerWidth;
    }

    public void setDividerForeground(Color aiColor) {
        this.moDividerForeground = aiColor;
        this.repaint();
    }

    public Color getDividerForeground() {
        return this.moDividerForeground;
    }

    public void setDividerBackground(Color aiColor) {
        this.moDividerBackground = aiColor;
        this.repaint();
    }

    public Color getDividerBackground() {
        return this.moDividerBackground;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int iWidth = this.miGutterWidth = this.miMarkerAreaWidth + Math.max(this.miLineNumberWidth, this.miLineIntervalLineNumberWidth) + this.miDividerWidth;
        return new Dimension(iWidth, this.moTextPane.getSize().height);
    }

    public void setFont(Font aoFont) {
        super.setFont(aoFont);
        this.moFontMetrics = this.getFontMetrics(aoFont);
        this.miLineNumberWidth = this.moFontMetrics.stringWidth("8888");
        this.revalidate();
    }

    public void setLineIntervalFont(Font aoFont) {
        this.moLineIntervalFont = aoFont;
        this.moLineIntervalFontMetrics = this.getFontMetrics(aoFont);
        this.miLineIntervalBaseline = this.moLineIntervalFontMetrics.getAscent();
        this.miLineIntervalLineNumberWidth = this.moLineIntervalFontMetrics.stringWidth("8888");
        this.revalidate();
    }

    public void paint(Graphics aoGraphics) {
        boolean bSelection;
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        if (this.moTextPane.isAntiAlias()) {
            oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle oClip = oGraphics.getClipBounds();
        if (this.moTextPane.getSyntaxDocument().isLoading()) {
            return;
        }
        int iCaretDotLine = -1;
        int iCaretMarkLine = -1;
        int iSelectionBeginLine = -1;
        int iSelectionEndLine = -1;
        int iLineHeight = this.moTextPane.getLineHeight();
        int iFirstLine = oClip.y / iLineHeight;
        int iLastLine = (oClip.y + oClip.height - 1) / iLineHeight;
        int iMaxLine = this.moTextPane.getLineCount();
        int iCaretDot = this.moTextPane.getCaret().getDot();
        int iCaretMark = this.moTextPane.getCaret().getMark();
        int iY = oClip.y - oClip.y % iLineHeight;
        int iCaretLineIndex = this.moTextPane.getCaretLineIndex();
        boolean bl = bSelection = iCaretDot != iCaretMark;
        if (bSelection && this.mbShowSelection) {
            iCaretDotLine = this.moTextPane.getLineIndexForOffset(iCaretDot);
            iCaretMarkLine = this.moTextPane.getLineIndexForOffset(iCaretMark);
            iSelectionBeginLine = Math.min(iCaretDotLine, iCaretMarkLine);
            iSelectionEndLine = Math.max(iCaretDotLine, iCaretMarkLine);
            if (Math.max(iCaretDot, iCaretMark) == this.moTextPane.getStartOffsetForLineIndex(iSelectionEndLine)) {
                --iSelectionEndLine;
            }
        }
        Color oForeground = this.getForeground();
        Color oBackground = this.getBackground();
        Color oTextColor = oForeground;
        Color oHighlight = oBackground;
        int iLineIndex = iFirstLine;
        while (iLineIndex <= iLastLine) {
            Rectangle oBounds = new Rectangle(oClip.x, iY, this.miGutterWidth - this.miDividerWidth, iLineHeight);
            boolean bLineInterval = false;
            if (this.mbShowLineInterval && this.miInterval > 1 && (iLineIndex + 1) % this.miInterval == 0) {
                bLineInterval = true;
            }
            if (this.mbShowCurrentLine && !bSelection && iLineIndex == iCaretLineIndex) {
                oTextColor = this.moCurrentLineForeground;
                oHighlight = this.moCurrentLineBackground;
            } else if (this.mbShowSelection && bSelection && iLineIndex >= iSelectionBeginLine & iLineIndex <= iSelectionEndLine) {
                oTextColor = this.moSelectionForeground;
                oHighlight = this.moSelectionBackground;
            } else if (bLineInterval) {
                oTextColor = this.moLineIntervalForeground;
                oHighlight = this.moLineIntervalBackground;
            } else {
                oTextColor = oForeground;
                oHighlight = oBackground;
            }
            oGraphics.setColor(oHighlight);
            oGraphics.fillRect(oBounds.x, oBounds.y, oBounds.width, oBounds.height);
            if (this.mbShowBracketScope) {
                int iScopeStart = this.moTextPane.getBracketLineIndex();
                int iScopeEnd = this.moTextPane.getOtherBracketLineIndex();
                if (iScopeStart >= 0) {
                    oGraphics.setColor(this.moBracketScopeForeground);
                    if (iScopeStart != iScopeEnd) {
                        if (iLineIndex == iScopeStart) {
                            oGraphics.fillRect(3, iY + iLineHeight / 2, 4, 2);
                            oGraphics.fillRect(3, iY + iLineHeight / 2 + 2, 2, iLineHeight - iLineHeight / 2);
                        } else if (iLineIndex == iScopeEnd) {
                            oGraphics.fillRect(3, iY, 2, iLineHeight / 2);
                            oGraphics.fillRect(3, iY + iLineHeight / 2, 4, 2);
                        } else if (iLineIndex > iScopeStart && iLineIndex < iScopeEnd) {
                            oGraphics.fillRect(3, iY, 2, iLineHeight);
                        }
                    }
                }
            }
            int iOffset = 0;
            String sNumber = Integer.toString(iLineIndex + 1);
            int iLineNumberWidth = Math.max(this.miLineNumberWidth, this.miLineIntervalLineNumberWidth);
            int iBaseline = (int)((double)(this.moFontMetrics.getAscent() + iLineHeight - this.moFontMetrics.getDescent()) / 2.0);
            int iStringWidth = this.moFontMetrics.stringWidth(sNumber);
            oGraphics.setFont(this.getFont());
            if (bLineInterval) {
                oGraphics.setFont(this.moLineIntervalFont);
                iStringWidth = this.moLineIntervalFontMetrics.stringWidth(sNumber);
                iBaseline = (int)((double)(this.moLineIntervalFontMetrics.getAscent() + iLineHeight - this.moLineIntervalFontMetrics.getDescent()) / 2.0);
            }
            switch (this.miAlignment) {
                case 4: {
                    iOffset = iLineNumberWidth - iStringWidth;
                    break;
                }
                case 0: {
                    iOffset = (iLineNumberWidth - iStringWidth) / 2;
                    break;
                }
                default: {
                    iOffset = 0;
                }
            }
            if (iLineIndex < iMaxLine) {
                oGraphics.setColor(oTextColor);
                oGraphics.drawString(sNumber, this.miMarkerAreaWidth + iOffset, iY + iBaseline);
            }
            ++iLineIndex;
            iY += iLineHeight;
        }
        if (this.moDividerBackground != null && oClip.width > this.miGutterWidth - this.miDividerWidth) {
            oGraphics.setColor(this.moDividerBackground);
            oGraphics.fillRect(this.miGutterWidth - this.miDividerWidth, oClip.y, this.miDividerWidth, oClip.height);
        }
    }

    private class Handler
    extends ComponentAdapter
    implements CaretListener,
    MouseListener,
    MouseMotionListener {
        private Handler() {
        }

        public void componentResized(ComponentEvent aoEvent) {
            SyntaxGutter.this.revalidate();
        }

        public void caretUpdate(CaretEvent aoEvent) {
            SyntaxGutter.this.repaint();
        }

        public void mouseClicked(MouseEvent aoEvent) {
        }

        public void mouseEntered(MouseEvent aoEvent) {
        }

        public void mouseExited(MouseEvent aoEvent) {
        }

        public void mousePressed(MouseEvent aoEvent) {
            SyntaxGutter.this.repaint();
        }

        public void mouseReleased(MouseEvent aoEvent) {
            SyntaxGutter.this.repaint();
        }

        public void mouseDragged(MouseEvent aoEvent) {
            SyntaxGutter.this.repaint();
        }

        public void mouseMoved(MouseEvent aoEvent) {
        }
    }
}

