/*
 * Decompiled with CFR 0.152.
 */
package novaworx.textpane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import novaworx.log.Log;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;
import novaworx.syntax.SyntaxUtilities;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxEditorKit;
import novaworx.textpane.SyntaxStyle;

public class SyntaxTextPane
extends JEditorPane {
    public static final EditorKit EDITOR_KIT = new SyntaxEditorKit();
    public static final String STYLES_ATTRIBUTE = "colors";
    private String msSyntax;
    private boolean mbAntiAlias;
    private Color moLineHighlightColor;
    private Object moLineHighlightTag;
    private int miBracketLine = -1;
    private int miOtherBracketLine = -1;
    private Color moBracketHighlightColor;
    private Object moBracketHighlightTag;
    private Object moOtherBracketHighlightTag;
    private Object moBlockCaretHighlightTag;
    private int miIndentSize = 2;
    private int miTabSize = 2;
    private int miElectricLines;
    private boolean mbBlock;
    private boolean mbOverwrite;
    private boolean mbBlockSelect;
    private int miLastLine = -1;
    private int miLastBracketPosition = -1;
    private int miLastOtherBracketPosition = -1;
    private double mdScrollToPercentFromTop = 0.3;
    private static Cursor moNoCursor;
    private static Cursor moTextCursor;

    public SyntaxTextPane() {
        Toolkit oToolkit = Toolkit.getDefaultToolkit();
        byte[] aData = new byte[]{0};
        this.setBorder(null);
        moNoCursor = oToolkit.createCustomCursor(oToolkit.createImage(aData), new Point(0, 0), "cursor.none");
        moTextCursor = Cursor.getPredefinedCursor(2);
        this.setCursor(moTextCursor);
        this.addMouseMotionListener(new MouseMotionHandler());
        this.setSyntaxStyles(SyntaxTextPane.getDefaultSyntaxStyles());
        SystemColor oSelectionColor = SystemColor.textHighlight;
        Color oNewSelectionColor = new Color(oSelectionColor.getRed(), oSelectionColor.getGreen(), oSelectionColor.getBlue(), 128);
        this.setSelectionColor(oNewSelectionColor);
        this.moLineHighlightColor = new Color(128, 128, 128, 64);
        this.moBracketHighlightColor = new Color(255, 128, 128, 128);
        Keymap oMap = JTextComponent.getKeymap(this.getClass().getName());
        if (oMap == null) {
            oMap = JTextComponent.addKeymap(this.getClass().getName(), this.getKeymap());
            oMap.setDefaultAction(new DefaultKeyTypedAction());
            oMap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 0), new InsertKeyAction());
        }
        this.setKeymap(oMap);
        ActionMap oActionMap = this.getActionMap();
        oActionMap.put("indent", new IndentAction());
        oActionMap.put("unindent", new UnindentAction());
        EditorCaret oCaret = new EditorCaret();
        this.setCaret(oCaret);
        this.setCaretColor(Color.red);
    }

    public EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    public void setReadOnly(boolean abReadOnly) {
        SyntaxDocument oDocument = this.getSyntaxDocument();
        if (oDocument != null) {
            oDocument.setReadOnly(abReadOnly);
        }
    }

    public boolean isReadOnly() {
        SyntaxDocument oDocument = this.getSyntaxDocument();
        return oDocument == null ? true : oDocument.isReadOnly();
    }

    public void setAntiAlias(boolean abAntiAlias) {
        this.mbAntiAlias = abAntiAlias;
        this.repaint();
    }

    public boolean isAntiAlias() {
        return this.mbAntiAlias;
    }

    public void setHighlightedLine(int aiLineStart, int aiLineEnd) {
        if (this.moLineHighlightTag == null) {
            return;
        }
        try {
            this.getHighlighter().changeHighlight(this.moLineHighlightTag, aiLineStart, aiLineEnd);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public void setLineHighlightColor(Color aoColor) {
        this.moLineHighlightColor = aoColor;
    }

    public Color getLineHighlightColor() {
        return this.moLineHighlightColor;
    }

    public void setLineHighlight(boolean abLineHighlight) {
        if (this.moLineHighlightTag != null) {
            if (abLineHighlight) {
                return;
            }
            this.getHighlighter().removeHighlight(this.moLineHighlightTag);
            this.moLineHighlightTag = null;
        } else if (abLineHighlight) {
            try {
                this.moLineHighlightTag = this.getHighlighter().addHighlight(0, 0, new CurrentLineHighlighter());
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }
    }

    public boolean getLineHighlight() {
        return this.moLineHighlightTag != null;
    }

    public void setHighlightedBracket(int aiBracketPosition) {
        if (this.moBracketHighlightTag == null) {
            return;
        }
        if (aiBracketPosition == this.miLastBracketPosition) {
            return;
        }
        this.miLastBracketPosition = aiBracketPosition;
        try {
            if (aiBracketPosition == -1) {
                this.getHighlighter().changeHighlight(this.moBracketHighlightTag, 0, 0);
            } else {
                this.getHighlighter().changeHighlight(this.moBracketHighlightTag, aiBracketPosition, aiBracketPosition + 1);
            }
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public void setOtherHighlightedBracket(int aiOtherBracketPosition) {
        if (this.moOtherBracketHighlightTag == null) {
            return;
        }
        if (aiOtherBracketPosition == this.miLastOtherBracketPosition) {
            return;
        }
        this.miLastOtherBracketPosition = aiOtherBracketPosition;
        try {
            if (aiOtherBracketPosition == -1) {
                this.getHighlighter().changeHighlight(this.moOtherBracketHighlightTag, 0, 0);
            } else {
                this.getHighlighter().changeHighlight(this.moOtherBracketHighlightTag, aiOtherBracketPosition, aiOtherBracketPosition + 1);
            }
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public void setBracketHighlightColor(Color aoColor) {
        this.moBracketHighlightColor = aoColor;
    }

    public Color getBracketHighlightColor() {
        return this.moBracketHighlightColor;
    }

    public void setBracketHighlight(boolean abBracketHighlight) {
        if (this.moBracketHighlightTag != null) {
            if (abBracketHighlight) {
                return;
            }
            this.getHighlighter().removeHighlight(this.moBracketHighlightTag);
            this.moBracketHighlightTag = null;
        } else if (abBracketHighlight) {
            try {
                this.moBracketHighlightTag = this.getHighlighter().addHighlight(0, 0, new BracketHighlighter());
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }
        if (this.moOtherBracketHighlightTag != null) {
            if (abBracketHighlight) {
                return;
            }
            this.getHighlighter().removeHighlight(this.moOtherBracketHighlightTag);
            this.moOtherBracketHighlightTag = null;
        } else if (abBracketHighlight) {
            try {
                this.moOtherBracketHighlightTag = this.getHighlighter().addHighlight(0, 0, new BracketHighlighter());
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }
    }

    public boolean getBracketHighlight() {
        return this.moBracketHighlightTag != null & this.moOtherBracketHighlightTag != null;
    }

    public void setElectricBorder(int aiLines) {
        this.miElectricLines = aiLines;
    }

    public int getElectricBorder() {
        return this.miElectricLines;
    }

    public void setBlockCaret(boolean abBlockCaret) {
        this.mbBlock = abBlockCaret;
        if (this.moBlockCaretHighlightTag != null) {
            if (abBlockCaret & !this.mbOverwrite) {
                return;
            }
            this.getHighlighter().removeHighlight(this.moBlockCaretHighlightTag);
            this.moBlockCaretHighlightTag = null;
        } else if (abBlockCaret & !this.mbOverwrite) {
            try {
                this.moBlockCaretHighlightTag = this.getHighlighter().addHighlight(0, 0, new BlockCaretHighlighter());
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }
    }

    public boolean isBlockCaret() {
        return this.mbBlock;
    }

    public void setBlockCaretHighlight(int aiPosition) {
        if (this.moBlockCaretHighlightTag == null) {
            return;
        }
        try {
            if (aiPosition == -1) {
                this.getHighlighter().changeHighlight(this.moBlockCaretHighlightTag, 0, 0);
            } else {
                this.getHighlighter().changeHighlight(this.moBlockCaretHighlightTag, aiPosition, aiPosition + 1);
            }
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public void setCaretOnDelay(int aiDelay) {
        ((EditorCaret)this.getCaret()).setBlinkOnDelay(aiDelay);
    }

    public int getCaretOnDelay() {
        return ((EditorCaret)this.getCaret()).getBlinkOnDelay();
    }

    public void setCaretOffDelay(int aiDelay) {
        ((EditorCaret)this.getCaret()).setBlinkOffDelay(aiDelay);
    }

    public int getCaretOffDelay() {
        return ((EditorCaret)this.getCaret()).getBlinkOffDelay();
    }

    public void setIndentSize(int aiIndentSize) {
        this.miIndentSize = aiIndentSize;
    }

    public int getIndentSize() {
        return this.miIndentSize;
    }

    public void setTabSize(int aiTabSize) {
        this.miTabSize = aiTabSize;
        this.getSyntaxDocument().setTabSize(aiTabSize);
        this.revalidate();
        this.repaint();
    }

    public int getTabSize() {
        return this.miTabSize;
    }

    public void setOverwrite(boolean abOverwrite) {
        this.mbOverwrite = abOverwrite;
    }

    public boolean getOverwrite() {
        return this.mbOverwrite;
    }

    public boolean toggleOverwrite() {
        this.mbOverwrite = !this.mbOverwrite;
        return this.mbOverwrite;
    }

    public void setBlockSelect(boolean abBlockSelect) {
        this.mbBlockSelect = abBlockSelect;
    }

    public boolean isBlockSelect() {
        return this.mbBlockSelect;
    }

    public boolean toggleBlockSelect() {
        this.mbBlockSelect = !this.mbBlockSelect;
        return this.mbBlockSelect;
    }

    public int getScrollableUnitIncrement(Rectangle aoVisibleArea, int aiOrientation, int aiDirection) {
        return this.getLineHeight();
    }

    public void updateHighlighters() {
        Document oDocument = this.getDocument();
        int iCaretPosition = this.getCaretPosition();
        Element oMap = oDocument.getDefaultRootElement();
        int iLineNumber = oMap.getElementIndex(iCaretPosition);
        Element oLineElement = oMap.getElement(iLineNumber);
        int iStart = oLineElement.getStartOffset();
        int iEnd = oLineElement.getEndOffset();
        this.setBlockCaretHighlight(iCaretPosition);
        if (this.getSelectionStart() == this.getSelectionEnd() && iLineNumber != this.miLastLine) {
            this.setHighlightedLine(iStart, iEnd);
            this.miLastLine = iLineNumber;
        }
        try {
            int iOffset = -1;
            int cBracket = 32;
            Segment oSegment = new Segment();
            if (iCaretPosition >= 0 && iOffset < 0) {
                oDocument.getText(iCaretPosition, 1, oSegment);
                cBracket = oSegment.array[oSegment.offset];
                switch (cBracket) {
                    case 40: 
                    case 41: 
                    case 91: 
                    case 93: 
                    case 123: 
                    case 125: {
                        iOffset = iCaretPosition;
                    }
                }
            }
            if (iCaretPosition > 0 && iOffset < 0) {
                oDocument.getText(iCaretPosition - 1, 1, oSegment);
                cBracket = oSegment.array[oSegment.offset];
                switch (cBracket) {
                    case 40: 
                    case 41: 
                    case 91: 
                    case 93: 
                    case 123: 
                    case 125: {
                        iOffset = iCaretPosition - 1;
                    }
                }
            }
            int iOtherOffset = -1;
            if (iOffset >= 0) {
                switch (cBracket) {
                    case 40: {
                        iOtherOffset = SyntaxUtilities.locateBracketForward(oDocument, iOffset, '(', ')');
                        break;
                    }
                    case 41: {
                        iOtherOffset = SyntaxUtilities.locateBracketBackward(oDocument, iOffset, '(', ')');
                        break;
                    }
                    case 91: {
                        iOtherOffset = SyntaxUtilities.locateBracketForward(oDocument, iOffset, '[', ']');
                        break;
                    }
                    case 93: {
                        iOtherOffset = SyntaxUtilities.locateBracketBackward(oDocument, iOffset, '[', ']');
                        break;
                    }
                    case 123: {
                        iOtherOffset = SyntaxUtilities.locateBracketForward(oDocument, iOffset, '{', '}');
                        break;
                    }
                    case 125: {
                        iOtherOffset = SyntaxUtilities.locateBracketBackward(oDocument, iOffset, '{', '}');
                    }
                }
                if (iOtherOffset >= 0) {
                    this.setHighlightedBracket(iOffset);
                    this.setOtherHighlightedBracket(iOtherOffset);
                    int iBracketLine = this.getLineIndexForOffset(iOffset);
                    int iOtherBracketLine = this.getLineIndexForOffset(iOtherOffset);
                    this.miBracketLine = Math.min(iBracketLine, iOtherBracketLine);
                    this.miOtherBracketLine = Math.max(iBracketLine, iOtherBracketLine);
                } else {
                    this.setHighlightedBracket(-1);
                    this.setOtherHighlightedBracket(-1);
                    this.miBracketLine = -1;
                    this.miOtherBracketLine = -1;
                }
            } else {
                this.setHighlightedBracket(-1);
                this.setOtherHighlightedBracket(-1);
                this.miBracketLine = -1;
                this.miOtherBracketLine = -1;
            }
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public int getCurrentRow() {
        return this.getCaretLineIndex() + 1;
    }

    public int getCurrentColumn() {
        return this.getCaret().getDot() - this.getStartOffsetForLineIndex(this.getCaretLineIndex()) + 1;
    }

    public int getBracketLineIndex() {
        return this.miBracketLine;
    }

    public int getOtherBracketLineIndex() {
        return this.miOtherBracketLine;
    }

    public int getCaretLineIndex() {
        int iDot = this.getCaret().getDot();
        return this.getLineIndexForOffset(iDot);
    }

    public int getLineCount() {
        return this.getSyntaxDocument().getLineCount();
    }

    public int getLineIndexForOffset(int aiOffset) {
        return this.getSyntaxDocument().getLineIndexForOffset(aiOffset);
    }

    public int getStartOffsetForLineIndex(int aiIndex) {
        return this.getSyntaxDocument().getStartOffsetForLineIndex(aiIndex);
    }

    public int getEndOffsetForLineIndex(int aiIndex) {
        return this.getSyntaxDocument().getEndOffsetForLineIndex(aiIndex);
    }

    public void setDocument(Document aoDocument) {
        if (!(aoDocument instanceof SyntaxDocument)) {
            throw new IllegalArgumentException("Document is not an instance of SyntaxDocument");
        }
        this.invalidate();
        super.setDocument(aoDocument);
        ((SyntaxDocument)aoDocument).setTabSize(this.miTabSize);
    }

    public SyntaxDocument getSyntaxDocument() {
        return (SyntaxDocument)this.getDocument();
    }

    public void setSyntax(String asSyntax) {
        this.getSyntaxDocument().setSyntax(SyntaxFactory.getSyntax(asSyntax));
    }

    public void setSyntax(Syntax aoSyntax) {
        this.getSyntaxDocument().setSyntax(aoSyntax);
    }

    public Syntax getSyntax() {
        return this.getSyntaxDocument().getSyntax();
    }

    public String getSyntaxName() {
        Syntax oSyntax = this.getSyntax();
        String sName = oSyntax == null ? "default" : oSyntax.getName();
        return sName;
    }

    public void setSyntaxStyles(SyntaxStyle[] aaStyles) {
        this.putClientProperty(STYLES_ATTRIBUTE, aaStyles);
    }

    public SyntaxStyle[] getSyntaxStyles() {
        return (SyntaxStyle[])this.getClientProperty(STYLES_ATTRIBUTE);
    }

    public void doElectricScroll(Rectangle aoArea) {
        int iLines;
        FontRenderContext oContext = new FontRenderContext(null, false, false);
        LineMetrics oMetrics = this.getFont().getLineMetrics("This is a test.", oContext);
        int iHeight = (int)oMetrics.getHeight();
        int iY = Math.max(0, aoArea.y - iHeight * this.miElectricLines);
        if (iY + (iLines = iHeight * this.miElectricLines * 2) + aoArea.height <= this.getHeight()) {
            aoArea.y = iY;
            aoArea.height += iLines;
        }
        this.scrollRectToVisible(aoArea);
    }

    public int getLineHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public void paint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.mbAntiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        super.paint(aoGraphics);
    }

    public void setForeground(Color aoColor) {
        SyntaxStyle oStyle;
        super.setForeground(aoColor);
        SyntaxStyle[] aStyles = this.getSyntaxStyles();
        if (aStyles != null && (oStyle = aStyles[0]) != null) {
            oStyle.setForeground(aoColor);
        }
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] aStyles = new SyntaxStyle[]{new SyntaxStyle(new Color(0, 0, 0)), new SyntaxStyle(new Color(128, 128, 128)), new SyntaxStyle(new Color(128, 128, 128)), new SyntaxStyle(new Color(0, 0, 160)), new SyntaxStyle(new Color(0, 160, 0)), new SyntaxStyle(new Color(64, 128, 255)), new SyntaxStyle(new Color(96, 96, 255)), new SyntaxStyle(new Color(0, 96, 160)), new SyntaxStyle(new Color(0, 160, 96)), new SyntaxStyle(new Color(0, 160, 192)), new SyntaxStyle(new Color(192, 160, 192)), new SyntaxStyle(new Color(0, 192, 192)), new SyntaxStyle(new Color(128, 32, 255)), new SyntaxStyle(new Color(0, 0, 0)), new SyntaxStyle(new Color(64, 64, 128)), new SyntaxStyle(new Color(0, 96, 96)), new SyntaxStyle(new Color(255, 0, 0))};
        return aStyles;
    }

    public void scrollRectToVisible(Rectangle moArea) {
        new SafeScroller(moArea);
    }

    public void setScrollToPercentFromTop(double adPercent) {
        this.mdScrollToPercentFromTop = adPercent;
    }

    public double getScrollToPercentFromTop() {
        return this.mdScrollToPercentFromTop;
    }

    public void scrollToOffset(int aiOffset) {
        Container oParent;
        double dPercent = this.mdScrollToPercentFromTop;
        if (aiOffset < 0 || aiOffset > this.getDocument().getLength()) {
            return;
        }
        for (oParent = this.getParent(); oParent != null && !(oParent instanceof JViewport); oParent = oParent.getParent()) {
            System.out.println("Parent: " + oParent.getClass().getName());
        }
        if (oParent == null) {
            return;
        }
        Rectangle oViewArea = ((JViewport)oParent).getViewRect();
        Rectangle oLineArea = null;
        try {
            oLineArea = this.modelToView(aiOffset);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
            return;
        }
        int iNetHeight = oViewArea.height - oLineArea.height;
        int iTopHeight = (int)((double)iNetHeight * dPercent);
        int iBotHeight = iNetHeight - iTopHeight;
        Rectangle oScrollArea = new Rectangle(0, oLineArea.y - iTopHeight, oViewArea.width, oViewArea.height);
        if (oScrollArea != null) {
            this.scrollRectToVisible(oScrollArea);
        }
    }

    public void jumpToOffset(int aiOffset) {
        if (aiOffset < 0 || aiOffset > this.getDocument().getLength()) {
            return;
        }
        this.requestFocusInWindow();
        this.scrollToOffset(aiOffset);
        this.setCaretPosition(aiOffset);
    }

    public void moveToOffset(int aiOffset) {
        if (aiOffset < 0 || aiOffset > this.getDocument().getLength()) {
            return;
        }
        this.requestFocusInWindow();
        this.scrollToOffset(aiOffset);
        this.moveCaretPosition(aiOffset);
    }

    public boolean jumpToLineNumber(int aiLineNumber) {
        int iOffset = this.getStartOffsetForLineIndex(aiLineNumber - 1);
        if (iOffset < 0 || iOffset > this.getDocument().getLength()) {
            return false;
        }
        this.requestFocusInWindow();
        this.scrollToOffset(iOffset);
        this.setCaretPosition(iOffset);
        return true;
    }

    public boolean moveToLineNumber(int aiLineNumber) {
        int iOffset = this.getStartOffsetForLineIndex(aiLineNumber - 1);
        if (iOffset < 0 || iOffset > this.getDocument().getLength()) {
            return false;
        }
        this.requestFocusInWindow();
        this.scrollToOffset(iOffset);
        this.moveCaretPosition(iOffset);
        return true;
    }

    public boolean findNext(String asExpression) {
        return this.findNext(asExpression, Math.max(this.getCaret().getDot(), this.getCaret().getMark()));
    }

    public boolean findNext(String asExpression, int aiOffset) {
        return this.findNext(asExpression, aiOffset, false);
    }

    public boolean findNext(String asExpression, int aiOffset, boolean abWrap) {
        String sSearch = null;
        try {
            sSearch = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException aoException) {
            return false;
        }
        int iStart = -1;
        int iLength = sSearch.length();
        StringBuffer oSearchBuffer = null;
        StringBuffer oExpression = new StringBuffer(asExpression);
        if (abWrap) {
            oSearchBuffer = new StringBuffer(sSearch.substring(aiOffset));
            oSearchBuffer.append(sSearch.substring(0, iLength - aiOffset));
        } else {
            oSearchBuffer = new StringBuffer(sSearch.substring(aiOffset));
        }
        iStart = oSearchBuffer.indexOf(oExpression.toString());
        if (iStart < 0) {
            return false;
        }
        iStart = (aiOffset + iStart) % iLength;
        this.setCaretPosition(iStart);
        this.moveCaretPosition(iStart + oExpression.length());
        return true;
    }

    public boolean findPrevious(String asExpression) {
        return this.findPrevious(asExpression, Math.min(this.getCaret().getDot(), this.getCaret().getMark()));
    }

    public boolean findPrevious(String asExpression, int aiOffset) {
        return this.findPrevious(asExpression, aiOffset, false);
    }

    public boolean findPrevious(String asExpression, int aiOffset, boolean abWrap) {
        String sSearch = null;
        try {
            sSearch = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException aoException) {
            return false;
        }
        int iStart = -1;
        int iLength = sSearch.length();
        StringBuffer oSearchBuffer = null;
        StringBuffer oExpression = new StringBuffer(asExpression);
        if (abWrap) {
            oSearchBuffer = new StringBuffer(sSearch.substring(aiOffset));
            oSearchBuffer.append(sSearch.substring(0, iLength - aiOffset));
        } else {
            oSearchBuffer = new StringBuffer(sSearch.substring(0, aiOffset));
        }
        oSearchBuffer.reverse();
        oExpression.reverse();
        iStart = oSearchBuffer.indexOf(oExpression.toString());
        if (iStart < 0) {
            return false;
        }
        iStart = (aiOffset - iStart - oExpression.length()) % iLength;
        this.setCaretPosition(iStart);
        this.moveCaretPosition(iStart + oExpression.length());
        return true;
    }

    private void _replaceSelection(String asContent) {
        if (!this.mbOverwrite || this.getSelectionStart() != this.getSelectionEnd()) {
            this.replaceSelection(asContent);
            return;
        }
        int iCaretPosition = this.getCaretPosition();
        Document oDocument = this.getDocument();
        Element oMap = oDocument.getDefaultRootElement();
        Element oLine = oMap.getElement(oMap.getElementIndex(iCaretPosition));
        if (oLine.getEndOffset() - iCaretPosition <= asContent.length()) {
            this.replaceSelection(asContent);
            return;
        }
        try {
            oDocument.remove(iCaretPosition, asContent.length());
            oDocument.insertString(iCaretPosition, asContent, null);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
        }
    }

    public void updateUI() {
        boolean bOpaque = this.isOpaque();
        super.updateUI();
        this.setOpaque(bOpaque);
    }

    class BlockCaretHighlighter
    implements Highlighter.HighlightPainter {
        BlockCaretHighlighter() {
        }

        public void paint(Graphics aoGraphics, int aiPosition0, int aiPosition1, Shape aoBounds, JTextComponent aoTextComponent) {
            Document oDocument = SyntaxTextPane.this.getDocument();
            FontMetrics oMetrics = aoGraphics.getFontMetrics();
            Segment oSegment = new Segment();
            try {
                Rectangle oCaret = SyntaxTextPane.this.modelToView(aiPosition0);
                oDocument.getText(aiPosition0, 1, oSegment);
                oCaret.width = oMetrics.charWidth(oSegment.array[oSegment.offset]);
                if (oCaret.width < 1) {
                    oCaret.width = 1;
                }
                aoGraphics.setColor(SyntaxTextPane.this.getCaretColor());
                aoGraphics.fillRect(oCaret.x, oCaret.y, oCaret.width, oCaret.height);
            }
            catch (BadLocationException aoException) {
                // empty catch block
            }
        }
    }

    class BracketHighlighter
    implements Highlighter.HighlightPainter {
        BracketHighlighter() {
        }

        public void paint(Graphics aoGraphics, int aiPosition0, int aiPosition1, Shape aoBounds, JTextComponent aoTextComponent) {
            Rectangle oBracket;
            if (SyntaxTextPane.this.getSelectionStart() != SyntaxTextPane.this.getSelectionEnd() || SyntaxTextPane.this.moBracketHighlightTag == null || SyntaxTextPane.this.moOtherBracketHighlightTag == null) {
                return;
            }
            if (aiPosition0 == aiPosition1) {
                return;
            }
            Document oDocument = SyntaxTextPane.this.getDocument();
            FontMetrics oMetrics = aoGraphics.getFontMetrics();
            Segment oSegment = new Segment();
            try {
                oBracket = SyntaxTextPane.this.modelToView(aiPosition0);
                oDocument.getText(aiPosition0, 1, oSegment);
                oBracket.width = oMetrics.charWidth(oSegment.array[oSegment.offset]);
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
                return;
            }
            aoGraphics.setColor(SyntaxTextPane.this.moBracketHighlightColor);
            aoGraphics.fillRect(oBracket.x, oBracket.y, oBracket.width, oBracket.height);
        }
    }

    class CurrentLineHighlighter
    implements Highlighter.HighlightPainter {
        CurrentLineHighlighter() {
        }

        public void paint(Graphics aoGraphics, int aiPosition0, int aiPosition1, Shape aoBounds, JTextComponent aoTextComponent) {
            if (SyntaxTextPane.this.moLineHighlightTag == null || SyntaxTextPane.this.getSelectionStart() != SyntaxTextPane.this.getSelectionEnd()) {
                return;
            }
            FontMetrics oMetrics = aoGraphics.getFontMetrics();
            Document oDocument = SyntaxTextPane.this.getDocument();
            int iLineNo = oDocument.getDefaultRootElement().getElementIndex(aiPosition0);
            Rectangle oBounds = (Rectangle)aoBounds;
            int iHeight = oMetrics.getHeight();
            int iX = oBounds.x;
            int iY = oBounds.y + iHeight * iLineNo;
            aoGraphics.setColor(SyntaxTextPane.this.moLineHighlightColor);
            aoGraphics.fillRect(iX, iY, oBounds.width, iHeight);
        }
    }

    class SelectionHighlighter
    implements Highlighter.HighlightPainter {
        SelectionHighlighter() {
        }

        public void paint(Graphics aoGraphics, int aiPosition0, int aiPosition1, Shape aoBounds, JTextComponent aoTextComponent) {
            if (SyntaxTextPane.this.getSelectionStart() == SyntaxTextPane.this.getSelectionEnd()) {
                return;
            }
            Rectangle oBounds = aoBounds.getBounds();
            try {
                TextUI oMapper = aoTextComponent.getUI();
                Rectangle oP0 = oMapper.modelToView(aoTextComponent, aiPosition0);
                Rectangle oP1 = oMapper.modelToView(aoTextComponent, aiPosition1);
                aoGraphics.setColor(SyntaxTextPane.this.getSelectionColor());
                if (oP0.y == oP1.y) {
                    Rectangle oUnion = oP0.union(oP1);
                    aoGraphics.fillRect(oUnion.x, oUnion.y, oUnion.width, oUnion.height);
                } else {
                    int iP0ToMarginWidth = oBounds.x + oBounds.width - oP0.x;
                    aoGraphics.fillRect(oP0.x, oP0.y, oBounds.width, oP0.height);
                    if (oP0.y + oP0.height != oP1.y) {
                        aoGraphics.fillRect(oBounds.x, oP0.y + oP0.height, oBounds.width, oP1.y - (oP0.y + oP0.height));
                    }
                    aoGraphics.fillRect(oBounds.x, oP1.y, oP1.x - oBounds.x, oP1.height);
                }
            }
            catch (BadLocationException aoException) {
                // empty catch block
            }
        }
    }

    class SafeScroller
    implements Runnable {
        public Rectangle moArea;

        public SafeScroller(Rectangle aoArea) {
            this.moArea = aoArea;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException aoException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            SyntaxTextPane.super.scrollRectToVisible(this.moArea);
        }
    }

    class EditorCaret
    extends DefaultCaret {
        private boolean mbShown = true;
        private boolean mbBlinking;
        private int miBlinkOnDelay;
        private int miBlinkOffDelay;
        private Timer moBlinkTimer;
        private Timer moBlinkOffTimer;
        Highlighter.HighlightPainter moSelectionPainter;
        Highlighter.HighlightPainter moBlockCaretPainter;

        public EditorCaret() {
            this.moSelectionPainter = new SelectionHighlighter();
            this.moBlockCaretPainter = new BlockCaretHighlighter();
            this.moBlinkTimer = new Timer(1000, new BlinkHandler());
            this.moBlinkTimer.setInitialDelay(0);
            this.moBlinkOffTimer = new Timer(500, new BlinkOffHandler());
            this.moBlinkOffTimer.setInitialDelay(500);
            this.moBlinkOffTimer.setRepeats(false);
            this.startBlinking();
        }

        public void fireStateChanged() {
            SyntaxTextPane.this.updateHighlighters();
            super.fireStateChanged();
        }

        public Highlighter.HighlightPainter getSelectionPainter() {
            return this.moSelectionPainter;
        }

        public void adjustVisibility(Rectangle aoArea) {
            SyntaxTextPane.this.doElectricScroll(aoArea);
        }

        public void focusGained(FocusEvent aoEvent) {
            this.setSelectionVisible(true);
            if (!this.mbBlinking) {
                this.mbShown = true;
                this.repaint();
            }
        }

        public void focusLost(FocusEvent aoEvent) {
            if (!this.mbBlinking) {
                this.mbShown = false;
                this.repaint();
            }
        }

        protected void startBlinking() {
            if (this.miBlinkOnDelay <= 0 || this.miBlinkOffDelay <= 0) {
                return;
            }
            this.moBlinkTimer.restart();
            this.mbBlinking = true;
        }

        protected void stopBlinking() {
            this.mbBlinking = false;
            this.moBlinkTimer.stop();
            this.moBlinkOffTimer.stop();
            this.mbShown = true;
            this.repaint();
        }

        public void setBlinking(boolean abBlinking) {
            if (abBlinking) {
                this.startBlinking();
            } else {
                this.stopBlinking();
            }
        }

        public boolean isBlinking() {
            return this.mbBlinking;
        }

        public void setBlinkRate(int aiRate) {
            this.setBlinkOnDelay(aiRate);
            this.setBlinkOffDelay(aiRate);
        }

        public int getBlinkRate() {
            return 0;
        }

        public void setBlinkOnDelay(int aiDelay) {
            this.stopBlinking();
            this.miBlinkOnDelay = aiDelay;
            this.moBlinkTimer.setDelay(this.miBlinkOnDelay + this.miBlinkOffDelay);
            this.moBlinkOffTimer.setInitialDelay(this.miBlinkOnDelay);
            this.moBlinkOffTimer.setDelay(this.miBlinkOnDelay);
            this.startBlinking();
        }

        public int getBlinkOnDelay() {
            return this.miBlinkOnDelay;
        }

        public void setBlinkOffDelay(int aiDelay) {
            this.stopBlinking();
            this.miBlinkOffDelay = aiDelay;
            this.moBlinkTimer.setDelay(this.miBlinkOnDelay + this.miBlinkOffDelay);
            this.startBlinking();
        }

        public int getBlinkOffDelay() {
            return this.miBlinkOffDelay;
        }

        protected void damage(Rectangle aoArea) {
            if (aoArea == null) {
                return;
            }
            Rectangle oTextAreaBounds = SyntaxTextPane.this.getBounds();
            this.x = 0;
            this.y = aoArea.y;
            this.width = oTextAreaBounds.width;
            this.height = aoArea.height;
        }

        public void paint(Graphics aoGraphics) {
            if (!this.mbShown & this.getComponent().hasFocus()) {
                return;
            }
            Graphics2D oGraphics = (Graphics2D)aoGraphics;
            FontMetrics oFontMetrics = oGraphics.getFontMetrics();
            try {
                int iDot = this.getDot();
                Rectangle aoArea = SyntaxTextPane.this.modelToView(iDot);
                SyntaxTextPane oTextArea = SyntaxTextPane.this;
                char cChar = oTextArea.getDocument().getText(iDot, 1).charAt(0);
                aoArea.x = aoArea.x;
                int n = aoArea.width = SyntaxTextPane.this.mbOverwrite || SyntaxTextPane.this.mbBlock ? oFontMetrics.charWidth(cChar) : 1;
                if (aoArea.width < 1) {
                    aoArea.width = 1;
                }
                aoGraphics.setColor(SyntaxTextPane.this.getCaretColor());
                if (SyntaxTextPane.this.mbBlock) {
                    if (SyntaxTextPane.this.mbOverwrite) {
                        aoGraphics.drawLine(aoArea.x, aoArea.y, aoArea.x, aoArea.y + aoArea.height - 1);
                        aoGraphics.drawLine(aoArea.x, aoArea.y + aoArea.height - 1, aoArea.x + aoArea.width - 1, aoArea.y + aoArea.height - 1);
                        aoGraphics.drawLine(aoArea.x + aoArea.width - 1, aoArea.y + aoArea.height - 1, aoArea.x + aoArea.width - 1, aoArea.y);
                        aoGraphics.drawLine(aoArea.x + aoArea.width - 1, aoArea.y, aoArea.x, aoArea.y);
                    }
                } else if (SyntaxTextPane.this.mbOverwrite) {
                    aoGraphics.drawLine(aoArea.x, aoArea.y + aoArea.height - 1, aoArea.x + aoArea.width - 1, aoArea.y + aoArea.height - 1);
                } else {
                    aoGraphics.drawRect(aoArea.x, aoArea.y, 1, aoArea.height - 1);
                }
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }

        private class BlinkOffHandler
        implements ActionListener {
            private BlinkOffHandler() {
            }

            public void actionPerformed(ActionEvent aoEvent) {
                EditorCaret.this.mbShown = false;
                if (SyntaxTextPane.this.moBlockCaretHighlightTag != null) {
                    SyntaxTextPane.this.getHighlighter().removeHighlight(SyntaxTextPane.this.moBlockCaretHighlightTag);
                    SyntaxTextPane.this.moBlockCaretHighlightTag = null;
                }
                EditorCaret.this.repaint();
            }
        }

        private class BlinkHandler
        implements ActionListener {
            private BlinkHandler() {
            }

            public void actionPerformed(ActionEvent aoEvent) {
                EditorCaret.this.mbShown = true;
                if (SyntaxTextPane.this.moBlockCaretHighlightTag == null & (SyntaxTextPane.this.mbBlock & !SyntaxTextPane.this.mbOverwrite)) {
                    int iOffset = EditorCaret.this.getDot();
                    try {
                        SyntaxTextPane.this.moBlockCaretHighlightTag = SyntaxTextPane.this.getHighlighter().addHighlight(iOffset, iOffset + 1, EditorCaret.this.moBlockCaretPainter);
                    }
                    catch (BadLocationException aoException) {
                        Log.write(4, aoException);
                    }
                }
                EditorCaret.this.repaint();
                EditorCaret.this.moBlinkOffTimer.restart();
            }
        }
    }

    private static class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent aoEvent) {
            JTextComponent oComponent = (JTextComponent)aoEvent.getSource();
            if (oComponent.getCursor() != moTextCursor) {
                oComponent.setCursor(moTextCursor);
            }
        }
    }

    private static class UnindentAction
    extends TextAction {
        public UnindentAction() {
            super("unindent");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(1, "Unindent the selection.");
            SyntaxTextPane oTextPane = (SyntaxTextPane)this.getTextComponent(aoEvent);
            int iDot = oTextPane.getCaret().getDot();
            int iMark = oTextPane.getCaret().getMark();
            int iDotLine = oTextPane.getLineIndexForOffset(iDot);
            int iMarkLine = oTextPane.getLineIndexForOffset(iMark);
        }
    }

    private static class IndentAction
    extends TextAction {
        public IndentAction() {
            super("indent");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(1, "Indent the selection.");
            SyntaxTextPane oTextPane = (SyntaxTextPane)this.getTextComponent(aoEvent);
            int iDot = oTextPane.getCaret().getDot();
            int iMark = oTextPane.getCaret().getMark();
            int iDotLine = oTextPane.getLineIndexForOffset(iDot);
            int iMarkLine = oTextPane.getLineIndexForOffset(iMark);
        }
    }

    private static class DeleteAction
    extends TextAction {
        public DeleteAction() {
            super("delete");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            JTextComponent oTextComponent = this.getTextComponent(aoEvent);
            int iDot = oTextComponent.getCaret().getDot();
            int iMark = oTextComponent.getCaret().getMark();
            try {
                oTextComponent.getDocument().remove(iDot, iMark - iDot);
            }
            catch (BadLocationException aoException) {
                Log.write(4, aoException);
            }
        }
    }

    private static class InsertKeyAction
    extends TextAction {
        public InsertKeyAction() {
            super("insert.key");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            JTextComponent oComponent = this.getTextComponent(aoEvent);
            if (oComponent instanceof SyntaxTextPane) {
                ((SyntaxTextPane)oComponent).toggleOverwrite();
                oComponent.repaint();
            }
        }
    }

    private static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super("text.editor.default.key.typed.action");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            char cChar;
            JTextComponent oComponent = this.getTextComponent(aoEvent);
            String sContent = aoEvent.getActionCommand();
            int iModifiers = aoEvent.getModifiers();
            if (oComponent.getCursor() != moNoCursor) {
                oComponent.setCursor(moNoCursor);
            }
            if (sContent != null && sContent.length() != 0 && (iModifiers & 8) == 0 && (cChar = sContent.charAt(0)) >= ' ' && cChar != '\u007f') {
                if (oComponent instanceof SyntaxTextPane) {
                    ((SyntaxTextPane)oComponent)._replaceSelection(sContent);
                } else {
                    oComponent.replaceSelection(sContent);
                }
            }
        }
    }
}

