/*
 * Decompiled with CFR 0.152.
 */
package novaworx.textpane;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import novaworx.log.Log;
import novaworx.syntax.SyntaxLineContext;
import novaworx.syntax.Token;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxStyle;
import novaworx.textpane.SyntaxTextPane;

public class SyntaxView
extends PlainView {
    private Font moFont;
    private FontMetrics moMetrics;
    private static Font[] maFonts;
    private Segment moSegment;
    private Rectangle moRectangle;
    private int miTabSpace;
    private SyntaxStyle moSelectionStyle;

    public SyntaxView(Element aoElement) {
        super(aoElement);
        maFonts = new Font[4];
        this.moSegment = new Segment();
        this.moRectangle = new Rectangle();
        this.moSelectionStyle = new SyntaxStyle();
    }

    public void drawLine(int aiLineIndex, Graphics aoGraphics, int aiX, int aiBaseline) {
        int iSelectionEnd;
        SyntaxTextPane oTextPane = (SyntaxTextPane)this.getContainer();
        SyntaxDocument oDocument = (SyntaxDocument)this.getDocument();
        SyntaxStyle[] aStyles = oTextPane.getSyntaxStyles();
        FontMetrics oFontMetrics = this.moMetrics;
        SyntaxLineContext oContext = oDocument.getLineContext(aiLineIndex);
        Token oToken = oContext.moTokenList.getFirstToken();
        Segment oSegment = this.moSegment;
        Object oSelectionStyle = null;
        int iSelectionStart = oTextPane.getSelectionStart();
        boolean bSelection = iSelectionStart < (iSelectionEnd = oTextPane.getSelectionEnd()) & oTextPane.getCaret().isSelectionVisible();
        boolean bBlockSelect = oTextPane.isBlockSelect();
        int iStart = oDocument.getStartOffsetForLineIndex(aiLineIndex);
        int iEnd = oDocument.getEndOffsetForLineIndex(aiLineIndex);
        try {
            oDocument.getText(iStart, iEnd - (iStart + 1), oSegment);
        }
        catch (BadLocationException aoException) {
            Log.write(4, aoException);
            return;
        }
        SyntaxStyle oStyle = null;
        byte yID = oToken.myID;
        int iOffset = 0;
        int iSegmentOffset = oSegment.offset;
        int iLength = oToken.miLength;
        int iHeight = oFontMetrics.getHeight();
        Rectangle oBounds = new Rectangle(aiX, aiLineIndex * iHeight, oTextPane.getSize().width - aiX, iHeight);
        int iTokenStart = 0;
        int iTokenEnd = 0;
        while (yID != 127) {
            iSegmentOffset = oSegment.offset;
            oSegment.count = iLength;
            oStyle = aStyles[yID];
            if (bSelection) {
                this.moSelectionStyle.setForeground(oTextPane.getSelectedTextColor());
                this.moSelectionStyle.setFontStyle(oStyle.getFontStyle());
            }
            iTokenStart = iStart + iOffset;
            iTokenEnd = iTokenStart + iLength;
            if (!bSelection || iSelectionStart >= iTokenEnd || iSelectionEnd <= iTokenStart) {
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, oStyle, oBounds, aiBaseline);
            } else if (iSelectionStart <= iTokenStart & iSelectionEnd >= iTokenEnd) {
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, this.moSelectionStyle, oBounds, aiBaseline);
            } else if (iSelectionStart > iTokenStart & iSelectionEnd < iTokenEnd) {
                oSegment.count = iSelectionStart - iStart - iOffset;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, oStyle, oBounds, aiBaseline);
                oSegment.offset += oSegment.count;
                oSegment.count = iSelectionEnd - iSelectionStart;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, this.moSelectionStyle, oBounds, aiBaseline);
                oSegment.offset += oSegment.count;
                oSegment.count = iStart + iOffset + iLength - iSelectionEnd;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, oStyle, oBounds, aiBaseline);
                oSegment.offset = iSegmentOffset;
            } else if (iSelectionStart > iTokenStart & iSelectionStart < iTokenEnd) {
                oSegment.count = iSelectionStart - iStart - iOffset;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, oStyle, oBounds, aiBaseline);
                oSegment.offset += oSegment.count;
                oSegment.count = iLength - oSegment.count;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, this.moSelectionStyle, oBounds, aiBaseline);
                oSegment.offset = iSegmentOffset;
            } else if (iSelectionEnd > iTokenStart & iSelectionEnd < iTokenEnd) {
                oSegment.count = iSelectionEnd - iStart - iOffset;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, this.moSelectionStyle, oBounds, aiBaseline);
                oSegment.offset += oSegment.count;
                oSegment.count = iLength - oSegment.count;
                oBounds.x = SyntaxView.drawText(oSegment, aoGraphics, oFontMetrics, this, oStyle, oBounds, aiBaseline);
                oSegment.offset = iSegmentOffset;
            }
            iOffset += iLength;
            oSegment.offset += iLength;
            oToken = oToken.moNext;
            yID = oToken.myID;
            iLength = oToken.miLength;
        }
        if (oContext.mbNextLineRequested && oContext.mbNextLineUnpainted) {
            oContext.mbNextLineUnpainted = false;
            this.forceRepaint(oFontMetrics, aiLineIndex + 1, 1);
        }
    }

    private static int drawText(Segment aoSegment, Graphics aoGraphics, FontMetrics aoMetrics, TabExpander aoTabExpander, SyntaxStyle aoStyle, Rectangle aoBounds, int aiBaseline) {
        int iX = aoBounds.x;
        int iY = aoBounds.y;
        int iNextX = iX;
        char[] aText = aoSegment.array;
        int iOffset = aoSegment.offset;
        int iCount = aoSegment.offset + aoSegment.count;
        int iCharWidth = 0;
        Font[] aFonts = maFonts;
        block4: for (int iIndex = iOffset; iIndex < iCount; ++iIndex) {
            switch (aText[iIndex]) {
                case '\t': {
                    iX = iNextX;
                    iNextX = (int)aoTabExpander.nextTabStop(iNextX, iIndex - iOffset);
                    iCharWidth = iNextX - iX;
                    continue block4;
                }
                case '\n': {
                    iCharWidth = 0;
                    iNextX += iCharWidth;
                    continue block4;
                }
                default: {
                    iCharWidth = aoMetrics.charWidth(aText[iIndex]);
                    aoGraphics.setColor(aoStyle.getBackground());
                    aoGraphics.fillRect(iNextX, aoBounds.y, iCharWidth, aoBounds.height);
                    aoGraphics.setColor(aoStyle.getForeground());
                    aoGraphics.setFont(aFonts[aoStyle.getFontStyle()]);
                    aoGraphics.drawChars(aText, iIndex, 1, iNextX, aiBaseline);
                    iNextX += iCharWidth;
                }
            }
        }
        return iNextX;
    }

    private void forceRepaint(FontMetrics aoFontMetrics, int aiLineIndex, int aiLines) {
        int iFontHeight = aoFontMetrics.getHeight();
        int iY = aiLineIndex * iFontHeight;
        Container oHostContainer = this.getContainer();
        Dimension oSize = oHostContainer.getSize();
        oHostContainer.repaint(0L, 0, iY, oSize.width, iFontHeight * aiLines);
    }

    public float nextTabStop(float afX, int aiOffset) {
        int iTabSize = ((SyntaxDocument)this.getDocument()).getTabSize();
        int iTabWidth = this.miTabSpace * iTabSize;
        if (iTabWidth == 0) {
            return afX;
        }
        int iPad = iTabWidth - ((int)afX + iTabWidth) % iTabWidth;
        return afX + (float)iPad;
    }

    protected void updateMetrics() {
        super.updateMetrics();
        Container oContainer = this.getContainer();
        Font oFont = oContainer.getFont();
        if (this.moFont != oFont) {
            this.moFont = oFont;
            this.moMetrics = this.metrics;
            this.miTabSpace = this.moMetrics.charWidth('m');
            SyntaxView.maFonts[0] = oFont.deriveFont(0);
            SyntaxView.maFonts[1] = oFont.deriveFont(1);
            SyntaxView.maFonts[2] = oFont.deriveFont(2);
            SyntaxView.maFonts[3] = oFont.deriveFont(3);
        }
    }
}

