/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.OFXException;
import com.webcohesion.ofx4j.client.BankAccount;
import com.webcohesion.ofx4j.client.impl.BaseAccountImpl;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.TransactionWrappedRequestMessage;
import com.webcohesion.ofx4j.domain.data.banking.BankAccountDetails;
import com.webcohesion.ofx4j.domain.data.banking.BankStatementRequest;
import com.webcohesion.ofx4j.domain.data.banking.BankStatementRequestTransaction;
import com.webcohesion.ofx4j.domain.data.banking.BankStatementResponse;
import com.webcohesion.ofx4j.domain.data.banking.BankStatementResponseTransaction;
import com.webcohesion.ofx4j.domain.data.banking.BankingRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.banking.BankingResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.common.StatementRange;
import com.webcohesion.ofx4j.domain.data.common.StatementRequest;
import com.webcohesion.ofx4j.domain.data.common.StatementResponse;

public class BankingAccountImpl
extends BaseAccountImpl<BankAccountDetails>
implements BankAccount {
    public BankingAccountImpl(BankAccountDetails details, String username, String password, FinancialInstitutionImpl institution) {
        super(details, username, password, institution);
    }

    @Override
    protected StatementResponse unwrapStatementResponse(ResponseEnvelope response) throws OFXException {
        BankingResponseMessageSet bankingSet = (BankingResponseMessageSet)response.getMessageSet(MessageSetType.banking);
        if (bankingSet == null) {
            throw new OFXException("No banking response message set.");
        }
        BankStatementResponseTransaction statementTransactionResponse = bankingSet.getStatementResponse();
        if (statementTransactionResponse == null) {
            throw new OFXException("No banking statement response transaction.");
        }
        BankStatementResponse statement = statementTransactionResponse.getMessage();
        if (statement == null) {
            throw new OFXException("No banking statement in the transaction.");
        }
        return statement;
    }

    @Override
    protected RequestMessageSet createRequestMessageSet(TransactionWrappedRequestMessage transaction) {
        BankingRequestMessageSet bankingRequest = new BankingRequestMessageSet();
        bankingRequest.setStatementRequest((BankStatementRequestTransaction)transaction);
        return bankingRequest;
    }

    @Override
    protected TransactionWrappedRequestMessage createTransaction() {
        return new BankStatementRequestTransaction();
    }

    @Override
    protected StatementRequest createStatementRequest(BankAccountDetails details, StatementRange range) {
        BankStatementRequest bankRequest = new BankStatementRequest();
        bankRequest.setAccount(details);
        bankRequest.setStatementRange(range);
        return bankRequest;
    }
}

