/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.OFXException;
import com.webcohesion.ofx4j.client.AccountStatement;
import com.webcohesion.ofx4j.client.FinancialInstitutionAccount;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.RequestEnvelope;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.TransactionWrappedRequestMessage;
import com.webcohesion.ofx4j.domain.data.banking.BankAccountDetails;
import com.webcohesion.ofx4j.domain.data.common.StatementRange;
import com.webcohesion.ofx4j.domain.data.common.StatementRequest;
import com.webcohesion.ofx4j.domain.data.common.StatementResponse;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountDetails;
import com.webcohesion.ofx4j.domain.data.investment.accounts.InvestmentAccountDetails;
import java.util.Date;

public abstract class BaseAccountImpl<D>
implements FinancialInstitutionAccount {
    private final D details;
    private final MessageSetType messageType;
    private final String username;
    private final String password;
    private final FinancialInstitutionImpl institution;

    protected BaseAccountImpl(D details, String username, String password, FinancialInstitutionImpl institution) {
        this.details = details;
        this.username = username;
        this.password = password;
        this.institution = institution;
        this.messageType = this.getMessageSetType(details);
    }

    protected MessageSetType getMessageSetType(D details) {
        MessageSetType messageType;
        if (details instanceof BankAccountDetails) {
            messageType = MessageSetType.banking;
        } else if (this.getDetails() instanceof CreditCardAccountDetails) {
            messageType = MessageSetType.creditcard;
        } else if (this.getDetails() instanceof InvestmentAccountDetails) {
            messageType = MessageSetType.investment;
        } else {
            throw new IllegalStateException("Illegal details: " + this.details.getClass().getName());
        }
        return messageType;
    }

    @Override
    public AccountStatement readStatement(Date start, Date end) throws OFXException {
        StatementRange range = new StatementRange();
        range.setIncludeTransactions(true);
        range.setStart(start);
        range.setEnd(end);
        RequestEnvelope request = this.institution.createAuthenticatedRequest(this.username, this.password);
        TransactionWrappedRequestMessage requestTransaction = this.createTransaction();
        requestTransaction.setWrappedMessage(this.createStatementRequest(this.getDetails(), range));
        request.getMessageSets().add(this.createRequestMessageSet(requestTransaction));
        ResponseEnvelope response = this.institution.sendRequest(request);
        this.institution.doGeneralValidationChecks(request, response);
        return this.unwrapStatementResponse(response);
    }

    protected abstract StatementResponse unwrapStatementResponse(ResponseEnvelope var1) throws OFXException;

    protected abstract RequestMessageSet createRequestMessageSet(TransactionWrappedRequestMessage var1);

    protected abstract TransactionWrappedRequestMessage createTransaction();

    protected abstract StatementRequest createStatementRequest(D var1, StatementRange var2);

    public D getDetails() {
        return this.details;
    }

    protected MessageSetType getMessageType() {
        return this.messageType;
    }
}

