/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.OFXException;
import com.webcohesion.ofx4j.client.CreditCardAccount;
import com.webcohesion.ofx4j.client.impl.BaseAccountImpl;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.TransactionWrappedRequestMessage;
import com.webcohesion.ofx4j.domain.data.common.StatementRange;
import com.webcohesion.ofx4j.domain.data.common.StatementRequest;
import com.webcohesion.ofx4j.domain.data.common.StatementResponse;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountDetails;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardStatementRequest;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardStatementRequestTransaction;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardStatementResponse;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardStatementResponseTransaction;

public class CreditCardAccountImpl
extends BaseAccountImpl<CreditCardAccountDetails>
implements CreditCardAccount {
    public CreditCardAccountImpl(CreditCardAccountDetails details, String username, String password, FinancialInstitutionImpl institution) {
        super(details, username, password, institution);
    }

    @Override
    protected StatementResponse unwrapStatementResponse(ResponseEnvelope response) throws OFXException {
        CreditCardResponseMessageSet creditCardSet = (CreditCardResponseMessageSet)response.getMessageSet(MessageSetType.creditcard);
        if (creditCardSet == null) {
            throw new OFXException("No credit card response message set.");
        }
        CreditCardStatementResponseTransaction statementTransactionResponse = creditCardSet.getStatementResponse();
        if (statementTransactionResponse == null) {
            throw new OFXException("No credit card statement response transaction.");
        }
        CreditCardStatementResponse statement = statementTransactionResponse.getMessage();
        if (statement == null) {
            throw new OFXException("No credit card statement in the transaction.");
        }
        return statement;
    }

    @Override
    protected RequestMessageSet createRequestMessageSet(TransactionWrappedRequestMessage transaction) {
        CreditCardRequestMessageSet creditCardRequest = new CreditCardRequestMessageSet();
        creditCardRequest.setStatementRequest((CreditCardStatementRequestTransaction)transaction);
        return creditCardRequest;
    }

    @Override
    protected TransactionWrappedRequestMessage createTransaction() {
        return new CreditCardStatementRequestTransaction();
    }

    @Override
    protected StatementRequest createStatementRequest(CreditCardAccountDetails details, StatementRange range) {
        CreditCardStatementRequest bankRequest = new CreditCardStatementRequest();
        bankRequest.setAccount(details);
        bankRequest.setStatementRange(range);
        return bankRequest;
    }
}

