/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.OFXException;
import com.webcohesion.ofx4j.OFXStatusException;
import com.webcohesion.ofx4j.OFXTransactionException;
import com.webcohesion.ofx4j.UnsupportedOFXSecurityTypeException;
import com.webcohesion.ofx4j.client.BankAccount;
import com.webcohesion.ofx4j.client.CreditCardAccount;
import com.webcohesion.ofx4j.client.FinancialInstitution;
import com.webcohesion.ofx4j.client.FinancialInstitutionData;
import com.webcohesion.ofx4j.client.FinancialInstitutionProfile;
import com.webcohesion.ofx4j.client.InvestmentAccount;
import com.webcohesion.ofx4j.client.NoOFXResponseException;
import com.webcohesion.ofx4j.client.context.OFXApplicationContextHolder;
import com.webcohesion.ofx4j.client.impl.BankingAccountImpl;
import com.webcohesion.ofx4j.client.impl.CreditCardAccountImpl;
import com.webcohesion.ofx4j.client.impl.InvestmentAccountImpl;
import com.webcohesion.ofx4j.client.net.OFXConnection;
import com.webcohesion.ofx4j.client.net.OFXConnectionException;
import com.webcohesion.ofx4j.domain.data.ApplicationSecurity;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.RequestEnvelope;
import com.webcohesion.ofx4j.domain.data.RequestMessage;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.ResponseMessage;
import com.webcohesion.ofx4j.domain.data.ResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.TransactionWrappedRequestMessage;
import com.webcohesion.ofx4j.domain.data.TransactionWrappedResponseMessage;
import com.webcohesion.ofx4j.domain.data.banking.BankAccountDetails;
import com.webcohesion.ofx4j.domain.data.common.Status;
import com.webcohesion.ofx4j.domain.data.common.StatusHolder;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountDetails;
import com.webcohesion.ofx4j.domain.data.investment.accounts.InvestmentAccountDetails;
import com.webcohesion.ofx4j.domain.data.profile.ProfileRequest;
import com.webcohesion.ofx4j.domain.data.profile.ProfileRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.profile.ProfileRequestTransaction;
import com.webcohesion.ofx4j.domain.data.profile.ProfileResponse;
import com.webcohesion.ofx4j.domain.data.profile.ProfileResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.profile.ProfileResponseTransaction;
import com.webcohesion.ofx4j.domain.data.signon.SignonRequest;
import com.webcohesion.ofx4j.domain.data.signon.SignonRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.signon.SignonResponse;
import com.webcohesion.ofx4j.domain.data.signon.SignonResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.signup.AccountInfoRequest;
import com.webcohesion.ofx4j.domain.data.signup.AccountInfoRequestTransaction;
import com.webcohesion.ofx4j.domain.data.signup.AccountInfoResponse;
import com.webcohesion.ofx4j.domain.data.signup.AccountInfoResponseTransaction;
import com.webcohesion.ofx4j.domain.data.signup.AccountProfile;
import com.webcohesion.ofx4j.domain.data.signup.SignupRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.signup.SignupResponseMessageSet;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;

public class FinancialInstitutionImpl
implements FinancialInstitution {
    private final OFXConnection connection;
    private final FinancialInstitutionData data;
    private String clientUID;
    private String language;

    public FinancialInstitutionImpl(FinancialInstitutionData data, OFXConnection connection) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("An OFX connection must be supplied");
        }
        this.data = data;
        this.connection = connection;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public FinancialInstitutionProfile readProfile() throws OFXException {
        RequestEnvelope request = this.createAuthenticatedRequest("anonymous00000000000000000000000", "anonymous00000000000000000000000");
        ProfileRequestMessageSet profileRequest = new ProfileRequestMessageSet();
        profileRequest.setProfileRequest(this.createProfileTransaction());
        request.getMessageSets().add(profileRequest);
        ResponseEnvelope response = this.sendRequest(request, this.getData().getOFXURL());
        this.doGeneralValidationChecks(request, response);
        return this.getProfile(response);
    }

    @Override
    public Collection<AccountProfile> readAccountProfiles(String username, String password) throws OFXException {
        RequestEnvelope request = this.createAuthenticatedRequest(username, password);
        SignupRequestMessageSet signupRequest = new SignupRequestMessageSet();
        signupRequest.setAccountInfoRequest(this.createAccountInfoTransaction());
        request.getMessageSets().add(signupRequest);
        ResponseEnvelope response = this.sendRequest(request, this.getData().getOFXURL());
        this.doGeneralValidationChecks(request, response);
        return this.getAccountProfiles(response);
    }

    @Override
    public BankAccount loadBankAccount(BankAccountDetails details, String username, String password) {
        return new BankingAccountImpl(details, username, password, this);
    }

    @Override
    public CreditCardAccount loadCreditCardAccount(CreditCardAccountDetails details, String username, String password) {
        return new CreditCardAccountImpl(details, username, password, this);
    }

    @Override
    public InvestmentAccount loadInvestmentAccount(InvestmentAccountDetails details, String username, String password) {
        return new InvestmentAccountImpl(details, username, password, this);
    }

    protected RequestEnvelope createAuthenticatedRequest(String username, String password) {
        RequestEnvelope request = new RequestEnvelope();
        TreeSet<RequestMessageSet> messageSets = new TreeSet<RequestMessageSet>();
        SignonRequestMessageSet signonRequestMessageSet = new SignonRequestMessageSet();
        SignonRequest signonRequest = this.createSignonRequest(username, password);
        if (null != this.language) {
            signonRequest.setLanguage(this.language);
        }
        signonRequestMessageSet.setSignonRequest(signonRequest);
        messageSets.add(signonRequestMessageSet);
        request.setMessageSets(messageSets);
        return request;
    }

    protected ResponseEnvelope sendRequest(RequestEnvelope request) throws OFXConnectionException {
        return this.getConnection().sendRequest(request, this.getData().getOFXURL());
    }

    protected ResponseEnvelope sendRequest(RequestEnvelope request, URL url) throws OFXConnectionException {
        return this.getConnection().sendRequest(request, url);
    }

    protected FinancialInstitutionProfile getProfile(ResponseEnvelope response) throws OFXException {
        ProfileResponseMessageSet profileSet = (ProfileResponseMessageSet)response.getMessageSet(MessageSetType.profile);
        if (profileSet == null) {
            throw new OFXException("No profile response set.");
        }
        ProfileResponseTransaction transactionResponse = profileSet.getProfileResponse();
        if (transactionResponse == null) {
            throw new OFXException("No profile transaction wrapper.");
        }
        ProfileResponse message = transactionResponse.getMessage();
        if (message == null) {
            throw new OFXException("No profile message.");
        }
        return message;
    }

    protected void doGeneralValidationChecks(RequestEnvelope request, ResponseEnvelope response) throws OFXException {
        if (response.getSecurity() != ApplicationSecurity.NONE) {
            throw new UnsupportedOFXSecurityTypeException(String.format("Unable to participate in %s security.", new Object[]{response.getSecurity()}));
        }
        if (!request.getUID().equals(response.getUID())) {
            throw new OFXException(String.format("Invalid transaction ID '%s' in response.  Expected: %s", response.getUID(), request));
        }
        for (RequestMessageSet requestSet : request.getMessageSets()) {
            SignonResponse signonResponse;
            ResponseMessageSet responseSet = response.getMessageSet(requestSet.getType());
            if (responseSet == null) {
                throw new NoOFXResponseException("No response for the " + (Object)((Object)requestSet.getType()) + " request.");
            }
            if (responseSet.getType() == MessageSetType.signon && (signonResponse = ((SignonResponseMessageSet)responseSet).getSignonResponse()) == null) {
                throw new NoOFXResponseException("No signon response.");
            }
            TreeSet<String> transactionIds = new TreeSet<String>();
            for (RequestMessage requestMessage : requestSet.getRequestMessages()) {
                if (!(requestMessage instanceof TransactionWrappedRequestMessage)) continue;
                transactionIds.add(((TransactionWrappedRequestMessage)requestMessage).getUID());
            }
            for (ResponseMessage responseMessage : responseSet.getResponseMessages()) {
                if (responseMessage instanceof StatusHolder) {
                    this.validateStatus((StatusHolder)((Object)responseMessage));
                }
                if (!(responseMessage instanceof TransactionWrappedResponseMessage)) continue;
                String uid = ((TransactionWrappedResponseMessage)responseMessage).getUID();
                if (uid == null) {
                    throw new OFXTransactionException("Invalid response transaction: no UID.");
                }
                if (transactionIds.remove(uid)) continue;
                throw new OFXTransactionException("Response to an unknown transaction: " + uid + ".");
            }
            if (transactionIds.isEmpty()) continue;
            throw new OFXTransactionException("No response to the following transactions: " + transactionIds);
        }
    }

    protected void validateStatus(StatusHolder statusHolder) throws OFXException {
        Status status = statusHolder.getStatus();
        if (status == null) {
            throw new OFXException("Invalid OFX response: no status returned in the " + statusHolder.getStatusHolderName() + " response.");
        }
        if (!Status.KnownCode.SUCCESS.equals(status.getCode())) {
            String message = status.getMessage();
            if (message == null) {
                message = "No response status code.";
                if (status.getCode() != null) {
                    message = status.getCode().getMessage();
                }
            }
            throw new OFXStatusException(status, "Invalid " + statusHolder.getStatusHolderName() + ": " + message);
        }
    }

    protected ProfileRequestTransaction createProfileTransaction() {
        ProfileRequestTransaction profileTx = new ProfileRequestTransaction();
        profileTx.setMessage(this.createProfileRequest());
        return profileTx;
    }

    protected ProfileRequest createProfileRequest() {
        ProfileRequest profileRequest = new ProfileRequest();
        profileRequest.setProfileLastUpdated(new Date(0L));
        return profileRequest;
    }

    protected SignonRequest createSignonRequest(String username, String password) {
        SignonRequest signonRequest = new SignonRequest();
        signonRequest.setTimestamp(new Date());
        com.webcohesion.ofx4j.domain.data.signon.FinancialInstitution fi = new com.webcohesion.ofx4j.domain.data.signon.FinancialInstitution();
        fi.setId(this.getData().getFinancialInstitutionId());
        fi.setOrganization(this.getData().getOrganization());
        if (null != this.language) {
            signonRequest.setLanguage(this.language);
        }
        signonRequest.setFinancialInstitution(fi);
        signonRequest.setUserId(username);
        signonRequest.setPassword(password);
        signonRequest.setClientUID(this.clientUID);
        signonRequest.setApplicationId(OFXApplicationContextHolder.getCurrentContext().getAppId());
        signonRequest.setApplicationVersion(OFXApplicationContextHolder.getCurrentContext().getAppVersion());
        return signonRequest;
    }

    protected AccountInfoRequestTransaction createAccountInfoTransaction() {
        AccountInfoRequestTransaction transaction = new AccountInfoRequestTransaction();
        transaction.setMessage(this.createAccountInfoRequest());
        return transaction;
    }

    protected AccountInfoRequest createAccountInfoRequest() {
        AccountInfoRequest accountInfoRequest = new AccountInfoRequest();
        accountInfoRequest.setLastUpdated(new Date(0L));
        return accountInfoRequest;
    }

    protected Collection<AccountProfile> getAccountProfiles(ResponseEnvelope response) throws OFXException {
        SignupResponseMessageSet messageSet = (SignupResponseMessageSet)response.getMessageSet(MessageSetType.signup);
        if (messageSet == null) {
            throw new OFXException("No signup response message set.");
        }
        AccountInfoResponseTransaction transaction = messageSet.getAccountInfoResponse();
        if (transaction == null) {
            throw new OFXException("No account info transaction in the signup response.");
        }
        AccountInfoResponse infoResponse = transaction.getMessage();
        if (infoResponse == null) {
            throw new OFXException("No account info response in the transaction.");
        }
        return infoResponse.getAccounts();
    }

    public OFXConnection getConnection() {
        return this.connection;
    }

    @Override
    public FinancialInstitutionData getData() {
        return this.data;
    }

    @Override
    public String getClientUID() {
        return this.clientUID;
    }

    @Override
    public void setClientUID(String clientUID) {
        this.clientUID = clientUID;
    }
}

