/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.OFXException;
import com.webcohesion.ofx4j.client.InvestmentAccount;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.RequestEnvelope;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.domain.data.common.StatementRange;
import com.webcohesion.ofx4j.domain.data.investment.accounts.InvestmentAccountDetails;
import com.webcohesion.ofx4j.domain.data.investment.statements.IncludePosition;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementRequest;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementRequestTransaction;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementResponse;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.investment.statements.InvestmentStatementResponseTransaction;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityList;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityListRequest;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityListRequestMessageSet;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityListRequestTransaction;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityListResponseMessageSet;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityRequest;
import java.util.Date;
import java.util.List;

public class InvestmentAccountImpl
implements InvestmentAccount {
    private final InvestmentAccountDetails details;
    private final String username;
    private final String password;
    private final FinancialInstitutionImpl institution;

    public InvestmentAccountImpl(InvestmentAccountDetails details, String username, String password, FinancialInstitutionImpl institution) {
        this.details = details;
        this.username = username;
        this.password = password;
        this.institution = institution;
    }

    @Override
    public InvestmentStatementResponse readStatement(Date start, Date end) throws OFXException {
        StatementRange range = new StatementRange();
        range.setIncludeTransactions(true);
        range.setStart(start);
        range.setEnd(end);
        RequestEnvelope request = this.institution.createAuthenticatedRequest(this.username, this.password);
        InvestmentStatementRequestTransaction requestTransaction = new InvestmentStatementRequestTransaction();
        requestTransaction.setWrappedMessage(this.createStatementRequest(this.getDetails(), range));
        request.getMessageSets().add(this.createStatementRequestMessageSet(requestTransaction));
        ResponseEnvelope response = this.institution.sendRequest(request);
        this.institution.doGeneralValidationChecks(request, response);
        return this.unwrapStatementResponse(response);
    }

    @Override
    public SecurityList readSecurityList(List<SecurityRequest> securities) throws OFXException {
        RequestEnvelope request = this.institution.createAuthenticatedRequest(this.username, this.password);
        SecurityListRequestTransaction requestTransaction = new SecurityListRequestTransaction();
        requestTransaction.setWrappedMessage(this.createSecurityListRequest(securities));
        request.getMessageSets().add(this.createSecurityListRequestMessageSet(requestTransaction));
        ResponseEnvelope response = this.institution.sendRequest(request);
        this.institution.doGeneralValidationChecks(request, response);
        return this.unwrapSecurityList(response);
    }

    @Override
    public InvestmentAccountDetails getDetails() {
        return this.details;
    }

    private InvestmentStatementResponse unwrapStatementResponse(ResponseEnvelope response) throws OFXException {
        InvestmentStatementResponseMessageSet investmentStatementSet = (InvestmentStatementResponseMessageSet)response.getMessageSet(MessageSetType.investment);
        if (investmentStatementSet == null) {
            throw new OFXException("No investment response message set.");
        }
        InvestmentStatementResponseTransaction statementTransactionResponse = investmentStatementSet.getStatementResponse();
        if (statementTransactionResponse == null) {
            throw new OFXException("No investment statement response transaction.");
        }
        InvestmentStatementResponse statement = statementTransactionResponse.getMessage();
        if (statement == null) {
            throw new OFXException("No investment statement in the transaction.");
        }
        SecurityListResponseMessageSet securityListMessageSet = (SecurityListResponseMessageSet)response.getMessageSet(MessageSetType.investment_security);
        if (securityListMessageSet != null) {
            statement.setSecurityList(securityListMessageSet.getSecurityList());
        }
        return statement;
    }

    private RequestMessageSet createStatementRequestMessageSet(InvestmentStatementRequestTransaction transaction) {
        InvestmentStatementRequestMessageSet investmentStatementRequest = new InvestmentStatementRequestMessageSet();
        investmentStatementRequest.setStatementRequest(transaction);
        return investmentStatementRequest;
    }

    private InvestmentStatementRequest createStatementRequest(InvestmentAccountDetails details, StatementRange range) {
        InvestmentStatementRequest investRequest = new InvestmentStatementRequest();
        investRequest.setAccount(details);
        investRequest.setStatementRange(range);
        investRequest.setIncludePosition(new IncludePosition());
        return investRequest;
    }

    private RequestMessageSet createSecurityListRequestMessageSet(SecurityListRequestTransaction transaction) {
        SecurityListRequestMessageSet securityListRequest = new SecurityListRequestMessageSet();
        securityListRequest.setSecurityListRequest(transaction);
        return securityListRequest;
    }

    private SecurityListRequest createSecurityListRequest(List<SecurityRequest> securities) {
        SecurityListRequest securityListRequest = new SecurityListRequest();
        securityListRequest.setSecurityRequests(securities);
        return securityListRequest;
    }

    private SecurityList unwrapSecurityList(ResponseEnvelope response) throws OFXException {
        SecurityListResponseMessageSet securityListSet = (SecurityListResponseMessageSet)response.getMessageSet(MessageSetType.investment_security);
        if (securityListSet == null) {
            throw new OFXException("No security list response message set.");
        }
        SecurityList securityList = securityListSet.getSecurityList();
        if (securityList == null) {
            throw new OFXException("No security list response transaction.");
        }
        return securityList;
    }
}

