/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.client.FinancialInstitutionData;
import com.webcohesion.ofx4j.client.FinancialInstitutionDataStore;
import com.webcohesion.ofx4j.client.impl.BaseFinancialInstitutionData;
import com.webcohesion.ofx4j.client.impl.FIDataList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalResourceFIDataStore
implements FinancialInstitutionDataStore {
    private static final Log LOG = LogFactory.getLog(LocalResourceFIDataStore.class);
    private final Map<String, FinancialInstitutionData> fiData;

    public LocalResourceFIDataStore() throws IOException {
        this(LocalResourceFIDataStore.class.getResourceAsStream("/META-INF/ofx4j/institutions.xml"));
    }

    public LocalResourceFIDataStore(File in) throws IOException {
        this(new FileInputStream(in));
    }

    public LocalResourceFIDataStore(InputStream in) throws IOException {
        HashMap<String, FinancialInstitutionData> fiData = new HashMap<String, FinancialInstitutionData>();
        if (in != null) {
            try {
                FIDataList list = (FIDataList)JAXBContext.newInstance((Class[])new Class[]{FIDataList.class}).createUnmarshaller().unmarshal(in);
                if (list != null && list.getData() != null) {
                    for (BaseFinancialInstitutionData fi : list.getData()) {
                        fiData.put(fi.getId(), fi);
                    }
                }
            }
            catch (JAXBException e) {
                throw new IOException(e.getMessage());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(fiData.size() + " institutions loaded."));
            }
        }
        this.fiData = fiData;
    }

    @Override
    public FinancialInstitutionData getInstitutionData(String fid) {
        return this.fiData.get(fid);
    }

    @Override
    public List<FinancialInstitutionData> getInstitutionDataList() {
        return new ArrayList<FinancialInstitutionData>(this.fiData.values());
    }

    public void add(BaseFinancialInstitutionData data) {
        this.fiData.put(data.getId(), data);
    }

    public void storeData(OutputStream out) throws IOException {
        try {
            FIDataList dataList = new FIDataList();
            ArrayList<BaseFinancialInstitutionData> data = new ArrayList<BaseFinancialInstitutionData>();
            for (FinancialInstitutionData datum : this.fiData.values()) {
                if (!(datum instanceof BaseFinancialInstitutionData)) continue;
                data.add((BaseFinancialInstitutionData)datum);
            }
            dataList.setData(data);
            JAXBContext.newInstance((Class[])new Class[]{FIDataList.class}).createMarshaller().marshal((Object)dataList, out);
        }
        catch (JAXBException e) {
            throw new IOException(e.getMessage());
        }
    }
}

