/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.impl;

import com.webcohesion.ofx4j.client.FinancialInstitutionData;
import com.webcohesion.ofx4j.client.FinancialInstitutionDataStore;
import com.webcohesion.ofx4j.client.impl.BaseFinancialInstitutionData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OFXHomeFIDataStore
implements FinancialInstitutionDataStore {
    private static final Log LOG = LogFactory.getLog(OFXHomeFIDataStore.class);
    public static final Pattern INSTITUTION_HREF_PATTERN = Pattern.compile("http\\://www.ofxhome.com/index.php/institution/view/\\w+");
    private String url = "http://www.ofxhome.com/index.php/home/directory/all";
    private Map<String, FinancialInstitutionData> fiData;

    @Override
    public FinancialInstitutionData getInstitutionData(String fid) {
        return this.getFiData().get(fid);
    }

    @Override
    public List<FinancialInstitutionData> getInstitutionDataList() {
        return new ArrayList<FinancialInstitutionData>(this.getFiData().values());
    }

    public synchronized Map<String, FinancialInstitutionData> getFiData() {
        if (this.fiData == null) {
            this.fiData = new HashMap<String, FinancialInstitutionData>();
            try {
                this.initializeFIData();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(this.fiData.size() + " institutions loaded from " + this.getUrl()));
                }
            }
            catch (Exception e) {
                this.fiData = Collections.emptyMap();
            }
        }
        return this.fiData;
    }

    private void initializeFIData() throws IOException, SAXException {
        URL url = new URL(this.getUrl());
        Parser xmlReader = new Parser();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xmlReader.setFeature("http://xml.org/sax/features/validation", false);
        xmlReader.setContentHandler(new DirectoryContentHandler());
        xmlReader.parse(new InputSource(url.openStream()));
    }

    private BaseFinancialInstitutionData loadInstitutionData(String href) throws IOException, SAXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Loading institution data from: " + href));
        }
        URL url = new URL(href);
        Parser xmlReader = new Parser();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xmlReader.setFeature("http://xml.org/sax/features/validation", false);
        InstitutionContentHandler institutionHandler = new InstitutionContentHandler();
        xmlReader.setContentHandler(institutionHandler);
        xmlReader.parse(new InputSource(url.openStream()));
        return institutionHandler.data;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class InstitutionContentHandler
    extends DefaultHandler {
        private FIField currentField = null;
        private StringBuilder fieldNameBuffer = null;
        private StringBuilder fieldValueBuffer = null;
        private BaseFinancialInstitutionData data;

        private InstitutionContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.data = new BaseFinancialInstitutionData(UUID.randomUUID().toString());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("td".equalsIgnoreCase(qName)) {
                if (this.fieldNameBuffer == null) {
                    this.fieldNameBuffer = new StringBuilder();
                } else if (this.currentField != null) {
                    this.fieldValueBuffer = new StringBuilder();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("td".equalsIgnoreCase(qName)) {
                if (this.currentField == null) {
                    if (this.fieldNameBuffer != null) {
                        String fieldName = this.fieldNameBuffer.toString().toLowerCase();
                        if (fieldName.contains("fi id")) {
                            this.currentField = FIField.ID;
                            return;
                        }
                        if (fieldName.contains("fi org")) {
                            this.currentField = FIField.ORG;
                            return;
                        }
                        if (fieldName.contains("fi url")) {
                            this.currentField = FIField.URL;
                            return;
                        }
                        if (fieldName.contains("fi broker id")) {
                            this.currentField = FIField.BROKERID;
                            return;
                        }
                    }
                } else if (this.fieldValueBuffer != null) {
                    String fieldValue = this.fieldValueBuffer.toString().trim();
                    if ("".equals(fieldValue)) {
                        fieldValue = null;
                    }
                    switch (this.currentField) {
                        case ID: {
                            this.data.setFinancialInstitutionId(fieldValue);
                            break;
                        }
                        case BROKERID: {
                            this.data.setBrokerId(fieldValue);
                            break;
                        }
                        case ORG: {
                            this.data.setOrganization(fieldValue);
                            break;
                        }
                        case URL: {
                            try {
                                this.data.setOFXURL(new URL(fieldValue));
                                break;
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
                this.currentField = null;
                this.fieldNameBuffer = null;
                this.fieldValueBuffer = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentField != null && this.fieldValueBuffer != null) {
                this.fieldValueBuffer.append(ch, start, length);
            } else if (this.fieldNameBuffer != null) {
                this.fieldNameBuffer.append(ch, start, length);
            }
        }
    }

    private static enum FIField {
        ID,
        ORG,
        URL,
        BROKERID;

    }

    private class DirectoryContentHandler
    extends DefaultHandler {
        private Set<String> visited = new TreeSet<String>();

        private DirectoryContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("a".equalsIgnoreCase(qName) || "a".equalsIgnoreCase(localName)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Matcher matcher;
                    String href = attributes.getValue("href");
                    if (href == null || !(matcher = INSTITUTION_HREF_PATTERN.matcher(href)).matches() || !this.visited.add(href)) continue;
                    try {
                        BaseFinancialInstitutionData data = OFXHomeFIDataStore.this.loadInstitutionData(href);
                        data.setName(attributes.getValue("title"));
                        OFXHomeFIDataStore.this.fiData.put(data.getId(), data);
                        continue;
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                }
            }
        }
    }
}

