/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.main;

import com.webcohesion.ofx4j.client.FinancialInstitutionData;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.client.impl.LocalResourceFIDataStore;
import com.webcohesion.ofx4j.client.net.OFXV1Connection;
import com.webcohesion.ofx4j.domain.data.signup.AccountInfoResponse;
import com.webcohesion.ofx4j.domain.data.signup.AccountProfile;
import com.webcohesion.ofx4j.io.AggregateMarshaller;
import com.webcohesion.ofx4j.io.v1.OFXV1Writer;
import com.webcohesion.ofx4j.io.v2.OFXV2Writer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

public class DownloadAccountInfo {
    @Option(name="-f", aliases={"-fid"}, required=true, usage="The financial institution id. (Look it up at http://www.ofxhome.com/index.php/home/directory)")
    private String fid;
    @Option(name="-u", aliases={"-username"}, required=true, usage="The username of the user with an account.")
    private String username;
    @Option(name="-p", aliases={"-password"}, required=true, usage="The password of the user with an account.")
    private String password;
    @Option(name="-o", aliases={"-out"}, usage="The file to write the statement to.")
    private File out;
    @Option(name="-2", aliases={"-v2"}, usage="Whether to print the statement in OFX version 2.")
    private boolean v2 = false;

    public void doMain(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.setUsageWidth(120);
        try {
            parser.parseArgument(args);
            LocalResourceFIDataStore dataStore = new LocalResourceFIDataStore();
            FinancialInstitutionData data = null;
            for (FinancialInstitutionData item : dataStore.getInstitutionDataList()) {
                if (!this.fid.equals(item.getFinancialInstitutionId())) continue;
                data = item;
                break;
            }
            if (data == null) {
                this.exit("Unknown financial institution: " + this.fid);
            }
            OFXV1Connection connection = new OFXV1Connection();
            FinancialInstitutionImpl fi = new FinancialInstitutionImpl(data, connection);
            Collection<AccountProfile> profiles = fi.readAccountProfiles(this.username, this.password);
            AccountInfoResponse accountsElement = new AccountInfoResponse();
            accountsElement.setAccounts(profiles);
            AggregateMarshaller marshaller = new AggregateMarshaller();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            OFXV1Writer writer = new OFXV1Writer(bytes);
            writer.setWriteAttributesOnNewLine(true);
            if (this.v2) {
                writer = new OFXV2Writer(bytes);
            }
            marshaller.marshal(accountsElement, writer);
            writer.close();
            System.out.println(bytes.toString());
            System.out.flush();
            if (this.out != null) {
                FileOutputStream stream = new FileOutputStream(this.out);
                stream.write(bytes.toByteArray());
                stream.flush();
                stream.close();
            }
        }
        catch (CmdLineException e) {
            this.invalidArgs(parser, e);
        }
    }

    private void invalidArgs(CmdLineParser parser, CmdLineException e) {
        System.err.println(e.getMessage());
        System.err.println("java DownloadAccountInfo [options...] arguments...");
        parser.printUsage((OutputStream)System.err);
        System.err.println();
        System.err.println("  Example: java DownloadAccountInfo " + parser.printExample(ExampleMode.ALL));
        System.exit(1);
    }

    private void exit(String message) {
        System.out.println(message);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        new DownloadAccountInfo().doMain(args);
    }

    public static enum FinancialInstitutionAccountType {
        banking,
        creditcard;

    }
}

