/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.main;

import com.webcohesion.ofx4j.client.AccountStatement;
import com.webcohesion.ofx4j.client.FinancialInstitutionAccount;
import com.webcohesion.ofx4j.client.FinancialInstitutionData;
import com.webcohesion.ofx4j.client.impl.FinancialInstitutionImpl;
import com.webcohesion.ofx4j.client.impl.LocalResourceFIDataStore;
import com.webcohesion.ofx4j.client.net.OFXV1Connection;
import com.webcohesion.ofx4j.domain.data.banking.AccountType;
import com.webcohesion.ofx4j.domain.data.banking.BankAccountDetails;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountDetails;
import com.webcohesion.ofx4j.io.AggregateMarshaller;
import com.webcohesion.ofx4j.io.v1.OFXV1Writer;
import com.webcohesion.ofx4j.io.v2.OFXV2Writer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

public class DownloadStatement {
    @Option(name="-s", aliases={"-start"}, usage="The start date (yyyy-MM-dd).")
    private String startDateValue;
    @Option(name="-e", aliases={"-end"}, usage="The end date (yyyy-MM-dd).")
    private String endDateValue;
    @Option(name="-f", aliases={"-fid"}, required=true, usage="The financial institution id. (Look it up at http://www.ofxhome.com/index.php/home/directory)")
    private String fid;
    @Option(name="-t", aliases={"-account-type"}, required=true, usage="The account type.")
    private FinancialInstitutionAccountType accountType;
    @Option(name="-u", aliases={"-username"}, required=true, usage="The username of the user with an account.")
    private String username;
    @Option(name="-p", aliases={"-password"}, required=true, usage="The password of the user with an account.")
    private String password;
    @Option(name="-n", aliases={"-account-number"}, required=true, usage="The account number.")
    private String accountNumber;
    @Option(name="-b", aliases={"-bank-account-type"}, usage="The banking account type (ignored for credit card accounts).")
    private AccountType bankAccountType;
    @Option(name="-r", aliases={"-routing-number", "-bank-id"}, usage="The routing number (i.e. bank id).")
    private String routingNumber;
    @Option(name="-o", aliases={"-out"}, usage="The file to write the statement to.")
    private File out;
    @Option(name="-2", aliases={"-v2"}, usage="Whether to print the statement in OFX version 2.")
    private boolean v2 = false;

    public void doMain(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.setUsageWidth(120);
        try {
            FinancialInstitutionAccount account;
            parser.parseArgument(args);
            LocalResourceFIDataStore dataStore = new LocalResourceFIDataStore();
            FinancialInstitutionData data = null;
            for (FinancialInstitutionData item : dataStore.getInstitutionDataList()) {
                if (!this.fid.equals(item.getFinancialInstitutionId())) continue;
                data = item;
                break;
            }
            if (data == null) {
                this.exit("Unknown financial institution: " + this.fid);
            }
            OFXV1Connection connection = new OFXV1Connection();
            FinancialInstitutionImpl fi = new FinancialInstitutionImpl(data, connection);
            switch (this.accountType) {
                case banking: {
                    if (this.bankAccountType == null) {
                        throw new CmdLineException("A bank account type must be specified.");
                    }
                    if (this.routingNumber == null) {
                        throw new CmdLineException("A routing number must be specified.");
                    }
                    BankAccountDetails details = new BankAccountDetails();
                    details.setAccountNumber(this.accountNumber);
                    details.setAccountType(this.bankAccountType);
                    details.setBankId(this.routingNumber);
                    account = fi.loadBankAccount(details, this.username, this.password);
                    break;
                }
                case creditcard: {
                    CreditCardAccountDetails ccDetails = new CreditCardAccountDetails();
                    ccDetails.setAccountNumber(this.accountNumber);
                    account = fi.loadCreditCardAccount(ccDetails, this.username, this.password);
                    break;
                }
                default: {
                    throw new CmdLineException("Invalid institution account type: " + (Object)((Object)this.accountType));
                }
            }
            Date endDate = new Date();
            if (this.endDateValue != null) {
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(this.endDateValue);
            }
            Date startDate = this.startDateValue != null ? new SimpleDateFormat("yyyy-MM-dd").parse(this.startDateValue) : new Date(endDate.getTime() - 2419200000L);
            AccountStatement statement = account.readStatement(startDate, endDate);
            AggregateMarshaller marshaller = new AggregateMarshaller();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            OFXV1Writer writer = new OFXV1Writer(bytes);
            writer.setWriteAttributesOnNewLine(true);
            if (this.v2) {
                writer = new OFXV2Writer(bytes);
            }
            marshaller.marshal(statement, writer);
            writer.close();
            System.out.println(bytes.toString());
            System.out.flush();
            if (this.out != null) {
                FileOutputStream stream = new FileOutputStream(this.out);
                stream.write(bytes.toByteArray());
                stream.flush();
                stream.close();
            }
        }
        catch (CmdLineException e) {
            this.invalidArgs(parser, e);
        }
    }

    private void invalidArgs(CmdLineParser parser, CmdLineException e) {
        System.err.println(e.getMessage());
        System.err.println("java DownloadStatement [options...] arguments...");
        parser.printUsage((OutputStream)System.err);
        System.err.println();
        System.err.println("  Example: java DownloadStatement " + parser.printExample(ExampleMode.ALL));
        System.exit(1);
    }

    private void exit(String message) {
        System.out.println(message);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        new DownloadStatement().doMain(args);
    }

    public static enum FinancialInstitutionAccountType {
        banking,
        creditcard;

    }
}

