/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.client.net;

import com.webcohesion.ofx4j.client.net.OFXConnection;
import com.webcohesion.ofx4j.client.net.OFXConnectionException;
import com.webcohesion.ofx4j.client.net.OFXServerException;
import com.webcohesion.ofx4j.domain.data.RequestEnvelope;
import com.webcohesion.ofx4j.domain.data.ResponseEnvelope;
import com.webcohesion.ofx4j.io.AggregateMarshaller;
import com.webcohesion.ofx4j.io.AggregateUnmarshaller;
import com.webcohesion.ofx4j.io.OFXParseException;
import com.webcohesion.ofx4j.io.OFXWriter;
import com.webcohesion.ofx4j.io.v1.OFXV1Writer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OFXV1Connection
implements OFXConnection {
    private static final Log LOG = LogFactory.getLog(OFXV1Connection.class);
    private AggregateMarshaller marshaller = new AggregateMarshaller();
    private AggregateUnmarshaller<ResponseEnvelope> unmarshaller = new AggregateUnmarshaller<ResponseEnvelope>(ResponseEnvelope.class);

    @Override
    public ResponseEnvelope sendRequest(RequestEnvelope request, URL url) throws OFXConnectionException {
        try {
            if (!url.getProtocol().toLowerCase().startsWith("http")) {
                throw new IllegalArgumentException("Invalid URL: " + url + " only http(s) is supported.");
            }
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            OFXWriter ofxWriter = this.newOFXWriter(outBuffer);
            this.getMarshaller().marshal(request, ofxWriter);
            ofxWriter.close();
            this.logRequest(outBuffer);
            InputStream in = this.sendBuffer(url, outBuffer);
            return this.unmarshal(in);
        }
        catch (IOException e) {
            throw new OFXConnectionException(e);
        }
    }

    protected void logRequest(ByteArrayOutputStream outBuffer) throws UnsupportedEncodingException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Marshalling " + outBuffer.size() + " bytes of the OFX request."));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)outBuffer.toString("utf-8"));
            }
        }
    }

    protected InputStream sendBuffer(URL url, ByteArrayOutputStream outBuffer) throws IOException, OFXConnectionException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-ofx");
        connection.setRequestProperty("Content-Length", String.valueOf(outBuffer.size()));
        connection.setRequestProperty("Accept", "*/*, application/x-ofx");
        connection.setDoOutput(true);
        connection.connect();
        OutputStream out = connection.getOutputStream();
        out.write(outBuffer.toByteArray());
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            if (responseCode >= 400 && responseCode < 500) {
                throw new OFXServerException("Error with client request: " + connection.getResponseMessage(), responseCode);
            }
            throw new OFXServerException("Invalid response code from OFX server: " + connection.getResponseMessage(), responseCode);
        }
        InputStream in = connection.getInputStream();
        return in;
    }

    protected ResponseEnvelope unmarshal(InputStream in) throws IOException, OFXConnectionException {
        try {
            return this.getUnmarshaller().unmarshal(in);
        }
        catch (OFXParseException e) {
            throw new OFXConnectionException("Unable to parse the OFX response.", e);
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected OFXWriter newOFXWriter(OutputStream out) {
        return new OFXV1Writer(out);
    }

    public AggregateMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(AggregateMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public AggregateUnmarshaller<ResponseEnvelope> getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(AggregateUnmarshaller<ResponseEnvelope> unmarshaller) {
        this.unmarshaller = unmarshaller;
    }
}

