/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.common;

import com.webcohesion.ofx4j.domain.data.common.StatusCode;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="STATUS")
public class Status {
    private StatusCode code = KnownCode.SUCCESS;
    private Severity severity;
    private String message;

    @Element(name="CODE", required=true, order=0)
    public StatusCode getCode() {
        return this.code;
    }

    public void setCode(StatusCode code) {
        this.code = code;
        if (this.severity == null) {
            this.severity = code.getDefaultSeverity();
        }
    }

    @Element(name="SEVERITY", required=true, order=10)
    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Element(name="MESSAGE", order=20)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static enum KnownCode implements StatusCode
    {
        SUCCESS(0, "Success", Severity.INFO),
        CLIENT_UP_TO_DATE(1, "Client is up-to-date", Severity.INFO),
        GENERAL_ERROR(2000, "General error.", Severity.ERROR),
        GENERAL_ACCOUNT_ERROR(2002, "General account error.", Severity.ERROR),
        ACCOUNT_NOT_FOUND(2003, "Account not found.", Severity.ERROR),
        ACCOUNT_CLOSED(2004, "Account closed.", Severity.ERROR),
        ACCOUNT_NOT_AUTHORIZED(2005, "Account not authorized.", Severity.ERROR),
        DATE_TOO_SOON(2014, "Date too soon", Severity.ERROR),
        DUPLICATE_REQUEST(2019, "Duplicate request.", Severity.ERROR),
        UNSUPPORTED_VERSION(2021, "Unsupported version", Severity.ERROR),
        INVALID_TAN(2022, "Invalid transaction authorization number.", Severity.ERROR),
        MFA_CHALLENGE_REQUIRED(3000, "Further authentication required.", Severity.ERROR),
        MFA_CHALLENGE_FAILED(3001, "MFA failed.", Severity.ERROR),
        PASSWORD_CHANGE_REQUIRED(15000, "Password change required.", Severity.INFO),
        SIGNON_INVALID(15500, "Invalid signon", Severity.ERROR),
        CUSTOMER_ACCOUNT_IN_USE(15501, "Customer account in use.", Severity.ERROR),
        PASSWORD_LOCKED(15502, "Password locked.", Severity.ERROR),
        INVALID_CLIENT_UID(15510, "Invalid client UID.", Severity.ERROR),
        CONTACT_FI(15511, "User must contact FI.", Severity.ERROR),
        AUTHTOKEN_REQUIRED(15512, "Auth token required.", Severity.ERROR),
        INVALID_AUTHTOKEN(15513, "Invalid auth token.", Severity.ERROR),
        NO_DATA(14701, "No Tax Data for Account.", Severity.ERROR),
        DB_EXCEPTION(14702, "Database error has occured.", Severity.ERROR),
        NO_TAXSUPPORT(14703, "This Tax Year is not supported.", Severity.ERROR);

        private final int code;
        private final String message;
        private final Severity defaultSeverity;

        private KnownCode(int code, String message, Severity defaultSeverity) {
            this.code = code;
            this.message = message;
            this.defaultSeverity = defaultSeverity;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Severity getDefaultSeverity() {
            return this.defaultSeverity;
        }

        public static KnownCode fromCode(int code) {
            for (KnownCode value : KnownCode.values()) {
                if (value.getCode() != code) continue;
                return value;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }

    public static enum Severity {
        INFO,
        WARN,
        ERROR;

    }
}

