/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.common;

import com.webcohesion.ofx4j.domain.data.banking.BankAccountDetails;
import com.webcohesion.ofx4j.domain.data.common.CorrectionAction;
import com.webcohesion.ofx4j.domain.data.common.Currency;
import com.webcohesion.ofx4j.domain.data.common.Payee;
import com.webcohesion.ofx4j.domain.data.common.TransactionType;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountDetails;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.math.BigDecimal;
import java.util.Date;

@Aggregate(value="STMTTRN")
public class Transaction {
    private TransactionType transactionType;
    private Date datePosted;
    private Date dateInitiated;
    private Date dateAvailable;
    private BigDecimal amount;
    private String id;
    private String correctionId;
    private CorrectionAction correctionAction;
    private String tempId;
    private String checkNumber;
    private String referenceNumber;
    private String standardIndustrialCode;
    private String payeeId;
    private String name;
    private Payee payee;
    private BankAccountDetails bankAccountTo;
    private CreditCardAccountDetails creditCardAccountTo;
    private String memo;
    private Currency currency;
    private Currency originalCurrency;

    @Element(name="TRNTYPE", required=true, order=0)
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @Element(name="DTPOSTED", required=true, order=10)
    public Date getDatePosted() {
        return this.datePosted;
    }

    public void setDatePosted(Date datePosted) {
        this.datePosted = datePosted;
    }

    @Element(name="DTUSER", order=20)
    public Date getDateInitiated() {
        return this.dateInitiated;
    }

    public void setDateInitiated(Date dateInitiated) {
        this.dateInitiated = dateInitiated;
    }

    @Element(name="DTAVAIL", order=30)
    public Date getDateAvailable() {
        return this.dateAvailable;
    }

    public void setDateAvailable(Date dateAvailable) {
        this.dateAvailable = dateAvailable;
    }

    public Double getAmount() {
        return this.amount == null ? null : Double.valueOf(this.amount.doubleValue());
    }

    public void setAmount(Double amount) {
        this.amount = amount == null ? null : BigDecimal.valueOf(amount);
    }

    @Element(name="TRNAMT", required=true, order=40)
    public BigDecimal getBigDecimalAmount() {
        return this.amount;
    }

    public void setBigDecimalAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Element(name="FITID", required=true, order=50)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Element(name="CORRECTFITID", order=60)
    public String getCorrectionId() {
        return this.correctionId;
    }

    public void setCorrectionId(String correctionId) {
        this.correctionId = correctionId;
    }

    @Element(name="CORRECTACTION", order=70)
    public CorrectionAction getCorrectionAction() {
        return this.correctionAction;
    }

    public void setCorrectionAction(CorrectionAction correctionAction) {
        this.correctionAction = correctionAction;
    }

    @Element(name="SRVRTID", order=80)
    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    @Element(name="CHECKNUM", order=90)
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    @Element(name="REFNUM", order=100)
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Element(name="SIC", order=110)
    public String getStandardIndustrialCode() {
        return this.standardIndustrialCode;
    }

    public void setStandardIndustrialCode(String standardIndustrialCode) {
        this.standardIndustrialCode = standardIndustrialCode;
    }

    @Element(name="PAYEEID", order=120)
    public String getPayeeId() {
        return this.payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    @Element(name="NAME", order=130)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ChildAggregate(order=140)
    public Payee getPayee() {
        return this.payee;
    }

    public void setPayee(Payee payee) {
        this.payee = payee;
    }

    @ChildAggregate(name="BANKACCTTO", order=150)
    public BankAccountDetails getBankAccountTo() {
        return this.bankAccountTo;
    }

    public void setBankAccountTo(BankAccountDetails bankAccountTo) {
        this.bankAccountTo = bankAccountTo;
    }

    @ChildAggregate(name="CCACCTTO", order=160)
    public CreditCardAccountDetails getCreditCardAccountTo() {
        return this.creditCardAccountTo;
    }

    public void setCreditCardAccountTo(CreditCardAccountDetails creditCardAccountTo) {
        this.creditCardAccountTo = creditCardAccountTo;
    }

    @Element(name="MEMO", order=170)
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ChildAggregate(order=180)
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @ChildAggregate(name="ORIGCURRENCY", order=190)
    public Currency getOriginalCurrency() {
        return this.originalCurrency;
    }

    public void setOriginalCurrency(Currency originalCurrency) {
        this.originalCurrency = originalCurrency;
    }
}

