/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.inv401k;

import com.webcohesion.ofx4j.domain.data.investment.inv401k.LoanPaymentFrequency;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.util.Date;

@Aggregate(value="LOANINFO")
public class LoanInfo {
    private String id;
    private String description;
    private Double initialLoanBalance;
    private Date loanStartDate;
    private Double currentPrincipalBalance;
    private Date asOfDate;
    private Double annualInterestRate;
    private Double paymentAmount;
    private String paymentFrequency;
    private Integer initialPayments;
    private Integer remainingPayments;
    private Date loanEndDate;
    private Double projectedInterest;
    private Double interestPayed;
    private Date nextPaymentDueDate;

    @Element(name="LOANID", required=true, order=10)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Element(name="LOANDESC", order=20)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Element(name="INITIALLOANBAL", order=30)
    public Double getInitialLoanBalance() {
        return this.initialLoanBalance;
    }

    public void setInitialLoanBalance(Double initialLoanBalance) {
        this.initialLoanBalance = initialLoanBalance;
    }

    @Element(name="LOANSTARTDATE", order=40)
    public Date getLoanStartDate() {
        return this.loanStartDate;
    }

    public void setLoanStartDate(Date loanStartDate) {
        this.loanStartDate = loanStartDate;
    }

    @Element(name="CURRENTLOANBAL", required=true, order=50)
    public Double getCurrentPrincipalBalance() {
        return this.currentPrincipalBalance;
    }

    public void setCurrentPrincipalBalance(Double currentPrincipalBalance) {
        this.currentPrincipalBalance = currentPrincipalBalance;
    }

    @Element(name="DTASOF", required=true, order=60)
    public Date getAsOfDate() {
        return this.asOfDate;
    }

    public void setAsOfDate(Date asOfDate) {
        this.asOfDate = asOfDate;
    }

    @Element(name="LOANRATE", order=70)
    public Double getAnnualInterestRate() {
        return this.annualInterestRate;
    }

    public void setAnnualInterestRate(Double annualInterestRate) {
        this.annualInterestRate = annualInterestRate;
    }

    @Element(name="LOANPMTAMT", order=80)
    public Double getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(Double paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    @Element(name="LOANPMTFREQ", order=90)
    public String getPaymentFrequency() {
        return this.paymentFrequency;
    }

    public void setPaymentFrequency(String paymentFrequency) {
        this.paymentFrequency = paymentFrequency;
    }

    public LoanPaymentFrequency getPaymentFrequencyEnum() {
        return LoanPaymentFrequency.fromOfx(this.getPaymentFrequency());
    }

    @Element(name="LOANPMTSINITIAL", order=100)
    public Integer getInitialPayments() {
        return this.initialPayments;
    }

    public void setInitialPayments(Integer initialPayments) {
        this.initialPayments = initialPayments;
    }

    @Element(name="LOANPMTSREMAINING", order=110)
    public Integer getRemainingPayments() {
        return this.remainingPayments;
    }

    public void setRemainingPayments(Integer remainingPayments) {
        this.remainingPayments = remainingPayments;
    }

    @Element(name="LOANMATURITYDATE", order=120)
    public Date getLoanEndDate() {
        return this.loanEndDate;
    }

    public void setLoanEndDate(Date loanEndDate) {
        this.loanEndDate = loanEndDate;
    }

    @Element(name="LOANTOTALPROJINTEREST", order=130)
    public Double getProjectedInterest() {
        return this.projectedInterest;
    }

    public void setProjectedInterest(Double projectedInterest) {
        this.projectedInterest = projectedInterest;
    }

    @Element(name="LOANINTERESTTODATE", order=140)
    public Double getInterestPayed() {
        return this.interestPayed;
    }

    public void setInterestPayed(Double interestPayed) {
        this.interestPayed = interestPayed;
    }

    @Element(name="LOANNEXTPMTDATE", order=150)
    public Date getNextPaymentDueDate() {
        return this.nextPaymentDueDate;
    }

    public void setNextPaymentDueDate(Date nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
    }
}

