/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.positions;

import com.webcohesion.ofx4j.domain.data.common.Currency;
import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.positions.PositionType;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.util.Date;

@Aggregate(value="INVPOS")
public class InvestmentPosition {
    private SecurityId securityId;
    private String heldInAccount;
    private String positionType;
    private Double units;
    private Double unitPrice;
    private Double marketValue;
    private Date marketValueDate;
    private Currency currencyInfo;
    private String memo;
    private String inv401kSource;

    @ChildAggregate(required=true, order=10)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="HELDINACCT", required=true, order=20)
    public String getHeldInAccount() {
        return this.heldInAccount;
    }

    public void setHeldInAccount(String heldInAccount) {
        this.heldInAccount = heldInAccount;
    }

    SubAccountType getHeldInAccountEnum() {
        return SubAccountType.fromOfx(this.getHeldInAccount());
    }

    @Element(name="POSTYPE", required=true, order=30)
    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public PositionType getPositionTypeEnum() {
        return PositionType.fromOfx(this.getPositionType());
    }

    @Element(name="UNITS", required=true, order=40)
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    @Element(name="UNITPRICE", required=true, order=50)
    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Element(name="MKTVAL", required=true, order=60)
    public Double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(Double marketValue) {
        this.marketValue = marketValue;
    }

    @Element(name="DTPRICEASOF", required=true, order=70)
    public Date getMarketValueDate() {
        return this.marketValueDate;
    }

    public void setMarketValueDate(Date marketValueDate) {
        this.marketValueDate = marketValueDate;
    }

    @ChildAggregate(name="CURRENCY", order=80)
    public Currency getCurrencyInfo() {
        return this.currencyInfo;
    }

    public void setCurrencyInfo(Currency currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    @Element(name="MEMO", order=90)
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Element(name="INV401KSOURCE", order=100)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

