/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BuyInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.InvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.ChildAggregate;

public abstract class BaseBuyInvestmentTransaction
extends BaseInvestmentTransaction
implements TransactionWithSecurity {
    private BuyInvestmentTransaction buyInvestment;

    BaseBuyInvestmentTransaction(TransactionType transactionType) {
        super(transactionType);
    }

    @ChildAggregate(order=10)
    public BuyInvestmentTransaction getBuyInvestment() {
        return this.buyInvestment;
    }

    public void setBuyInvestment(BuyInvestmentTransaction buyInvestment) {
        this.buyInvestment = buyInvestment;
    }

    @Override
    public InvestmentTransaction getInvestmentTransaction() {
        return this.getBuyInvestment().getInvestmentTransaction();
    }

    @Override
    public SecurityId getSecurityId() {
        return this.getBuyInvestment().getSecurityId();
    }

    public Double getUnits() {
        return this.getBuyInvestment().getUnits();
    }

    public Double getUnitPrice() {
        return this.getBuyInvestment().getUnitPrice();
    }

    public Double getMarkup() {
        return this.getBuyInvestment().getMarkup();
    }

    public Double getCommission() {
        return this.getBuyInvestment().getCommission();
    }

    public Double getTaxes() {
        return this.getBuyInvestment().getTaxes();
    }

    public Double getFees() {
        return this.getBuyInvestment().getFees();
    }

    public Double getLoad() {
        return this.getBuyInvestment().getLoad();
    }

    public Double getTotal() {
        return this.getBuyInvestment().getTotal();
    }

    public OriginalCurrency getCurrencyInfo() {
        return this.getBuyInvestment().getCurrencyInfo();
    }

    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.getBuyInvestment().getOriginalCurrencyInfo();
    }

    public String getSubAccountSecurity() {
        return this.getBuyInvestment().getSubAccountSecurity();
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    public String getSubAccountFund() {
        return this.getBuyInvestment().getSubAccountFund();
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    public String getLoanId() {
        return this.getBuyInvestment().getLoanId();
    }

    public Double getLoanInterest() {
        return this.getBuyInvestment().getLoanInterest();
    }

    public Double getLoanPrincipal() {
        return this.getBuyInvestment().getLoanPrincipal();
    }

    public String get401kSource() {
        return this.getBuyInvestment().get401kSource();
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

