/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.InvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.SellInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.ChildAggregate;

public abstract class BaseSellInvestmentTransaction
extends BaseInvestmentTransaction
implements TransactionWithSecurity {
    private SellInvestmentTransaction sellInvestment;

    BaseSellInvestmentTransaction(TransactionType transactionType) {
        super(transactionType);
    }

    @ChildAggregate(order=10)
    public SellInvestmentTransaction getSellInvestment() {
        return this.sellInvestment;
    }

    public void setSellInvestment(SellInvestmentTransaction sellInvestment) {
        this.sellInvestment = sellInvestment;
    }

    @Override
    public InvestmentTransaction getInvestmentTransaction() {
        return this.getSellInvestment().getInvestmentTransaction();
    }

    @Override
    public SecurityId getSecurityId() {
        return this.getSellInvestment().getSecurityId();
    }

    public Double getUnits() {
        return this.getSellInvestment().getUnits();
    }

    public Double getUnitPrice() {
        return this.getSellInvestment().getUnitPrice();
    }

    public Double getMarkdown() {
        return this.getSellInvestment().getMarkdown();
    }

    public Double getCommission() {
        return this.getSellInvestment().getCommission();
    }

    public Double getTaxes() {
        return this.getSellInvestment().getTaxes();
    }

    public Double getFees() {
        return this.getSellInvestment().getFees();
    }

    public Double getLoad() {
        return this.getSellInvestment().getLoad();
    }

    public Double getWithholding() {
        return this.getSellInvestment().getWithholding();
    }

    public Boolean getTaxExempt() {
        return this.getSellInvestment().getTaxExempt();
    }

    public Double getTotal() {
        return this.getSellInvestment().getTotal();
    }

    public Double getGain() {
        return this.getSellInvestment().getGain();
    }

    public OriginalCurrency getCurrencyInfo() {
        return this.getSellInvestment().getCurrencyInfo();
    }

    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.getSellInvestment().getOriginalCurrencyInfo();
    }

    public String getSubAccountSecurity() {
        return this.getSellInvestment().getSubAccountSecurity();
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    public String getSubAccountFund() {
        return this.getSellInvestment().getSubAccountFund();
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    public String getLoadId() {
        return this.getSellInvestment().getLoanId();
    }

    public Double getStateWithholding() {
        return this.getSellInvestment().getStateWithholding();
    }

    public Double getPenalty() {
        return this.getSellInvestment().getPenalty();
    }

    public String get401kSource() {
        return this.getSellInvestment().get401kSource();
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

