/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.InvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="INVBUY")
public class BuyInvestmentTransaction {
    private InvestmentTransaction investmentTransaction;
    private SecurityId securityId;
    private Double units;
    private Double unitPrice;
    private Double markup;
    private Double commission;
    private Double taxes;
    private Double fees;
    private Double load;
    private Double total;
    private OriginalCurrency currencyInfo;
    private OriginalCurrency originalCurrencyInfo;
    private String subAccountSecurity;
    private String subAccountFund;
    private String loanId;
    private Double loanInterest;
    private Double loanPrincipal;
    private String inv401kSource;

    @ChildAggregate(order=10)
    public InvestmentTransaction getInvestmentTransaction() {
        return this.investmentTransaction;
    }

    public void setInvestmentTransaction(InvestmentTransaction investmentTransaction) {
        this.investmentTransaction = investmentTransaction;
    }

    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="UNITS", required=true, order=30)
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    @Element(name="UNITPRICE", required=true, order=40)
    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Element(name="MARKUP", order=50)
    public Double getMarkup() {
        return this.markup;
    }

    public void setMarkup(Double markup) {
        this.markup = markup;
    }

    @Element(name="COMMISSION", order=60)
    public Double getCommission() {
        return this.commission;
    }

    public void setCommission(Double commission) {
        this.commission = commission;
    }

    @Element(name="TAXES", order=70)
    public Double getTaxes() {
        return this.taxes;
    }

    public void setTaxes(Double taxes) {
        this.taxes = taxes;
    }

    @Element(name="FEES", order=80)
    public Double getFees() {
        return this.fees;
    }

    public void setFees(Double fees) {
        this.fees = fees;
    }

    @Element(name="LOAD", order=90)
    public Double getLoad() {
        return this.load;
    }

    public void setLoad(Double load) {
        this.load = load;
    }

    @Element(name="TOTAL", required=true, order=100)
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @ChildAggregate(name="CURRENCY", order=110)
    public OriginalCurrency getCurrencyInfo() {
        return this.currencyInfo;
    }

    public void setCurrencyInfo(OriginalCurrency currency) {
        this.currencyInfo = currency;
        this.originalCurrencyInfo = null;
    }

    @ChildAggregate(order=120)
    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.originalCurrencyInfo;
    }

    public void setOriginalCurrencyInfo(OriginalCurrency originalCurrencyInfo) {
        this.originalCurrencyInfo = originalCurrencyInfo;
        this.currencyInfo = null;
    }

    @Element(name="SUBACCTSEC", order=130)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="SUBACCTFUND", order=140)
    public String getSubAccountFund() {
        return this.subAccountFund;
    }

    public void setSubAccountFund(String subAcctFund) {
        this.subAccountFund = subAcctFund;
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    @Element(name="LOANID", order=150)
    public String getLoanId() {
        return this.loanId;
    }

    public void setLoanId(String loanId) {
        this.loanId = loanId;
    }

    @Element(name="LOANINTEREST", order=160)
    public Double getLoanInterest() {
        return this.loanInterest;
    }

    public void setLoanInterest(Double loanInterest) {
        this.loanInterest = loanInterest;
    }

    @Element(name="LOANPRINCIPAL", order=170)
    public Double getLoanPrincipal() {
        return this.loanPrincipal;
    }

    public void setLoanPrincipal(Double loanPrincipal) {
        this.loanPrincipal = loanPrincipal;
    }

    @Element(name="INV401KSOURCE", order=180)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

