/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.CloseOptionAction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="CLOSUREOPT")
public class CloseOptionTransaction
extends BaseOtherInvestmentTransaction
implements TransactionWithSecurity {
    private SecurityId securityId;
    private String optionAction;
    private Double units;
    private Integer sharesPerContact;
    private String subAccountSecurity;
    private String relatedTransactionId;
    private Double gain;

    public CloseOptionTransaction() {
        super(TransactionType.CLOSE_OPTION);
    }

    @Override
    @ChildAggregate(order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="OPTACTION", required=true, order=30)
    public String getOptionAction() {
        return this.optionAction;
    }

    public void setOptionAction(String optionAction) {
        this.optionAction = optionAction;
    }

    public CloseOptionAction getOptionActionEnum() {
        return CloseOptionAction.fromOfx(this.getOptionAction());
    }

    @Element(name="UNITS", required=true, order=40)
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    @Element(name="SHPERCTRCT", required=true, order=50)
    public Integer getSharesPerContact() {
        return this.sharesPerContact;
    }

    public void setSharesPerContact(Integer sharesPerContact) {
        this.sharesPerContact = sharesPerContact;
    }

    @Element(name="SUBACCTSEC", required=true, order=60)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="RELFITID", order=70)
    public String getRelatedTransactionId() {
        return this.relatedTransactionId;
    }

    public void setRelatedTransactionId(String relatedTransactionId) {
        this.relatedTransactionId = relatedTransactionId;
    }

    @Element(name="GAIN", order=80)
    public Double getGain() {
        return this.gain;
    }

    public void setGain(Double gain) {
        this.gain = gain;
    }
}

