/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.common.Currency;
import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.IncomeType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="INCOME")
public class IncomeTransaction
extends BaseOtherInvestmentTransaction
implements TransactionWithSecurity {
    private SecurityId securityId;
    private String incomeType;
    private Double total;
    private String subAccountSecurity;
    private String subAccountFund;
    private Boolean taxExempt;
    private Double withholding;
    private Currency currencyInfo;
    private OriginalCurrency originalCurrencyInfo;
    private String inv401kSource;

    public IncomeTransaction() {
        super(TransactionType.INCOME);
    }

    @Override
    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="INCOMETYPE", required=true, order=30)
    public String getIncomeType() {
        return this.incomeType;
    }

    public void setIncomeType(String incomeType) {
        this.incomeType = incomeType;
    }

    public IncomeType getIncomeTypeEnum() {
        return IncomeType.fromOfx(this.getIncomeType());
    }

    @Element(name="TOTAL", required=true, order=40)
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @Element(name="SUBACCTSEC", order=50)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAcctSec) {
        this.subAccountSecurity = subAcctSec;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="SUBACCTFUND", order=60)
    public String getSubAccountFund() {
        return this.subAccountFund;
    }

    public void setSubAccountFund(String subAcctFund) {
        this.subAccountFund = subAcctFund;
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    @Element(name="TAXEXEMPT", order=70)
    public Boolean getTaxExempt() {
        return this.taxExempt;
    }

    public void setTaxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    @Element(name="WITHHOLDING", order=80)
    public Double getWithholding() {
        return this.withholding;
    }

    public void setWithholding(Double withholding) {
        this.withholding = withholding;
    }

    @ChildAggregate(name="CURRENCY", order=90)
    public Currency getCurrencyInfo() {
        return this.currencyInfo;
    }

    public void setCurrencyInfo(Currency currencyInfo) {
        this.currencyInfo = currencyInfo;
        this.originalCurrencyInfo = null;
    }

    @ChildAggregate(order=120)
    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.originalCurrencyInfo;
    }

    public void setOriginalCurrencyInfo(OriginalCurrency originalCurrencyInfo) {
        this.originalCurrencyInfo = originalCurrencyInfo;
        this.currencyInfo = null;
    }

    @Element(name="INV401KSOURCE", order=110)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

