/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.IncomeType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="REINVEST")
public class ReinvestIncomeTransaction
extends BaseOtherInvestmentTransaction
implements TransactionWithSecurity {
    private SecurityId securityId;
    private String incomeType;
    private Double total;
    private String subAccountSecurity;
    private Double units;
    private Double unitPrice;
    private Double commission;
    private Double taxes;
    private Double fees;
    private Double load;
    private Boolean taxExempt;
    private String currencyCode;
    private OriginalCurrency originalCurrencyInfo;
    private String inv401kSource;

    public ReinvestIncomeTransaction() {
        super(TransactionType.REINVEST_INCOME);
    }

    @Override
    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="INCOMETYPE", required=true, order=30)
    public String getIncomeType() {
        return this.incomeType;
    }

    public void setIncomeType(String incomeType) {
        this.incomeType = incomeType;
    }

    public IncomeType getIncomeTypeEnum() {
        return IncomeType.fromOfx(this.getIncomeType());
    }

    @Element(name="TOTAL", required=true, order=40)
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @Element(name="SUBACCTSEC", order=50)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="UNITS", required=true, order=60)
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    @Element(name="UNITPRICE", required=true, order=70)
    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Element(name="COMMISSION", order=80)
    public Double getCommission() {
        return this.commission;
    }

    public void setCommission(Double commission) {
        this.commission = commission;
    }

    @Element(name="TAXES", order=90)
    public Double getTaxes() {
        return this.taxes;
    }

    public void setTaxes(Double taxes) {
        this.taxes = taxes;
    }

    @Element(name="FEES", order=100)
    public Double getFees() {
        return this.fees;
    }

    public void setFees(Double fees) {
        this.fees = fees;
    }

    @Element(name="LOAD", order=110)
    public Double getLoad() {
        return this.load;
    }

    public void setLoad(Double load) {
        this.load = load;
    }

    @Element(name="TAXEXEMPT", order=120)
    public Boolean getTaxExempt() {
        return this.taxExempt;
    }

    public void setTaxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    @Element(name="CURRENCY", order=130)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this.originalCurrencyInfo = null;
    }

    @Element(name="ORIGCURRENCY", order=140)
    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.originalCurrencyInfo;
    }

    public void setOriginalCurrencyInfo(OriginalCurrency originalCurrencyInfo) {
        this.originalCurrencyInfo = originalCurrencyInfo;
        this.currencyCode = null;
    }

    @Element(name="INV401KSOURCE", order=150)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

