/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionWithSecurity;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="RETOFCAP")
public class ReturnOfCapitalTransaction
extends BaseOtherInvestmentTransaction
implements TransactionWithSecurity {
    private SecurityId securityId;
    private Double total;
    private String subAccountSecurity;
    private String subAccountFund;
    private String currencyCode;
    private OriginalCurrency originalCurrencyInfo;
    private String inv401kSource;

    public ReturnOfCapitalTransaction() {
        super(TransactionType.RETURN_OF_CAPITAL);
    }

    @Override
    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="TOTAL", required=true, order=40)
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @Element(name="SUBACCTSEC", order=50)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="SUBACCTFUND", order=140)
    public String getSubAccountFund() {
        return this.subAccountFund;
    }

    public void setSubAccountFund(String subAccountFund) {
        this.subAccountFund = subAccountFund;
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    @Element(name="CURRENCY", order=110)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this.originalCurrencyInfo = null;
    }

    @Element(name="ORIGCURRENCY", order=120)
    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.originalCurrencyInfo;
    }

    public void setOriginalCurrencyInfo(OriginalCurrency originalCurrencyInfo) {
        this.originalCurrencyInfo = originalCurrencyInfo;
        this.currencyCode = null;
    }

    @Element(name="INV401KSOURCE", order=180)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

