/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.OriginalCurrency;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="SPLIT")
public class SplitTransaction
extends BaseOtherInvestmentTransaction {
    private SecurityId securityId;
    private String subAccountSecurity;
    private Double oldUnits;
    private Double newUnits;
    private Double numerator;
    private Double denominator;
    private String currencyCode;
    private OriginalCurrency originalCurrencyInfo;
    private Double cashForFractionalUnits;
    private String subAccountFund;
    private String inv401kSource;

    public SplitTransaction() {
        super(TransactionType.SPLIT);
    }

    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="SUBACCTSEC", order=30)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="OLDUNITS", order=40)
    public Double getOldUnits() {
        return this.oldUnits;
    }

    public void setOldUnits(Double oldUnits) {
        this.oldUnits = oldUnits;
    }

    @Element(name="NEWUNITS", order=50)
    public Double getNewUnits() {
        return this.newUnits;
    }

    public void setNewUnits(Double newUnits) {
        this.newUnits = newUnits;
    }

    @Element(name="NUMERATOR", order=60)
    public Double getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Double numerator) {
        this.numerator = numerator;
    }

    @Element(name="DENOMINATOR", order=70)
    public Double getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Double denominator) {
        this.denominator = denominator;
    }

    @Element(name="CURRENCY", order=80)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this.originalCurrencyInfo = null;
    }

    @Element(name="ORIGCURRENCY", order=90)
    public OriginalCurrency getOriginalCurrencyInfo() {
        return this.originalCurrencyInfo;
    }

    public void setOriginalCurrencyInfo(OriginalCurrency originalCurrencyInfo) {
        this.originalCurrencyInfo = originalCurrencyInfo;
        this.currencyCode = null;
    }

    @Element(name="FRACCASH", order=100)
    public Double getCashForFractionalUnits() {
        return this.cashForFractionalUnits;
    }

    public void setCashForFractionalUnits(Double cashForFractionalUnits) {
        this.cashForFractionalUnits = cashForFractionalUnits;
    }

    @Element(name="SUBACCTFUND", order=110)
    public String getSubAccountFund() {
        return this.subAccountFund;
    }

    public void setSubAccountFund(String subAccountFund) {
        this.subAccountFund = subAccountFund;
    }

    public SubAccountType getSubAccountFundEnum() {
        return SubAccountType.fromOfx(this.getSubAccountFund());
    }

    @Element(name="INV401KSOURCE", order=120)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

