/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.investment.transactions;

import com.webcohesion.ofx4j.domain.data.investment.accounts.SubAccountType;
import com.webcohesion.ofx4j.domain.data.investment.positions.Inv401KSource;
import com.webcohesion.ofx4j.domain.data.investment.positions.PositionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.BaseOtherInvestmentTransaction;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransactionType;
import com.webcohesion.ofx4j.domain.data.investment.transactions.TransferAction;
import com.webcohesion.ofx4j.domain.data.seclist.SecurityId;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.util.Date;

@Aggregate(value="TRANSFER")
public class TransferInvestmentTransaction
extends BaseOtherInvestmentTransaction {
    private SecurityId securityId;
    private String subAccountSecurity;
    private Double units;
    private String transferAction;
    private String positionType;
    private Double averageCostBasis;
    private Double unitPrice;
    private Date purchaseDate;
    private String inv401kSource;

    public TransferInvestmentTransaction() {
        super(TransactionType.TRANSFER);
    }

    @ChildAggregate(required=true, order=20)
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(SecurityId securityId) {
        this.securityId = securityId;
    }

    @Element(name="SUBACCTSEC", order=30)
    public String getSubAccountSecurity() {
        return this.subAccountSecurity;
    }

    public void setSubAccountSecurity(String subAccountSecurity) {
        this.subAccountSecurity = subAccountSecurity;
    }

    public SubAccountType getSubAccountSecurityEnum() {
        return SubAccountType.fromOfx(this.getSubAccountSecurity());
    }

    @Element(name="UNITS", required=true, order=40)
    public Double getUnits() {
        return this.units;
    }

    public void setUnits(Double units) {
        this.units = units;
    }

    @Element(name="TFERACTION", required=true, order=50)
    public String getTransferAction() {
        return this.transferAction;
    }

    public void setTransferAction(String transferAction) {
        this.transferAction = transferAction;
    }

    public TransferAction getTransferActionEnum() {
        return TransferAction.fromOfx(this.getTransferAction());
    }

    @Element(name="POSTYPE", required=true, order=60)
    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public PositionType getPositionTypeEnum() {
        return PositionType.fromOfx(this.getPositionType());
    }

    @Element(name="AVGCOSTBASIS", order=70)
    public Double getAverageCostBasis() {
        return this.averageCostBasis;
    }

    public void setAverageCostBasis(Double averageCostBasis) {
        this.averageCostBasis = averageCostBasis;
    }

    @Element(name="UNITPRICE", required=true, order=80)
    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Element(name="DTPURCHASE", order=90)
    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    @Element(name="INV401KSOURCE", order=100)
    public String get401kSource() {
        return this.inv401kSource;
    }

    public void set401kSource(String inv401kSource) {
        this.inv401kSource = inv401kSource;
    }

    public Inv401KSource get401kSourceEnum() {
        return Inv401KSource.fromOfx(this.get401kSource());
    }
}

