/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.profile;

import com.webcohesion.ofx4j.client.FinancialInstitutionProfile;
import com.webcohesion.ofx4j.domain.data.MessageSetProfile;
import com.webcohesion.ofx4j.domain.data.MessageSetType;
import com.webcohesion.ofx4j.domain.data.ResponseMessage;
import com.webcohesion.ofx4j.domain.data.SignonProfile;
import com.webcohesion.ofx4j.domain.data.profile.AbstractMessageSetInfo;
import com.webcohesion.ofx4j.domain.data.profile.MessageSetInfoList;
import com.webcohesion.ofx4j.domain.data.profile.SignonInfo;
import com.webcohesion.ofx4j.domain.data.profile.SignonInfoList;
import com.webcohesion.ofx4j.domain.data.profile.VersionSpecificMessageSetInfo;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

@Aggregate(value="PROFRS")
public class ProfileResponse
extends ResponseMessage
implements FinancialInstitutionProfile {
    private MessageSetInfoList messageSetList;
    private SignonInfoList signonInfoList;
    private Date timestamp;
    private String financialInstitutionName;
    private String address1;
    private String address2;
    private String address3;
    private String city;
    private String state;
    private String zip;
    private String country;
    private String customerServicePhone;
    private String technicalSupportPhone;
    private String fax;
    private String siteURL;
    private String email;

    @ChildAggregate(order=0)
    public MessageSetInfoList getMessageSetList() {
        return this.messageSetList;
    }

    public void setMessageSetList(MessageSetInfoList messageSetList) {
        this.messageSetList = messageSetList;
    }

    @ChildAggregate(order=10)
    public SignonInfoList getSignonInfoList() {
        return this.signonInfoList;
    }

    public void setSignonInfoList(SignonInfoList signonInfoList) {
        this.signonInfoList = signonInfoList;
    }

    @Override
    public String getResponseMessageName() {
        return "profile";
    }

    @Override
    public Date getLastUpdated() {
        return this.getTimestamp();
    }

    @Element(name="DTPROFUP", order=20)
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    @Element(name="FINAME", order=30)
    public String getFinancialInstitutionName() {
        return this.financialInstitutionName;
    }

    public void setFinancialInstitutionName(String financialInstitutionName) {
        this.financialInstitutionName = financialInstitutionName;
    }

    @Override
    @Element(name="ADDR1", required=true, order=40)
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    @Override
    @Element(name="ADDR2", order=50)
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Override
    @Element(name="ADDR3", order=60)
    public String getAddress3() {
        return this.address3;
    }

    public void setAddress3(String address3) {
        this.address3 = address3;
    }

    @Override
    @Element(name="CITY", required=true, order=70)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Override
    @Element(name="STATE", required=true, order=80)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    @Element(name="POSTALCODE", required=true, order=90)
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @Override
    @Element(name="COUNTRY", required=true, order=100)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    @Element(name="CSPHONE", order=110)
    public String getCustomerServicePhone() {
        return this.customerServicePhone;
    }

    public void setCustomerServicePhone(String customerServicePhone) {
        this.customerServicePhone = customerServicePhone;
    }

    @Override
    @Element(name="TSPHONE", order=120)
    public String getTechnicalSupportPhone() {
        return this.technicalSupportPhone;
    }

    public void setTechnicalSupportPhone(String technicalSupportPhone) {
        this.technicalSupportPhone = technicalSupportPhone;
    }

    @Override
    @Element(name="FAXPHONE", order=130)
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @Override
    @Element(name="URL", order=140)
    public String getSiteURL() {
        return this.siteURL;
    }

    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    @Override
    @Element(name="EMAIL", order=150)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public MessageSetProfile getMessageSetProfile(MessageSetType type) {
        Collection<MessageSetProfile> profiles = this.getProfiles(type);
        if (profiles.size() > 1) {
            throw new IllegalStateException("More than one profile of type " + (Object)((Object)type));
        }
        if (profiles.isEmpty()) {
            return null;
        }
        return profiles.iterator().next();
    }

    protected Collection<MessageSetProfile> getProfiles(MessageSetType type) {
        ArrayList<MessageSetProfile> profiles = new ArrayList<MessageSetProfile>();
        if (this.getMessageSetList() != null && this.getMessageSetList().getInformationList() != null) {
            for (AbstractMessageSetInfo info : this.getMessageSetList().getInformationList()) {
                if (info.getVersionSpecificInformationList() == null) continue;
                for (VersionSpecificMessageSetInfo versionSpecificInfo : info.getVersionSpecificInformationList()) {
                    if (versionSpecificInfo.getMessageSetType() != type) continue;
                    profiles.add(versionSpecificInfo);
                }
            }
        }
        return profiles;
    }

    @Override
    public MessageSetProfile getMessageSetProfile(MessageSetType type, String version) {
        for (MessageSetProfile profile : this.getProfiles(type)) {
            if (!(version == null ? profile.getVersion() == null : version.equals(profile.getVersion()))) continue;
            return profile;
        }
        return null;
    }

    @Override
    public SignonProfile getSignonProfile(MessageSetProfile messageSet) {
        if (this.getSignonInfoList() != null && this.getSignonInfoList().getInfoList() != null) {
            for (SignonInfo signonInfo : this.getSignonInfoList().getInfoList()) {
                if (!(messageSet.getRealm() == null ? signonInfo.getRealm() == null : messageSet.getRealm().equals(signonInfo.getRealm()))) continue;
                return signonInfo;
            }
        }
        return null;
    }
}

