/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.domain.data.signup;

import com.webcohesion.ofx4j.domain.data.banking.BankAccountInfo;
import com.webcohesion.ofx4j.domain.data.common.AccountInfo;
import com.webcohesion.ofx4j.domain.data.creditcard.CreditCardAccountInfo;
import com.webcohesion.ofx4j.domain.data.investment.accounts.InvestmentAccountInfo;
import com.webcohesion.ofx4j.domain.data.signup.AccountHolderInfo;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;

@Aggregate(value="ACCTINFO")
public class AccountProfile {
    private String description;
    private String phone;
    private BankAccountInfo bankSpecifics;
    private CreditCardAccountInfo creditCardSpecifics;
    private InvestmentAccountInfo investSpecifics;
    private AccountHolderInfo accountHolderInfo;

    @Element(name="DESC", order=0)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Element(name="PHONE", order=10)
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public AccountInfo getSpecifics() {
        if (this.getBankSpecifics() != null && this.getCreditCardSpecifics() != null) {
            throw new IllegalStateException("Only one account specifics aggregate can be set at a time.");
        }
        if (this.getBankSpecifics() != null) {
            return this.getBankSpecifics();
        }
        if (this.getInvestmentSpecifics() != null) {
            return this.getInvestmentSpecifics();
        }
        return this.getCreditCardSpecifics();
    }

    public void setSpecifics(AccountInfo specifics) {
        if (specifics instanceof BankAccountInfo) {
            this.setBankSpecifics((BankAccountInfo)specifics);
        } else if (specifics instanceof CreditCardAccountInfo) {
            this.setCreditCardSpecifics((CreditCardAccountInfo)specifics);
        } else if (specifics instanceof InvestmentAccountInfo) {
            this.setInvestmentSpecifics((InvestmentAccountInfo)specifics);
        } else {
            throw new IllegalArgumentException("Unknown specifics type: " + specifics);
        }
    }

    @ChildAggregate(order=20)
    public BankAccountInfo getBankSpecifics() {
        return this.bankSpecifics;
    }

    public void setBankSpecifics(BankAccountInfo bankSpecifics) {
        this.creditCardSpecifics = null;
        this.investSpecifics = null;
        this.bankSpecifics = bankSpecifics;
    }

    @ChildAggregate(order=30)
    public CreditCardAccountInfo getCreditCardSpecifics() {
        return this.creditCardSpecifics;
    }

    public void setCreditCardSpecifics(CreditCardAccountInfo creditCardSpecifics) {
        this.bankSpecifics = null;
        this.investSpecifics = null;
        this.creditCardSpecifics = creditCardSpecifics;
    }

    @ChildAggregate(order=40)
    public InvestmentAccountInfo getInvestmentSpecifics() {
        return this.investSpecifics;
    }

    public void setInvestmentSpecifics(InvestmentAccountInfo investSpecifics) {
        this.bankSpecifics = null;
        this.creditCardSpecifics = null;
        this.investSpecifics = investSpecifics;
    }

    @ChildAggregate(order=50)
    public AccountHolderInfo getAccountHolderInfo() {
        return this.accountHolderInfo;
    }

    public void setAccountHolderInfo(AccountHolderInfo accountHolderInfo) {
        this.accountHolderInfo = accountHolderInfo;
    }
}

