/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateInfo;
import com.webcohesion.ofx4j.io.AggregateIntrospector;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AggregateAttribute
implements Comparable<AggregateAttribute> {
    private final Method readMethod;
    private final Method writeMethod;
    private final Class attributeType;
    private final Class collectionEntryType;
    private final String name;
    private final int order;
    private final boolean required;
    private final Type type;
    private final String toString;
    private final boolean collection;

    AggregateAttribute(PropertyDescriptor property, Element elementInfo) {
        this.readMethod = property.getReadMethod();
        this.writeMethod = property.getWriteMethod();
        if (this.readMethod == null) {
            throw new IllegalStateException(String.format("Illegal property '%s' for aggregate %s: no read method.", property.getName(), property.getWriteMethod().getDeclaringClass().getName()));
        }
        if (this.writeMethod == null) {
            throw new IllegalStateException(String.format("Illegal property '%s' for aggregate %s: no write method.", property.getName(), property.getReadMethod().getDeclaringClass().getName()));
        }
        this.attributeType = this.readMethod.getReturnType();
        this.collectionEntryType = null;
        this.name = elementInfo.name();
        this.order = elementInfo.order();
        this.required = elementInfo.required();
        this.type = Type.ELEMENT;
        this.toString = String.format("%s '%s' (property '%s' of aggregate %s)", this.getType().toString().toLowerCase().replace('_', ' '), this.getName(), property.getName(), property.getReadMethod().getDeclaringClass().getName());
        this.collection = false;
    }

    AggregateAttribute(PropertyDescriptor property, ChildAggregate childAggregate) {
        this.readMethod = property.getReadMethod();
        this.writeMethod = property.getWriteMethod();
        if (this.readMethod == null) {
            throw new IllegalStateException(String.format("Illegal property '%s' for aggregate %s: no read method.", property.getName(), property.getWriteMethod().getDeclaringClass().getName()));
        }
        if (this.writeMethod == null) {
            throw new IllegalStateException(String.format("Illegal property '%s' for aggregate %s: no write method.", property.getName(), property.getReadMethod().getDeclaringClass().getName()));
        }
        this.readMethod.getGenericReturnType();
        this.attributeType = this.readMethod.getReturnType();
        this.collection = Collection.class.isAssignableFrom(this.attributeType);
        if (this.collection) {
            this.name = null;
            this.collectionEntryType = this.getGenericCollectionType(this.readMethod.getGenericReturnType());
        } else if ("##not_specified##".equals(childAggregate.name())) {
            AggregateInfo aggregateInfo = AggregateIntrospector.getAggregateInfo(this.attributeType);
            if (aggregateInfo == null) {
                throw new IllegalStateException(String.format("Illegal child aggregate type %s (property %s of aggregate %s): no aggregate information available.", this.attributeType.getName(), property.getName(), property.getReadMethod().getDeclaringClass().getName()));
            }
            this.name = aggregateInfo.getName();
            if ("##not_specified##".equals(this.name)) {
                throw new IllegalStateException(String.format("Illegal child aggregate type %s (property %s of aggregate %s): a child aggregate name must be specified.", this.attributeType.getName(), property.getName(), property.getReadMethod().getDeclaringClass().getName()));
            }
            this.collectionEntryType = null;
        } else {
            this.name = childAggregate.name();
            this.collectionEntryType = null;
        }
        this.order = childAggregate.order();
        this.required = childAggregate.required();
        this.type = Type.CHILD_AGGREGATE;
        this.toString = String.format("%s '%s' (property '%s' of aggregate %s)", this.getType().toString().toLowerCase().replace('_', ' '), this.getName(), property.getName(), property.getReadMethod().getDeclaringClass().getName());
    }

    private Class getGenericCollectionType(java.lang.reflect.Type collectionType) {
        Method addMethod;
        if (!(collectionType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedCollectionType = (ParameterizedType)collectionType;
        Class collectionClass = (Class)parameterizedCollectionType.getRawType();
        try {
            addMethod = collectionClass.getMethod("add", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Collection doesn't implement add?");
        }
        java.lang.reflect.Type[] actualTypeArgs = parameterizedCollectionType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = collectionClass.getTypeParameters();
        TypeVariable addParamType = (TypeVariable)addMethod.getGenericParameterTypes()[0];
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable typeVariable = typeVariables[i];
            if (!typeVariable.getName().equals(addParamType.getName())) continue;
            return (Class)actualTypeArgs[i];
        }
        return null;
    }

    public Object get(Object instance) throws Exception {
        return this.readMethod.invoke(instance, new Object[0]);
    }

    public void set(Object value, Object instance) throws Exception {
        if (Collection.class.isAssignableFrom(this.getAttributeType())) {
            Collection collection = (Collection)this.get(instance);
            if (collection == null) {
                collection = this.newCollectionInstance();
            }
            collection.add(value);
            value = collection;
        } else if (BigDecimal.class.isAssignableFrom(this.getAttributeType()) && value != null) {
            value = new BigDecimal(value.toString().replace(",", "."));
        }
        this.writeMethod.invoke(instance, value);
    }

    protected Collection newCollectionInstance() {
        if (!this.getAttributeType().isInterface()) {
            try {
                return (Collection)this.getAttributeType().newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (SortedSet.class.isAssignableFrom(this.getAttributeType())) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(this.getAttributeType())) {
            return new HashSet();
        }
        return new ArrayList();
    }

    public Class getAttributeType() {
        return this.attributeType;
    }

    public Class getCollectionEntryType() {
        return this.collectionEntryType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getOrder() {
        return this.order;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(AggregateAttribute other) {
        return this.order - other.order;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public String toString() {
        return this.toString;
    }

    public static enum Type {
        CHILD_AGGREGATE,
        ELEMENT;

    }
}

