/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateAttribute;
import com.webcohesion.ofx4j.meta.Aggregate;
import com.webcohesion.ofx4j.meta.ChildAggregate;
import com.webcohesion.ofx4j.meta.Element;
import com.webcohesion.ofx4j.meta.Header;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AggregateInfo {
    private final String name;
    private final SortedSet<AggregateAttribute> attributes;
    private final Map<String, PropertyDescriptor> headers;

    AggregateInfo(Class<?> clazz) {
        PropertyDescriptor[] pds;
        Aggregate aggregateInfo = clazz.getAnnotation(Aggregate.class);
        if (aggregateInfo == null) {
            throw new IllegalArgumentException(clazz.getName() + " isn't an aggregate.");
        }
        this.name = aggregateInfo.value();
        TreeSet<AggregateAttribute> attributes = new TreeSet<AggregateAttribute>();
        TreeMap<String, PropertyDescriptor> headers = new TreeMap<String, PropertyDescriptor>();
        try {
            pds = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        for (PropertyDescriptor pd : pds) {
            AggregateAttribute attribute;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            ChildAggregate childAggregateInfo = pd.getReadMethod().getAnnotation(ChildAggregate.class);
            Element elementInfo = pd.getReadMethod().getAnnotation(Element.class);
            if (childAggregateInfo != null && elementInfo != null) {
                throw new IllegalStateException(String.format("Illegal annotations for property '%s' on aggregate %s: contains both a @ChildAggregate and @Element annotation.", pd.getName(), clazz.getName()));
            }
            if (childAggregateInfo != null) {
                attribute = new AggregateAttribute(pd, childAggregateInfo);
                if (!attributes.add(attribute)) {
                    throw new IllegalStateException(String.format("Unable to add child aggregate property '%s' to meta information for aggregate %s.  Order duplicates another aggregate property?", pd.getName(), clazz.getName()));
                }
            } else if (elementInfo != null && !attributes.add(attribute = new AggregateAttribute(pd, elementInfo))) {
                throw new IllegalStateException(String.format("Unable to add element property '%s' to meta information for aggregate %s.  Order duplicates another aggregate property?", pd.getName(), clazz.getName()));
            }
            if (!pd.getReadMethod().isAnnotationPresent(Header.class)) continue;
            headers.put(pd.getReadMethod().getAnnotation(Header.class).name(), pd);
        }
        this.headers = Collections.unmodifiableMap(headers);
        this.attributes = Collections.unmodifiableSortedSet(attributes);
    }

    public String getName() {
        return this.name;
    }

    public SortedSet<AggregateAttribute> getAttributes() {
        return this.attributes;
    }

    public AggregateAttribute getAttribute(String name, int orderHint) {
        return this.getAttribute(name, orderHint, null);
    }

    public AggregateAttribute getAttribute(String name, int orderHint, Class assignableTo) {
        ArrayList<AggregateAttribute> candidates = new ArrayList<AggregateAttribute>();
        AggregateAttribute collectionBucket = null;
        for (AggregateAttribute attribute : this.attributes) {
            Class entryType;
            if (name.equals(attribute.getName())) {
                candidates.add(attribute);
                continue;
            }
            if (!attribute.isCollection() || assignableTo != null && (entryType = attribute.getCollectionEntryType()) != null && !entryType.isAssignableFrom(assignableTo) || collectionBucket != null && collectionBucket.getOrder() >= orderHint) continue;
            collectionBucket = attribute;
        }
        if (!candidates.isEmpty()) {
            if (candidates.size() == 1) {
                return (AggregateAttribute)candidates.get(0);
            }
            for (AggregateAttribute candidate : candidates) {
                if (candidate.getOrder() < orderHint) continue;
                return candidate;
            }
        }
        return collectionBucket;
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public Map<String, Object> getHeaders(Object instance) {
        TreeMap<String, Object> headers = new TreeMap<String, Object>();
        for (PropertyDescriptor header : this.headers.values()) {
            Object headerValue;
            try {
                headerValue = header.getReadMethod().invoke(instance, new Object[0]);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            headers.put(header.getReadMethod().getAnnotation(Header.class).name(), headerValue);
        }
        return headers;
    }

    public Class getHeaderType(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).getReadMethod().getReturnType() : null;
    }

    public void setHeader(Object instance, String name, Object value) {
        if (this.headers.containsKey(name)) {
            try {
                this.headers.get(name).getWriteMethod().invoke(instance, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

