/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateInfo;
import com.webcohesion.ofx4j.meta.Aggregate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AggregateIntrospector {
    private static final Log LOG = LogFactory.getLog(AggregateIntrospector.class);
    static final Map<Class, AggregateInfo> INFO_MAP = new HashMap<Class, AggregateInfo>();
    static final Map<String, Class> AGGREGATE_CLASSES_BY_NAME = Collections.synchronizedMap(new TreeMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AggregateInfo getAggregateInfo(Class clazz) {
        AggregateInfo info = null;
        if (clazz.isAnnotationPresent(Aggregate.class)) {
            Map<Class, AggregateInfo> map = INFO_MAP;
            synchronized (map) {
                info = INFO_MAP.get(clazz);
                if (info == null) {
                    info = new AggregateInfo(clazz);
                    INFO_MAP.put(clazz, info);
                }
            }
        }
        return info;
    }

    public static Class findAggregateByName(String aggregateName) {
        return AGGREGATE_CLASSES_BY_NAME.get(aggregateName);
    }

    static {
        Reflections reflections = new Reflections("com.webcohesion.ofx4j", new Scanner[0]);
        Set aggregateClasses = reflections.getTypesAnnotatedWith(Aggregate.class);
        for (Class clazz : aggregateClasses) {
            AggregateInfo info = AggregateIntrospector.getAggregateInfo(clazz);
            AGGREGATE_CLASSES_BY_NAME.put(info.getName(), clazz);
        }
    }
}

