/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateAttribute;
import com.webcohesion.ofx4j.io.AggregateInfo;
import com.webcohesion.ofx4j.io.AggregateIntrospector;
import com.webcohesion.ofx4j.io.DefaultStringConversion;
import com.webcohesion.ofx4j.io.OFXWriter;
import com.webcohesion.ofx4j.io.RequiredAttributeException;
import com.webcohesion.ofx4j.io.StringConversion;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregateMarshaller {
    private static final Log LOG = LogFactory.getLog(AggregateMarshaller.class);
    private StringConversion conversion = new DefaultStringConversion();

    public void marshal(Object aggregate, OFXWriter writer) throws IOException {
        AggregateInfo aggregateInfo = AggregateIntrospector.getAggregateInfo(aggregate.getClass());
        if (aggregateInfo == null) {
            throw new IllegalArgumentException(String.format("Unable to marshal object of type %s (no aggregate metadata found).", aggregate.getClass().getName()));
        }
        if (aggregateInfo.hasHeaders()) {
            Map<String, Object> headerValues = aggregateInfo.getHeaders(aggregate);
            TreeMap<String, String> convertedValues = new TreeMap<String, String>();
            for (String header : headerValues.keySet()) {
                convertedValues.put(header, this.getConversion().toString(headerValues.get(header)));
            }
            writer.writeHeaders(convertedValues);
        }
        writer.writeStartAggregate(aggregateInfo.getName());
        SortedSet<AggregateAttribute> AggregateAttributes = aggregateInfo.getAttributes();
        this.writeAggregateAttributes(aggregate, writer, AggregateAttributes);
        writer.writeEndAggregate(aggregateInfo.getName());
    }

    protected void writeAggregateAttributes(Object aggregate, OFXWriter writer, SortedSet<AggregateAttribute> aggregateAttributes) throws IOException {
        block6: for (AggregateAttribute aggregateAttribute : aggregateAttributes) {
            Object childValue = null;
            try {
                childValue = aggregateAttribute.get(aggregate);
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Unable to get %s", aggregateAttribute.toString()), (Throwable)e);
            }
            if (childValue != null) {
                switch (aggregateAttribute.getType()) {
                    case CHILD_AGGREGATE: {
                        List<Object> childValues = childValue instanceof Collection ? (List<Object>)childValue : Arrays.asList(childValue);
                        for (Object e : childValues) {
                            AggregateInfo aggregateInfo = AggregateIntrospector.getAggregateInfo(e.getClass());
                            if (aggregateInfo == null) {
                                throw new IllegalArgumentException(String.format("Unable to marshal object of type %s (no aggregate metadata found).", e.getClass().getName()));
                            }
                            String attributeName = aggregateAttribute.getName();
                            if (aggregateAttribute.isCollection()) {
                                attributeName = aggregateInfo.getName();
                            }
                            writer.writeStartAggregate(attributeName);
                            this.writeAggregateAttributes(e, writer, aggregateInfo.getAttributes());
                            writer.writeEndAggregate(attributeName);
                        }
                        continue block6;
                    }
                    case ELEMENT: {
                        if (childValue instanceof Collection) {
                            for (Object e : (Collection)childValue) {
                                this.writeElement(e, writer, aggregateAttribute);
                            }
                            continue block6;
                        }
                        this.writeElement(childValue, writer, aggregateAttribute);
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown aggregate attribute type: " + (Object)((Object)aggregateAttribute.getType()));
                    }
                }
            }
            if (!aggregateAttribute.isRequired()) continue;
            throw new RequiredAttributeException("Required " + aggregateAttribute.toString() + " is null or empty.");
        }
    }

    private void writeElement(Object childValue, OFXWriter writer, AggregateAttribute aggregateAttribute) throws IOException {
        String value = this.getConversion().toString(childValue);
        if (value != null && !"".equals(value.trim())) {
            writer.writeElement(aggregateAttribute.getName(), value);
        }
    }

    public StringConversion getConversion() {
        return this.conversion;
    }

    public void setConversion(StringConversion conversion) {
        this.conversion = conversion;
    }
}

