/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateAttribute;
import com.webcohesion.ofx4j.io.AggregateInfo;
import com.webcohesion.ofx4j.io.AggregateIntrospector;
import com.webcohesion.ofx4j.io.OFXHandler;
import com.webcohesion.ofx4j.io.OFXSyntaxException;
import com.webcohesion.ofx4j.io.StringConversion;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregateStackContentHandler<A>
implements OFXHandler {
    private static final Log LOG = LogFactory.getLog(AggregateStackContentHandler.class);
    private final Stack<AggregateInfoHolder> stack = new Stack();
    private final StringConversion conversion;
    private boolean parsingRoot = false;

    public AggregateStackContentHandler(A root, StringConversion conversion) {
        AggregateInfo aggregateInfo = AggregateIntrospector.getAggregateInfo(root.getClass());
        if (aggregateInfo == null) {
            throw new IllegalArgumentException(String.format("Unable to marshal object of type %s (no aggregate metadata found).", root.getClass().getName()));
        }
        this.stack.push(new AggregateInfoHolder(root, aggregateInfo, aggregateInfo.getName()));
        this.conversion = conversion;
    }

    @Override
    public void onHeader(String name, String value) throws OFXSyntaxException {
        Class headerType = this.stack.peek().info.getHeaderType(name);
        if (headerType != null) {
            this.stack.peek().info.setHeader(this.stack.peek().aggregate, name, this.conversion.fromString(headerType, value));
        }
    }

    @Override
    public void onElement(String name, String value) throws OFXSyntaxException {
        if (!this.stack.peek().isBeingSkipped()) {
            AggregateAttribute attribute = this.stack.peek().info.getAttribute(name, this.stack.peek().currentAttributeIndex);
            if (attribute != null && attribute.getType() == AggregateAttribute.Type.ELEMENT) {
                try {
                    attribute.set(this.conversion.fromString(attribute.getAttributeType(), value), this.stack.peek().aggregate);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to set " + attribute.toString()), (Throwable)e);
                }
                this.stack.peek().currentAttributeIndex = attribute.getOrder();
            } else {
                if (name.equals(this.stack.peek().info.getName().toString()) && value != null) {
                    throw new IllegalStateException(String.format("Element %s is not supported on aggregate %s (class %s) at index %s.", name, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName(), this.stack.peek().currentAttributeIndex));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)String.format("Element %s is not supported on aggregate %s (class %s) at index %s.", name, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName(), this.stack.peek().currentAttributeIndex));
                }
            }
        }
    }

    @Override
    public void startAggregate(String aggregateName) throws OFXSyntaxException {
        if (this.stack.peek().isBeingSkipped()) {
            this.stack.push(new AggregateInfoHolder(aggregateName));
        } else if (!this.parsingRoot) {
            if (!aggregateName.equals(this.stack.peek().info.getName())) {
                throw new IllegalStateException("Unexpected root element: " + aggregateName);
            }
            this.parsingRoot = true;
        } else {
            AggregateInfoHolder infoHolder;
            AggregateAttribute attribute = this.stack.peek().info.getAttribute(aggregateName, this.stack.peek().currentAttributeIndex);
            if (attribute != null) {
                if (attribute.getType() == AggregateAttribute.Type.CHILD_AGGREGATE) {
                    Class aggregateType = attribute.isCollection() ? AggregateIntrospector.findAggregateByName(aggregateName) : attribute.getAttributeType();
                    if (aggregateType != null) {
                        Object aggregate;
                        AggregateInfo aggregateInfo = AggregateIntrospector.getAggregateInfo(aggregateType);
                        if (aggregateInfo == null) {
                            throw new IllegalStateException("Unable to locate aggregate info for type " + aggregateType.getName());
                        }
                        try {
                            aggregate = aggregateType.newInstance();
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                        infoHolder = new AggregateInfoHolder(aggregate, aggregateInfo, aggregateName);
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)String.format("Child aggregate %s is not supported on aggregate %s (class %s): name not assigned a type.", aggregateName, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName()));
                        }
                        infoHolder = new AggregateInfoHolder(aggregateName);
                    }
                    this.stack.peek().currentAttributeIndex = attribute.getOrder();
                } else {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)String.format("Child aggregate %s is not supported on aggregate %s (class %s): no child aggregate, but there does exist an element by that name.", aggregateName, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName()));
                    }
                    infoHolder = new AggregateInfoHolder(aggregateName);
                }
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)String.format("Child aggregate %s is not supported on aggregate %s (class %s): no attributes found by that name after index %s.", aggregateName, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName(), this.stack.peek().currentAttributeIndex));
                }
                infoHolder = new AggregateInfoHolder(aggregateName);
            }
            this.stack.push(infoHolder);
        }
    }

    @Override
    public void endAggregate(String aggregateName) throws OFXSyntaxException {
        AggregateInfoHolder infoHolder = this.stack.pop();
        if (!aggregateName.equals(infoHolder.aggregateName)) {
            throw new OFXSyntaxException("Unexpected end aggregate " + aggregateName + ". (Perhaps " + infoHolder.aggregateName + " is an element with an empty value, making it impossible to parse.)");
        }
        if (!this.stack.isEmpty() && !infoHolder.isSkipping(aggregateName)) {
            AggregateAttribute attribute = this.stack.peek().info.getAttribute(aggregateName, this.stack.peek().currentAttributeIndex, infoHolder.aggregate.getClass());
            try {
                if (attribute != null) {
                    attribute.set(infoHolder.aggregate, this.stack.peek().aggregate);
                } else if (LOG.isInfoEnabled()) {
                    LOG.info((Object)String.format("Child aggregate %s is not supported on aggregate %s (class %s): no attributes found by that name after index %s.", aggregateName, this.stack.peek().info.getName(), this.stack.peek().aggregate.getClass().getName(), this.stack.peek().currentAttributeIndex));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to set " + attribute.toString()), (Throwable)e);
            }
            this.stack.peek().currentAttributeIndex = attribute.getOrder();
        }
    }

    private class AggregateInfoHolder {
        private final Object aggregate;
        private final AggregateInfo info;
        private final String aggregateName;
        private int currentAttributeIndex = 0;

        private AggregateInfoHolder(String ignoredAggregateName) {
            this.aggregate = null;
            this.info = null;
            this.aggregateName = ignoredAggregateName;
        }

        private AggregateInfoHolder(Object aggregate, AggregateInfo info, String aggregateName) {
            this.aggregateName = aggregateName;
            this.aggregate = aggregate;
            this.info = info;
        }

        public boolean isBeingSkipped() {
            return this.aggregate == null || this.info == null;
        }

        public boolean isSkipping(String aggregateName) {
            return this.isBeingSkipped() && aggregateName.equals(this.aggregateName);
        }
    }
}

