/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.AggregateStackContentHandler;
import com.webcohesion.ofx4j.io.DefaultStringConversion;
import com.webcohesion.ofx4j.io.OFXParseException;
import com.webcohesion.ofx4j.io.OFXReader;
import com.webcohesion.ofx4j.io.StringConversion;
import com.webcohesion.ofx4j.io.nanoxml.NanoXMLOFXReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class AggregateUnmarshaller<A> {
    private final Class<A> clazz;
    private StringConversion conversion = new DefaultStringConversion();

    public AggregateUnmarshaller(Class<A> clazz) {
        this.clazz = clazz;
    }

    public AggregateUnmarshaller(Class<A> clazz, String gmt) {
        this(clazz);
        this.conversion = new DefaultStringConversion(gmt);
    }

    public A unmarshal(InputStream stream) throws IOException, OFXParseException {
        try {
            A aggregate = this.clazz.newInstance();
            OFXReader reader = this.newReader();
            reader.setContentHandler(new AggregateStackContentHandler<A>(aggregate, this.getConversion()));
            reader.parse(stream);
            return aggregate;
        }
        catch (OFXParseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public A unmarshal(Reader reader) throws OFXParseException {
        try {
            A aggregate = this.clazz.newInstance();
            OFXReader ofxReader = this.newReader();
            ofxReader.setContentHandler(new AggregateStackContentHandler<A>(aggregate, this.getConversion()));
            ofxReader.parse(reader);
            return aggregate;
        }
        catch (OFXParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected OFXReader newReader() {
        return new NanoXMLOFXReader();
    }

    public StringConversion getConversion() {
        return this.conversion;
    }

    public void setConversion(StringConversion conversion) {
        this.conversion = conversion;
    }
}

