/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.DefaultHandler;
import com.webcohesion.ofx4j.io.OFXHandler;
import com.webcohesion.ofx4j.io.OFXParseException;
import com.webcohesion.ofx4j.io.OFXReader;
import com.webcohesion.ofx4j.io.OFXV2ContentHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BaseOFXReader
implements OFXReader {
    private static final Log LOG = LogFactory.getLog(BaseOFXReader.class);
    public static final Pattern OFX_2_PROCESSING_INSTRUCTION_PATTERN = Pattern.compile("<\\?OFX ([^\\?]+)\\?>");
    private OFXHandler contentHandler = new DefaultHandler();

    public OFXHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(OFXHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void parse(InputStream stream) throws IOException, OFXParseException {
        this.parse(new InputStreamReader(stream, "utf-8"));
    }

    @Override
    public void parse(Reader reader) throws IOException, OFXParseException {
        reader = new BufferedReader(reader);
        StringBuilder header = new StringBuilder();
        char[] firstElementStart = this.getFirstElementStart();
        char[] buffer = new char[firstElementStart.length];
        reader.mark(firstElementStart.length);
        int ch = reader.read(buffer);
        while (ch != -1 && !Arrays.equals(buffer, firstElementStart)) {
            if (!this.contains(buffer, '<')) {
                reader.mark(firstElementStart.length);
            }
            ch = reader.read();
            char shifted = this.shiftAndAppend(buffer, (char)ch);
            header.append(shifted);
        }
        if (ch == -1) {
            throw new OFXParseException("Invalid OFX: no root <OFX> element!");
        }
        Matcher matcher = OFX_2_PROCESSING_INSTRUCTION_PATTERN.matcher(header);
        if (matcher.find()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Processing OFX 2 header...");
            }
            this.processOFXv2Headers(matcher.group(1));
            reader.reset();
            this.parseV2FromFirstElement(reader);
        } else {
            LOG.info((Object)"Processing OFX 1 headers...");
            this.processOFXv1Headers(header.toString());
            reader.reset();
            this.parseV1FromFirstElement(reader);
        }
    }

    protected char[] getFirstElementStart() {
        return new char[]{'<', 'O', 'F', 'X'};
    }

    private boolean contains(char[] buffer, char c) {
        for (char ch : buffer) {
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    private char shiftAndAppend(char[] buffer, char c) {
        char shifted = buffer[0];
        int i = 0;
        while (i + 1 < buffer.length) {
            buffer[i] = buffer[i + 1];
            ++i;
        }
        buffer[buffer.length - 1] = c;
        return shifted;
    }

    protected abstract void parseV1FromFirstElement(Reader var1) throws IOException, OFXParseException;

    protected void parseV2FromFirstElement(Reader reader) throws IOException, OFXParseException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xmlReader.setContentHandler(new OFXV2ContentHandler(this.getContentHandler()));
            xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            if (e.getCause() instanceof OFXParseException) {
                throw (OFXParseException)e.getCause();
            }
            throw new OFXParseException(e);
        }
    }

    protected void processOFXv1Headers(String chars) throws IOException, OFXParseException {
        BufferedReader reader = new BufferedReader(new StringReader(chars));
        String line = reader.readLine();
        while (line != null) {
            int colonIndex = line.indexOf(58);
            if (colonIndex >= 0) {
                String name = line.substring(0, colonIndex);
                String value = line.length() > colonIndex ? line.substring(colonIndex + 1) : "";
                value = value.replace('\"', ' ');
                value = value.replace('\'', ' ');
                value = value.trim();
                this.contentHandler.onHeader(name, value);
            }
            line = reader.readLine();
        }
    }

    protected void processOFXv2Headers(String chars) throws OFXParseException {
        String[] nameValuePairs;
        for (String nameValuePair : nameValuePairs = chars.split("\\s+")) {
            int equalsIndex = nameValuePair.indexOf(61);
            if (equalsIndex < 0) continue;
            String name = nameValuePair.substring(0, equalsIndex);
            String value = nameValuePair.length() > equalsIndex ? nameValuePair.substring(equalsIndex + 1) : "";
            value = value.replace('\"', ' ');
            value = value.replace('\'', ' ');
            value = value.trim();
            this.contentHandler.onHeader(name, value);
        }
    }
}

