/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.domain.data.common.Status;
import com.webcohesion.ofx4j.domain.data.common.StatusCode;
import com.webcohesion.ofx4j.domain.data.common.UnknownStatusCode;
import com.webcohesion.ofx4j.io.OFXSyntaxException;
import com.webcohesion.ofx4j.io.StringConversion;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Time;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DefaultStringConversion
implements StringConversion {
    public final TimeZone gmtTimeZone;
    public static final int DATE_FORMAT_LENGTH = "yyyyMMddHHmmss.SSS".length();
    public static final int TIME_FORMAT_LENGTH = "HHmmss.SSS".length();

    public DefaultStringConversion() {
        this.gmtTimeZone = TimeZone.getTimeZone("GMT");
    }

    public DefaultStringConversion(String gmt) {
        this.gmtTimeZone = TimeZone.getTimeZone(gmt);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isInstance(value)) {
            return (Boolean)value != false ? "Y" : "N";
        }
        if (Time.class.isInstance(value)) {
            return this.formatTime((Time)value);
        }
        if (Date.class.isInstance(value)) {
            return this.formatDate((Date)value);
        }
        return String.valueOf(value);
    }

    @Override
    public <E> E fromString(Class<E> clazz, String value) throws OFXSyntaxException {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (E)value;
        }
        if (StatusCode.class.isAssignableFrom(clazz)) {
            int code = 2000;
            try {
                code = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new OFXSyntaxException(e);
            }
            StatusCode statusCode = Status.KnownCode.fromCode(code);
            if (statusCode == null) {
                statusCode = new UnknownStatusCode(code, "Unknown status code.", Status.Severity.ERROR);
            }
            return (E)statusCode;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Enum.valueOf(clazz, value);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return (E)Boolean.valueOf("Y".equals(value.toUpperCase()));
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return (E)new Integer(Integer.parseInt(value));
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return (E)new Short(Short.parseShort(value));
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            String replacement = value.replace(',', '.');
            return (E)new Float(Float.parseFloat(replacement));
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            String replacement = value.replace(',', '.');
            return (E)new Double(Double.parseDouble(replacement));
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return (E)this.parseTime(value);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (E)this.parseDate(value);
        }
        if (URL.class.isAssignableFrom(clazz)) {
            try {
                return (E)new URL(value);
            }
            catch (MalformedURLException e) {
                throw new OFXSyntaxException(e);
            }
        }
        return (E)value;
    }

    protected Date parseDate(String value) {
        int index;
        char[] parseableDate = new char[DATE_FORMAT_LENGTH];
        Arrays.fill(parseableDate, '0');
        parseableDate[parseableDate.length - 4] = 46;
        char[] valueChars = value.toCharArray();
        for (index = 0; index < valueChars.length && valueChars[index] != '['; ++index) {
            if (index >= DATE_FORMAT_LENGTH) continue;
            parseableDate[index] = valueChars[index];
        }
        int year = Integer.parseInt(new String(parseableDate, 0, 4));
        int month = Integer.parseInt(new String(parseableDate, 4, 2)) - 1;
        int day = Integer.parseInt(new String(parseableDate, 6, 2));
        int hour = Integer.parseInt(new String(parseableDate, 8, 2));
        int minute = Integer.parseInt(new String(parseableDate, 10, 2));
        int second = Integer.parseInt(new String(parseableDate, 12, 2));
        int milli = Integer.parseInt(new String(parseableDate, 15, 3));
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute, second);
        if (index < valueChars.length && valueChars[index] == '[') {
            String tzoffset = value.substring(index);
            calendar.setTimeZone(this.parseTimeZone(tzoffset));
        } else {
            calendar.setTimeZone(this.gmtTimeZone);
        }
        calendar.add(14, milli);
        return calendar.getTime();
    }

    protected String formatDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(this.gmtTimeZone);
        calendar.setTime(date);
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.%1$tL", calendar);
    }

    protected Time parseTime(String value) {
        char[] parseableTime = new char[TIME_FORMAT_LENGTH];
        Arrays.fill(parseableTime, '0');
        parseableTime[parseableTime.length - 4] = 46;
        value.getChars(0, Math.min(parseableTime.length, value.length()), parseableTime, 0);
        int hour = Integer.parseInt(new String(parseableTime, 0, 2));
        int minute = Integer.parseInt(new String(parseableTime, 2, 2));
        int second = Integer.parseInt(new String(parseableTime, 4, 2));
        int milli = Integer.parseInt(new String(parseableTime, 7, 3));
        GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, hour, minute, second);
        if (value.length() > parseableTime.length) {
            String tzoffset = value.substring(parseableTime.length);
            calendar.setTimeZone(this.parseTimeZone(tzoffset));
        } else {
            calendar.setTimeZone(this.gmtTimeZone);
        }
        calendar.add(14, milli);
        return new Time(calendar.getTimeInMillis());
    }

    protected String formatTime(Time time) {
        GregorianCalendar calendar = new GregorianCalendar(this.gmtTimeZone);
        calendar.setTime(time);
        return String.format("%1$tH%1$tM%1$tS.%1$tL", calendar);
    }

    protected TimeZone parseTimeZone(String tzoffset) {
        StringTokenizer tokenizer = new StringTokenizer(tzoffset, "[]:");
        TimeZone tz = this.gmtTimeZone;
        if (tokenizer.hasMoreTokens()) {
            String hoursOff = tokenizer.nextToken();
            tz = TimeZone.getTimeZone("GMT" + hoursOff);
        }
        return tz;
    }

    public TimeZone getGmtTimeZone() {
        return this.gmtTimeZone;
    }
}

