/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io;

import com.webcohesion.ofx4j.io.OFXHandler;
import com.webcohesion.ofx4j.io.OFXParseEvent;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OFXV2ContentHandler
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog(OFXV2ContentHandler.class);
    private final Stack<OFXParseEvent> eventStack = new Stack();
    private final OFXHandler ofxHandler;
    private final List<OFXParseEvent> startedEvents = new ArrayList<OFXParseEvent>();

    public OFXV2ContentHandler(OFXHandler ofxHandler) {
        if (ofxHandler == null) {
            throw new IllegalArgumentException("An OFX handler must be supplied.");
        }
        this.ofxHandler = ofxHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("START ELEMENT: " + qName));
        }
        if (!this.eventStack.isEmpty() && this.eventStack.peek().getEventType() == OFXParseEvent.Type.ELEMENT && !this.isAlreadyStarted(this.eventStack.peek())) {
            String eventValue = this.eventStack.peek().getEventValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Element " + qName + " is starting aggregate " + eventValue));
            }
            try {
                this.ofxHandler.startAggregate(eventValue);
            }
            catch (OFXParseException e) {
                throw new SAXException(e);
            }
            this.startedEvents.add(this.eventStack.peek());
        }
        this.eventStack.push(new OFXParseEvent(OFXParseEvent.Type.ELEMENT, qName));
    }

    protected boolean isAlreadyStarted(OFXParseEvent event) {
        return this.startedEvents.contains(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        OFXParseEvent eventToFinish;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END ELEMENT: " + qName));
        }
        if ((eventToFinish = this.eventStack.pop()).getEventType() == OFXParseEvent.Type.CHARACTERS) {
            String chars = eventToFinish.getEventValue().trim();
            if (this.eventStack.isEmpty()) {
                throw new IllegalStateException("Illegal character data outside main OFX root element: \"" + chars + "\".");
            }
            OFXParseEvent elementEvent = this.eventStack.pop();
            if (elementEvent.getEventType() != OFXParseEvent.Type.ELEMENT) {
                throw new IllegalStateException("Illegal OFX event before characters \"" + chars + "\" (" + (Object)((Object)elementEvent.getEventType()) + ")!");
            }
            String value = elementEvent.getEventValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Element " + value + " processed with value " + chars));
            }
            try {
                this.ofxHandler.onElement(value, chars);
                return;
            }
            catch (OFXParseException e) {
                throw new SAXException(e);
            }
        }
        if (eventToFinish.getEventType() != OFXParseEvent.Type.ELEMENT) throw new IllegalStateException("Illegal OFX event: " + (Object)((Object)eventToFinish.getEventType()));
        if (!qName.equals(eventToFinish.getEventValue())) throw new IllegalStateException("Unexpected end tag: " + eventToFinish.getEventValue());
        String value = eventToFinish.getEventValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ending aggregate " + value));
        }
        try {
            this.ofxHandler.endAggregate(value);
        }
        catch (OFXParseException e) {
            throw new SAXException(e);
        }
        this.startedEvents.remove(eventToFinish);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (value.trim().length() > 0) {
            OFXParseEvent event = !this.eventStack.isEmpty() && this.eventStack.peek().getEventType() == OFXParseEvent.Type.CHARACTERS ? new OFXParseEvent(OFXParseEvent.Type.CHARACTERS, this.eventStack.pop().getEventValue() + value) : new OFXParseEvent(OFXParseEvent.Type.CHARACTERS, value);
            this.eventStack.push(event);
        }
    }
}

