/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io.nanoxml;

import com.webcohesion.ofx4j.io.BaseOFXReader;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import net.n3.nanoxml.CDATAReaderBackdoor;
import net.n3.nanoxml.ContentReaderBackdoor;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLUtilBackdoor;

public class NanoXMLOFXReader
extends BaseOFXReader {
    @Override
    protected void parseV1FromFirstElement(Reader reader) throws IOException, OFXParseException {
        try {
            StdXMLReader xmlReader = new StdXMLReader(reader);
            XMLUtilBackdoor.skipWhitespace(xmlReader, null);
            char ch = xmlReader.read();
            if (ch != '<') {
                throw new OFXParseException("Unexpected content before root <OFX> tag: " + ch);
            }
            String endTag = this.processOFXTag(xmlReader, new XMLEntityResolver());
            if (endTag.equals("OFX")) {
                while (!xmlReader.atEOF()) {
                    ch = xmlReader.read();
                    if (ch == ' ' || ch == '\t' || ch == '\n') continue;
                    throw new OFXParseException("Unexpected content after root <OFX> tag: " + ch);
                }
            }
        }
        catch (XMLParseException e) {
            throw new OFXParseException(e.getMessage(), e);
        }
    }

    protected String processOFXTag(IXMLReader reader, IXMLEntityResolver entityResolver) throws IOException, XMLParseException, OFXParseException {
        String startTag = this.readTagName(reader);
        StringBuffer buffer = new StringBuffer(16);
        boolean aggregateStarted = false;
        StringBuilder tagContent = null;
        while (!reader.atEOF()) {
            String str;
            while (true) {
                XMLUtilBackdoor.skipWhitespace(reader, buffer);
                str = XMLUtilBackdoor.read(reader, '&');
                if (str.charAt(0) != '&' || str.charAt(1) == '#') break;
                XMLUtilBackdoor.processEntity(str, reader, entityResolver);
            }
            if (str.charAt(0) == '<') {
                str = XMLUtilBackdoor.read(reader, '\u0000');
                if (str.charAt(0) == '/') {
                    XMLUtilBackdoor.skipWhitespace(reader, null);
                    String endTag = XMLUtilBackdoor.scanIdentifier(reader);
                    XMLUtilBackdoor.skipWhitespace(reader, null);
                    if (tagContent != null && tagContent.toString().trim().length() > 0) {
                        this.getContentHandler().onElement(startTag, tagContent.toString().trim());
                    }
                    if (reader.read() != '>') {
                        throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Non-empty closing tag.");
                    }
                    if (!startTag.equals(endTag) || aggregateStarted) {
                        this.getContentHandler().endAggregate(endTag);
                    }
                    return endTag;
                }
                if (str.charAt(0) == '!') {
                    str = XMLUtilBackdoor.read(reader, '&');
                    char ch = str.charAt(0);
                    switch (ch) {
                        case '&': {
                            throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Unexpected entity: " + str);
                        }
                        case '[': {
                            if (!XMLUtilBackdoor.checkLiteral(reader, "CDATA[")) {
                                throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Expected <![CDATA[");
                            }
                            String cdata = this.readCharacters(new CDATAReaderBackdoor(reader));
                            if (tagContent == null) {
                                tagContent = new StringBuilder(cdata);
                                break;
                            }
                            tagContent.append(cdata);
                            break;
                        }
                        default: {
                            throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Unexpected special tag: " + str);
                        }
                    }
                    continue;
                }
                reader.unread(str.charAt(0));
                if (tagContent == null || tagContent.toString().trim().length() == 0) {
                    String endTag;
                    if (!aggregateStarted) {
                        this.getContentHandler().startAggregate(startTag);
                        aggregateStarted = true;
                    }
                    if (!(endTag = this.processOFXTag(reader, entityResolver)).equals(startTag)) continue;
                    return endTag;
                }
                this.getContentHandler().onElement(startTag, tagContent.toString().trim());
                tagContent = null;
                startTag = this.readTagName(reader);
                continue;
            }
            if (str.charAt(0) == '&') {
                char ch = XMLUtilBackdoor.processCharLiteral(str);
                buffer.append(ch);
            } else {
                reader.unread(str.charAt(0));
            }
            String chars = this.readCharacters(new ContentReaderBackdoor(reader, entityResolver, buffer.toString()));
            if (tagContent == null) {
                tagContent = new StringBuilder(chars);
                continue;
            }
            tagContent.append(chars);
        }
        throw new OFXParseException("Unexpected EOF. We never finished parsing the " + startTag + " tag.");
    }

    protected String readTagName(IXMLReader reader) throws IOException, XMLParseException {
        String fullName = XMLUtilBackdoor.scanIdentifier(reader);
        XMLUtilBackdoor.skipWhitespace(reader, null);
        char ch = reader.read();
        if (ch != '>') {
            throw new IllegalStateException("Unexpected character '" + ch + "' after element name " + fullName + " on line " + reader.getLineNr() + ".");
        }
        return fullName;
    }

    protected String readCharacters(Reader contentReader) throws IOException {
        StringWriter contentWriter = new StringWriter();
        char[] contentBuffer = new char[200];
        int charsRead = contentReader.read(contentBuffer);
        while (charsRead != -1) {
            contentWriter.write(contentBuffer, 0, charsRead);
            charsRead = contentReader.read(contentBuffer);
        }
        contentReader.close();
        contentWriter.close();
        String tagContent = contentWriter.toString();
        return tagContent;
    }
}

