/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io.tagsoup;

import com.webcohesion.ofx4j.io.OFXHandler;
import com.webcohesion.ofx4j.io.OFXParseEvent;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagSoupHandler
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog(TagSoupHandler.class);
    private final Stack<OFXParseEvent> eventStack = new Stack();
    private final OFXHandler ofxHandler;
    private final List<OFXParseEvent> startedEvents = new ArrayList<OFXParseEvent>();

    public TagSoupHandler(OFXHandler ofxHandler) {
        if (ofxHandler == null) {
            throw new IllegalArgumentException("An OFX handler must be supplied.");
        }
        this.ofxHandler = ofxHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String lastElement;
        qName = qName.toUpperCase();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("START ELEMENT: " + qName));
        }
        try {
            lastElement = this.processLastCharactersIfNecessary();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (lastElement == null && !this.eventStack.isEmpty() && this.eventStack.peek().getEventType() == OFXParseEvent.Type.ELEMENT && !this.isStarted(this.eventStack.peek())) {
            String eventValue = this.eventStack.peek().getEventValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Element " + qName + " is starting aggregate " + eventValue));
            }
            try {
                this.ofxHandler.startAggregate(eventValue);
            }
            catch (OFXParseException e) {
                throw new SAXException(e);
            }
            this.startedEvents.add(this.eventStack.peek());
        }
        this.eventStack.push(new OFXParseEvent(OFXParseEvent.Type.ELEMENT, qName));
    }

    protected boolean isStarted(OFXParseEvent event) {
        return this.startedEvents.contains(event);
    }

    protected String processLastCharactersIfNecessary() throws IOException, SAXException {
        if (!this.eventStack.isEmpty() && this.eventStack.peek().getEventType() == OFXParseEvent.Type.CHARACTERS) {
            String chars = this.eventStack.pop().getEventValue().trim();
            if (this.eventStack.isEmpty()) {
                throw new IllegalStateException("Illegal character data outside main OFX root element: \"" + chars + "\".");
            }
            OFXParseEvent elementEvent = this.eventStack.pop();
            if (elementEvent.getEventType() != OFXParseEvent.Type.ELEMENT) {
                throw new IllegalStateException("Illegal OFX event before characters \"" + chars + "\" (" + (Object)((Object)elementEvent.getEventType()) + ")!");
            }
            String value = elementEvent.getEventValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Element " + value + " processed with value " + chars));
            }
            try {
                this.ofxHandler.onElement(value, chars);
            }
            catch (OFXParseException e) {
                throw new SAXException(e);
            }
            return value;
        }
        return null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String lastElement;
        qName = qName.toUpperCase();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END ELEMENT: " + qName));
        }
        try {
            lastElement = this.processLastCharactersIfNecessary();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (lastElement == null || !lastElement.equals(qName)) {
            if (this.eventStack.isEmpty()) {
                throw new IllegalStateException("End of element '" + qName + "' at an empty event stack.");
            }
            switch (this.eventStack.peek().getEventType()) {
                case CHARACTERS: {
                    throw new IllegalStateException("End of element '" + qName + "' with characters \"" + this.eventStack.peek().getEventValue() + "\" on the stack!");
                }
                case ELEMENT: {
                    if (!qName.equals(this.eventStack.peek().getEventValue())) break;
                    OFXParseEvent event = this.eventStack.pop();
                    String value = event.getEventValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Ending aggregate " + value));
                    }
                    try {
                        this.ofxHandler.endAggregate(value);
                    }
                    catch (OFXParseException e) {
                        throw new SAXException(e);
                    }
                    this.startedEvents.remove(event);
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (value.trim().length() > 0) {
            OFXParseEvent event = !this.eventStack.isEmpty() && this.eventStack.peek().getEventType() == OFXParseEvent.Type.CHARACTERS ? new OFXParseEvent(OFXParseEvent.Type.CHARACTERS, this.eventStack.pop().getEventValue() + value) : new OFXParseEvent(OFXParseEvent.Type.CHARACTERS, value);
            this.eventStack.push(event);
        }
    }
}

