/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io.v1;

import com.webcohesion.ofx4j.io.OFXWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

public class OFXV1Writer
implements OFXWriter {
    private static final String LINE_SEPARATOR = "\r\n";
    protected boolean headersWritten = false;
    protected final Writer writer;
    private boolean writeAttributesOnNewLine = false;

    public OFXV1Writer(OutputStream out) {
        try {
            this.writer = this.newWriter(out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public OFXV1Writer(Writer writer) {
        this.writer = writer;
    }

    protected OutputStreamWriter newWriter(OutputStream out) throws UnsupportedEncodingException {
        return new OutputStreamWriter(out, "ISO-8859-1");
    }

    @Override
    public void writeHeaders(Map<String, String> headers) throws IOException {
        if (this.headersWritten) {
            throw new IllegalStateException("Headers have already been written!");
        }
        this.println("OFXHEADER:100");
        this.println("DATA:OFXSGML");
        this.println("VERSION:102");
        this.print("SECURITY:");
        String security = headers.get("SECURITY");
        if (security == null) {
            security = "NONE";
        }
        this.println(security);
        this.println("ENCODING:USASCII");
        this.println("CHARSET:1252");
        this.println("COMPRESSION:NONE");
        this.print("OLDFILEUID:");
        String olduid = headers.get("OLDFILEUID");
        if (olduid == null) {
            olduid = "NONE";
        }
        this.println(olduid);
        this.print("NEWFILEUID:");
        String uid = headers.get("NEWFILEUID");
        if (uid == null) {
            uid = "NONE";
        }
        this.println(uid);
        this.println();
        this.headersWritten = true;
    }

    @Override
    public void writeStartAggregate(String aggregateName) throws IOException {
        this.print('<');
        this.print(aggregateName);
        this.print('>');
        if (this.isWriteAttributesOnNewLine()) {
            this.println();
        }
    }

    @Override
    public void writeElement(String name, String value) throws IOException {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Illegal element value for element '" + name + "' (value must not be null or empty).");
        }
        if (value.indexOf(38) >= 0) {
            value = value.replaceAll("\\&", "&amp;");
        }
        if (value.indexOf(60) >= 0) {
            value = value.replaceAll("<", "&lt;");
        }
        if (value.indexOf(62) >= 0) {
            value = value.replaceAll(">", "&gt;");
        }
        this.print('<');
        this.print(name);
        this.print('>');
        this.print(value);
        if (this.isWriteAttributesOnNewLine()) {
            this.println();
        }
    }

    @Override
    public void writeEndAggregate(String aggregateName) throws IOException {
        this.print("</");
        this.print(aggregateName);
        this.print('>');
        if (this.isWriteAttributesOnNewLine()) {
            this.println();
        }
    }

    public boolean isWriteAttributesOnNewLine() {
        return this.writeAttributesOnNewLine;
    }

    public void setWriteAttributesOnNewLine(boolean writeAttributesOnNewLine) {
        this.writeAttributesOnNewLine = writeAttributesOnNewLine;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void println(String line) throws IOException {
        this.print(line);
        this.println();
    }

    protected void println() throws IOException {
        this.writer.write(LINE_SEPARATOR);
    }

    protected void print(String line) throws IOException {
        this.writer.write(line == null ? "null" : line);
    }

    protected void print(char ch) throws IOException {
        this.writer.write(ch);
    }
}

